package com.tomastc.ht_nki.lib;

import android.content.ContentResolver;
import android.content.Context;
import android.util.Log;
import android.widget.Toast;

import androidx.documentfile.provider.DocumentFile;

import com.tomastc.ht_nki.ListData.Factory_list;
import com.tomastc.ht_nki.ListData.ItemMaster_list;
import com.tomastc.ht_nki.ListData.Location_list;
import com.tomastc.ht_nki.ListData.PackingStandard_list;
import com.tomastc.ht_nki.ListData.Supplier_list;
import com.tomastc.ht_nki.R;
import com.tomastc.ht_nki.lib.common.AsyncFtpClient;
import com.tomastc.ht_nki.lib.common.AsyncHttpClient;
import com.tomastc.ht_nki.lib.common.FileUtil;
import com.tomastc.ht_nki.lib.common.Utils;

import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Settings {

    private static Context context;

    private static final String SETTING_PATH = "skt";
    private static final String LOG_PATH = "log";

    private static final String MANAGEMENT_INFO = "MngInfo.csv";
    private static final String SETTING_INFO = "Settings.csv";
    private static final String USER_INFO = "UserInfo.csv";

    private static Map<String, String> mgmtList = new HashMap<String, String>();
    private static Map<String, String> settingList = new HashMap<String, String>();
    private static Map<String, String> usrList = new HashMap<String, String>();
    private static Map<String, Location_list>map_location = new HashMap<>();
    private static List<String>list_location = new ArrayList<>();
    private static Map<String, Factory_list>map_factory = new HashMap<>();

    private static List<String>list_factory= new ArrayList<>();
    private static Map<String, ItemMaster_list>map_items = new HashMap<>();
    private static List<String>list_item = new ArrayList<>();
    private static List<String>list_item_add = new ArrayList<>();
    private static List<String>sub_item = new ArrayList<>();
    private static List<String> stock_check_item = new ArrayList<>();
    public static List<String> getSub_item() {
        return sub_item;
    }

    public static void setSub_item(List<String> sub_item) {
        Settings.sub_item = sub_item;
    }

    private static Map<String, Supplier_list>map_supplier = new HashMap<>();
    private static List<String>list_supplier= new ArrayList<>();
    private static Map<String, PackingStandard_list>map_packing = new HashMap<>();

    private static JSONObject JS_label_detail;
    private static User loginUser;
    private static String ACTION_TYPE;
    public static void readManagementFile(File dir) throws IOException {
        try {
            // clear list first
            mgmtList.clear();

            String raw = FileUtil.readFile(MANAGEMENT_INFO, dir.getAbsolutePath());

            String[] lines = raw.split(System.getProperty("line.separator"));
            int i = 0;
            for (String line : lines) {
                Log.d(Settings.context.getString(R.string.tag), "read line:" + line);
                String[] values = line.split(",");
                try {
                    mgmtList.put(values[0], values[1]);
                    i++;
                } catch (Exception e) {
                    Log.d(Settings.context.getString(R.string.tag), "line format error!");
                }
            }

            if (lines.length == 0 || i==0) {
                throw new IOException("file format error");
            }
        } catch (IOException ioe) {
            Log.d(Settings.context.getString(R.string.tag), "cannot read file, error:" + ioe.getMessage());
            throw ioe;
        }
    }

    public static void readManagementFile(DocumentFile path, ContentResolver contentResolver) {

        // read manager file
        Log.d(Settings.context.getString(R.string.tag), "open file:" + MANAGEMENT_INFO);
        DocumentFile mgmtFile = path.findFile(MANAGEMENT_INFO);
        if (mgmtFile.exists() && mgmtFile.canRead()) {
            try {
                String raw = FileUtil.readTextFromUri(mgmtFile.getUri(), contentResolver);
                Log.d(Settings.context.getString(R.string.tag), "file content:" + raw);

                String[] lines = raw.split(System.getProperty("line.separator"));
                for (String line : lines) {
                    String[] values = line.split("=");
                    mgmtList.put(values[0], values[1]);
                }
            } catch (IOException ioe) {
                Log.d(Settings.context.getString(R.string.tag), "cannot read file, error:" + ioe.getMessage());
            }
        } else {
            Log.i("SKT", "file not found![" + MANAGEMENT_INFO + "]");
        }

    }

    public static void readSettingFile(File dir) {
        try {
            // clear list first
            settingList.clear();

            String raw = FileUtil.readFile(SETTING_INFO, dir.getAbsolutePath());

            String[] lines = raw.split(System.getProperty("line.separator"));
            int i = 0;
            for (String line : lines) {
                Log.d(Settings.context.getString(R.string.tag), "read line:" + line);
                String[] values = line.split(",");
                try {
                    settingList.put(values[0], values[1]);
                    i++;
                } catch (Exception e) {
                    Log.d(Settings.context.getString(R.string.tag), "line format error!");
                }
            }

            if (lines.length == 0 || i==0) {
                throw new IOException("file format error");
            }
        } catch (IOException ioe) {
            Log.d(Settings.context.getString(R.string.tag), "cannot read file, error:" + ioe.getMessage());
        }
    }

    public static void readSettingFile(DocumentFile path, ContentResolver contentResolver) {

        // read setting file
        Log.d(Settings.context.getString(R.string.tag), "open file:" + SETTING_INFO);
        DocumentFile settingInfoFile = path.findFile(SETTING_INFO);
        if (settingInfoFile.exists() && settingInfoFile.canRead()) {
            try {
                String raw = FileUtil.readTextFromUri(settingInfoFile.getUri(), contentResolver);
                Log.d(Settings.context.getString(R.string.tag), "file content:" + raw);

                String[] lines = raw.split(System.getProperty("line.separator"));
                int i = 0;
                for (String line : lines) {
                    String[] values = line.split(",");
                    settingList.put(values[0], values[1]);
                }
            } catch (IOException ioe) {
                Log.d(Settings.context.getString(R.string.tag), "cannot read file, error:" + ioe.getMessage());
            }
        } else {
            Log.i("SKT", "file not found![" + SETTING_INFO + "]");
        }
    }

    public static void readUserInfoFile(File dir) throws IOException {
        try {
            // clear list first
            usrList.clear();

            String raw = FileUtil.readFile(USER_INFO, dir.getAbsolutePath());

            String[] lines = raw.split(System.getProperty("line.separator"));
            int i = 0;
            for (String line : lines) {
                Log.d(Settings.context.getString(R.string.tag), "read line:" + line);
                String[] values = line.split(",");
                try {
                    usrList.put(values[0], values[1]);
                    i++;
                } catch (Exception e) {
                    Log.d(Settings.context.getString(R.string.tag), "line format error!");
                }
            }

            if (lines.length == 0 || i==0) {
                throw new IOException("file format error");
            }
        } catch (IOException ioe) {
            Log.d(Settings.context.getString(R.string.tag), "cannot read file, error:" + ioe.getMessage());
            throw ioe;
        }
    }

    public static void readUserInfoFile(DocumentFile path, ContentResolver contentResolver) {

        // read user info file
        Log.d(Settings.context.getString(R.string.tag), "open file:" + USER_INFO);
        DocumentFile userInfoFile = path.findFile(USER_INFO);
        if (userInfoFile.exists() && userInfoFile.canRead()) {
            try {
                String raw = FileUtil.readTextFromUri(userInfoFile.getUri(), contentResolver);
                Log.d(Settings.context.getString(R.string.tag), "file content:" + raw);

                String[] lines = raw.split(System.getProperty("line.separator"));
                for (String line : lines) {
                    String[] values = line.split(",");
                    usrList.put(values[0], values[1]);
                }
            } catch (IOException ioe) {
                Log.d(Settings.context.getString(R.string.tag), "cannot read file, error:" + ioe.getMessage());
            }
        } else {
            Log.i("SKT", "file not found![" + USER_INFO + "]");
        }
    }

    public static void updateSettingsFile(Map<String, String> settingList, String path) {
        Settings.settingList = settingList;

        Log.d(Settings.context.getString(R.string.tag), "write settings file...");
        try {
            FileUtil.writeFile(SETTING_INFO, path, Utils.mapToCsv((HashMap) settingList));
        } catch (IOException ioe) {
            Log.d(Settings.context.getString(R.string.tag), "cannot write file, error:" + ioe.getMessage());
        }
    }

    public static void init(Context context) {
        Settings.context = context;
        
        readSettingFile(context.getFilesDir());

        String localDir = context.getFilesDir().getAbsolutePath();

        // load manager setting
        try {
            readManagementFile(context.getFilesDir());
        } catch (Exception ioe) {
            try {
                if (Settings.getServerMode().equalsIgnoreCase("http")) {
                    new AsyncHttpClient(
                            context
                            ,Settings.getServer() + "/" + Settings.getPath() + "/" + Settings.getManagementInfo()
                            , ""
                    ) {
                        @Override
                        public void onFinished(String response, int resp_code) {
                            Log.d(Settings.context.getString(R.string.tag), "response: " + response);
                            Log.d(Settings.context.getString(R.string.tag), "write management info file...");
                            try {
                                FileUtil.writeFile(MANAGEMENT_INFO, context.getFilesDir().getAbsolutePath(), response);
                            } catch (IOException ioe) {
                                Log.d(Settings.context.getString(R.string.tag), "cannot write file, error:" + ioe.getMessage());
                            }
                        }
                    }
                            .execute();
                } else {
                    new AsyncFtpClient(new AsyncFtpClient.TaskListener() {
                        @Override
                        public void onFinished(String result) {
                            // Do Something after the task has finished
                            try {
                                readManagementFile(context.getFilesDir());
                            } catch (IOException e) {
                                Log.d(Settings.context.getString(R.string.tag), "read Manager file error");
                            }
                        }
                    }).execute(Settings.getServer(), Settings.getUser(), Settings.getPassword(),
                            AsyncFtpClient.ACTION.DOWNLOAD,
                            localDir + "/" + Settings.getManagementInfo(),
                            Settings.getSettingList().get("path") +
                                    "/" + Settings.getManagementInfo());

                }
            } catch (Exception e) {
                Log.d(Settings.context.getString(R.string.tag), "download file failed");
            }
        }

        // load user setting
        try {
            readUserInfoFile(context.getFilesDir());
        } catch (Exception ioe) {

            try {

                if (Settings.getServerMode().equalsIgnoreCase("http")) {
                    new AsyncHttpClient(
                            context
                            ,Settings.getServer() + "/" + Settings.getPath() + "/" + Settings.getUserInfo()
                            , ""
                    ) {
                        @Override
                        public void onFinished(String response, int resp_code) {
                            Log.d(Settings.context.getString(R.string.tag), "response: " + response);
                            Log.d(Settings.context.getString(R.string.tag), "write user info file...");
                            try {
                                FileUtil.writeFile(USER_INFO, context.getFilesDir().getAbsolutePath(), response);
                            } catch (IOException ioe) {
                                Log.d(Settings.context.getString(R.string.tag), "cannot write file, error:" + ioe.getMessage());
                            }
                        }
                    }
                            .execute();
                } else {
                    new AsyncFtpClient(new AsyncFtpClient.TaskListener() {
                        @Override
                        public void onFinished(String result) {
                            // Do Something after the task has finished
                            try {
                                Toast.makeText(context, "Config files updated. Restart required!",
                                        Toast.LENGTH_LONG).show();
                                readUserInfoFile(context.getFilesDir());


                            } catch (IOException e) {
                                Log.d(Settings.context.getString(R.string.tag), "read User info file error");
                            }
                        }
                    }).execute(Settings.getServer(), Settings.getUser(), Settings.getPassword(),
                            AsyncFtpClient.ACTION.DOWNLOAD,
                            localDir + "/" + Settings.getUserInfo(),
                            Settings.getSettingList().get("path") +
                                    "/" + Settings.getUserInfo());
                }

            } catch (Exception e) {
                Log.d(Settings.context.getString(R.string.tag), "download file failed");
            }
        }
    }

    public static List<String> getList_item() {
        //return list_item;
        return  list_item_add;

    }

    public static void setList_item(List<String> list_item) {
        Settings.list_item = list_item;
    }

    public static List<String> getList_factory() {
        return list_factory;
    }

    public static void setList_factory(List<String> list_factory) {
        Settings.list_factory = list_factory;
    }

    public static JSONObject getJS_label_detail() {
        return JS_label_detail;
    }

    public static void setJS_label_detail(JSONObject JS_label_detail) {
        Settings.JS_label_detail = JS_label_detail;
    }

    public static Map<String, PackingStandard_list> getMap_packing() {
        return map_packing;
    }

    public static void setMap_packing(Map<String, PackingStandard_list> map_packing) {
        Settings.map_packing = map_packing;
    }

    public static Map<String, ItemMaster_list> getMap_items() {
        return map_items;
    }

    public static void setMap_items(Map<String, ItemMaster_list> map_items) {
        Settings.map_items = map_items;
    }

    public static Map<String, Supplier_list> getMap_supplier() {
        return map_supplier;
    }

    public static void setMap_supplier(Map<String, Supplier_list> map_supplier) {
        Settings.map_supplier = map_supplier;
    }

    public static Map<String, Location_list> getMap_location() {
        return map_location;
    }

    public static void setMap_location(Map<String, Location_list> map_location) {
        Settings.map_location = map_location;
    }

    public static List<String> getList_location() {
        return list_location;
    }

    public static void setList_location(List<String> list_location) {
        Settings.list_location = list_location;
    }


    public static List<String> getList_supplier() {
        return list_supplier;
    }

    public static void setList_supplier(List<String> list_supplier) {
        Settings.list_supplier = list_supplier;
    }
    public static Map<String, Factory_list> getMap_factory() {
        return map_factory;
    }

    public static void setMap_factory(Map<String, Factory_list> map_factory) {
        Settings.map_factory = map_factory;
    }

    public static String getActionType() {
        return ACTION_TYPE;
    }

    public static void setActionType(String actionType) {
        ACTION_TYPE = actionType;
    }
    public static Map<String, String> getMgmtList() {
        return mgmtList;
    }

    public static Map<String, String> getSettingList() {
        return settingList;
    }

    public static void setSettingList(Map<String, String> settingList) {
        Settings.settingList = settingList;
    }

    public static Map<String, String> getUsrList() {
        return usrList;
    }

    public static User getLoginUser() {
        return loginUser;
    }

    public static void setLoginUser(User loginUser) {
        Settings.loginUser = loginUser;
    }

    public static String getDeviceNo() {
        return Settings.settingList.get("device_no");
    }

    public static void setDeviceNo(String device_no) {
        Settings.settingList.put("device_no", device_no);
    }

    public static String getSettingPath() {
        return SETTING_PATH;
    }

    public static String getLogPath() {
        return LOG_PATH;
    }

    public static String getServerMode() {
        return Settings.settingList.get("server_mode");
    }

    public static void setServerMode(String server_mode) {
        Settings.settingList.put("server_mode", server_mode);
    }

    public static String getServer() {
        return Settings.settingList.get("server");
    }

    public static void setServer(String server) {
        Settings.settingList.put("server", server);
    }

    public static String getUser() {
        return Settings.settingList.get("user");
    }

    public static void setUser(String user) {
        Settings.settingList.put("user", user);
    }

    public static String getPassword() {
        return Settings.settingList.get("password");
    }

    public static void setPassword(String password) {
        Settings.settingList.put("password", password);
    }

    public static String getPath() {
        return Settings.settingList.get("path");
    }

    public static void setPath(String path) {
        Settings.settingList.put("path", path);
    }

    public static String getManagementInfo() {
        return MANAGEMENT_INFO;
    }

    public static String getSettingInfo() {
        return SETTING_INFO;
    }

    public static String getUserInfo() {
        return USER_INFO;
    }


    public static String getPrinter() {
        return Settings.settingList.get("printer");
    }

    public static String getFactory() {
        return Settings.settingList.get("factory");
    }

    public static void setPrinter(String printer) {
        Settings.settingList.put("printer", printer);
    }

    public static void removeAllFile(File dir) {
        String[] filename_ = {
                Settings.getUserInfo(),
                Settings.getManagementInfo(),
                Settings.getSettingInfo()};
        for (String filename : filename_) {
            File file = new File(dir, filename);
            if (file.exists()) {
                if (file.delete()) {
                    Log.i("SKT", "file removed :" + filename);
                } else {
                    Log.i("SKT", "remove failed :" + filename);
                }
            }
        }
    }

    public static void removeAllFileExceptSettings(File dir) {
        String[] filename_ = {
                Settings.getUserInfo(),
                Settings.getManagementInfo()};
        for (String filename : filename_) {
            File file = new File(dir, filename);
            if (file.exists()) {
                if (file.delete()) {
                    Log.i("SKT", "file removed :" + filename);
                } else {
                    Log.i("SKT", "remove failed :" + filename);
                }
            }
        }
    }


    public static List<String> getStock_check_item() {
        return stock_check_item;
    }

    public static void setStock_check_item(List<String> stock_check_item) {
        Settings.stock_check_item = stock_check_item;
    }







}
