package com.tomastc.ht_nki;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.tomastc.ht_nki.lib.ActionType;
import com.tomastc.ht_nki.lib.KeyMapping;
import com.tomastc.ht_nki.lib.Settings;

public class StockMenu_Activity extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device;
    Intent intent;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_stock_menu);
        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ Settings.getLoginUser().getName());

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Device : "+Settings.getDeviceNo());




    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.imb_back:
                finish();
                break;
            case R.id.btn_stock_check:
                Settings.setActionType(String.valueOf(ActionType.Type.LABEL_SCHEDULE));
                intent = new Intent(StockMenu_Activity.this, StockCheck_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_stocktaking:
                intent = new Intent(StockMenu_Activity.this, StocktakingLabel_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_change_location:
                Settings.setActionType(String.valueOf(ActionType.Type.INBOUND_SCHEDULE));
                intent = new Intent(StockMenu_Activity.this, ChangeLocation_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_tire_transfer:
                Settings.setActionType(String.valueOf(ActionType.Type.INBOUND_SCHEDULE));
                intent = new Intent(StockMenu_Activity.this, TireTransfer_Activity.class);
                startActivity(intent);
                break;
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId()) {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    finish();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }
}