package com.tomastc.ht_nki;

import static android.view.View.GONE;
import static android.view.View.VISIBLE;

import android.annotation.SuppressLint;
import android.graphics.Color;
import android.os.Bundle;
import android.text.InputType;
import android.util.Log;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.tomastc.ht_nki.Adapter.InboundQCItem_Detail_Adapter;
import com.tomastc.ht_nki.ListData.InboundQC_DetailItem_list;
import com.tomastc.ht_nki.ListData.Inbound_QC_LabelItem_list;
import com.tomastc.ht_nki.ListData.Location_list;
import com.tomastc.ht_nki.lib.ActionType;
import com.tomastc.ht_nki.lib.KeyMapping;
import com.tomastc.ht_nki.lib.Scanner;
import com.tomastc.ht_nki.lib.Settings;
import com.tomastc.ht_nki.lib.common.AsyncHttpClient;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class InboundQCScheduleDetail_Activity extends Scanner implements View.OnClickListener,ClickRowQCScheculeDetail {

    TextView txt_user, txt_device , txt_ticket_no ,txt_actual_plan , txt_part_name , txt_header,txt_qty_total;

    EditText edt_qty;
    String   str_ticket_no ,str_state ,str_id, str_action_act_qty , str_unit_qty , str_qty , str_parts_no , str_status , str_bc_tire , str_event ,str_location_list ,ButtonClick;
    Bundle bundle;

    Integer sum_total =0;
    Integer sum_total_order =0;

    String pub_unit="";

    DecimalFormat decimalFormat;
    Map<String, InboundQC_DetailItem_list> map_inboundQC_Detail_item;
    List<InboundQC_DetailItem_list> list_inboundQC_Detail_label;
    InboundQCItem_Detail_Adapter adapter;
    RecyclerView view_data;
    boolean b_confirm;
    Button btn_confirm,btn_ok,btn_cancel;
    boolean  clear_data , incorrect_data ,confirm_true_data;
    private RelativeLayout popupLayout4;
 Map<String, Inbound_QC_LabelItem_list>    map_label;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_inbound_qc_detail);

        list_inboundQC_Detail_label = new ArrayList<InboundQC_DetailItem_list>();
        map_inboundQC_Detail_item = new LinkedHashMap<>();
        map_label = new LinkedHashMap<>();

        b_confirm = false;
        clear_data = false;
        incorrect_data = false;
        confirm_true_data = false;
        btn_confirm = (Button) findViewById(R.id.btn_confirm);
        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ Settings.getLoginUser().getName());
        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Device : "+Settings.getDeviceNo());

        view_data = (RecyclerView) findViewById(R.id.view_data_inboundQC_detail);
        view_data.setHasFixedSize(true);
        view_data.setRecycledViewPool(new RecyclerView.RecycledViewPool());
        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        view_data.setLayoutManager(layoutManager);

        txt_actual_plan = (TextView) findViewById(R.id.txt_actual_plan);
        txt_part_name = (TextView) findViewById(R.id.txt_part_name);

        ButtonClick = ActionType.ButtonClick.NULL.toString();


        popupLayout4 = (RelativeLayout) findViewById(R.id.popupLayout4);
        popupLayout4.setVisibility(GONE);
        btn_ok = (Button) findViewById(R.id.btn_ok);
        btn_cancel = (Button) findViewById(R.id.btn_cancel);
        txt_qty_total = (TextView)findViewById(R.id.txt_qty_total);


        edt_qty = (EditText) findViewById(R.id.txt_qty);

        edt_qty.setOnKeyListener(new View.OnKeyListener() {
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                // If the event is a key-down event on the "enter" button
                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
                        (keyCode == KeyEvent.KEYCODE_ENTER)) {

                    btn_ok.performClick();


                    return true;
                }
                return false;
            }
        });
        btn_ok.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(edt_qty.getText().toString().length()>0) {


                    popupLayout4.setVisibility(GONE);
                    sum_total = 0;
                    Double act_qty = 0.00;

                    String unitname = "";
                    map_inboundQC_Detail_item.clear();

                    for (int i = 0; i < list_inboundQC_Detail_label.size(); i++) {


                        Double item_qty = Double.parseDouble(list_inboundQC_Detail_label.get(i).getQty().toString());
                        act_qty = item_qty;

                        String id = String.valueOf(i + 1);
                        unitname = list_inboundQC_Detail_label.get(i).getUnit_qty().toString();

                        if ((id + list_inboundQC_Detail_label.get(i).getBc_tire().toString()).equals(str_id)) {


                            Double edit_qty = Double.parseDouble(edt_qty.getText().toString());
                            if (edit_qty > item_qty && item_qty > 0) {

                                new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.WARNING_TYPE)
                                        .setTitleText("WARNING")
                                        .setContentText("The specified quantity is too high.")
                                        .show();


                                //break;


                            } else {


                                list_inboundQC_Detail_label.get(i).setQty(edt_qty.getText().toString());


                            }


                        }

                        map_inboundQC_Detail_item.put(list_inboundQC_Detail_label.get(i).getId().toString(),
                                new InboundQC_DetailItem_list(
                                        list_inboundQC_Detail_label.get(i).getId().toString().trim(),
                                        "",
                                        list_inboundQC_Detail_label.get(i).getOrder_no().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getTicket_no().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getParts_no().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getParts_name().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getQty().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getUnit_qty().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getAction_act_qty().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getStatus().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getLot_no().toString().trim(),
                                        list_inboundQC_Detail_label.get(i).getBc_tire().toString().trim()
                                ));


                        double parsedQty = Double.parseDouble(list_inboundQC_Detail_label.get(i).getQty().toString());
                        int intQty = (int) parsedQty;
                        sum_total = sum_total + intQty;
                    }
                    adapter = new InboundQCItem_Detail_Adapter(list_inboundQC_Detail_label, InboundQCScheduleDetail_Activity.this, InboundQCScheduleDetail_Activity.this);
                    view_data.setAdapter(adapter);


                    txt_actual_plan.setText("Actual / Plan :\n" + "0 / " + sum_total_order.toString() + " " + unitname);
                }
            }
        });


        btn_cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                popupLayout4.setVisibility(GONE);
                edt_qty.setText("");
            }
        });

    }

    @Override
    protected void onStart() {
        super.onStart();
        bundle = getIntent().getExtras();
        str_ticket_no = bundle.getString("ticket_no");
        str_state = bundle.getString("state");
        txt_ticket_no = (TextView) findViewById(R.id.txt_ticket_no);
        txt_ticket_no.setText(str_ticket_no);

        if (Objects.equals(str_state, "click")){
            load_inbound_qc_detail();
        }else {
            load_inbound_qc_detail_scan();
        }

    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.imb_back:
                finish();
                break;
            case R.id.btn_clear:
                event_clear();
                break;
            case R.id.btn_confirm:
                event_confirm();
                ButtonClick = ActionType.ButtonClick.CONFIRM.toString();
                break;
        }
    }

    private void load_inbound_qc_detail() {
        map_inboundQC_Detail_item.clear();

        try {
            JSONObject json = new JSONObject();
            json.put("cmd", "INBOUND/QC/DETAIL");
            json.put("ticket_no", str_ticket_no);

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api") + "/ht_api.php",
                    json.toString()
            ) {
                @SuppressLint("StaticFieldLeak")
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response inbound detail: " + response);

                    try {

                        JSONObject jsonObject = new JSONObject(response);
                        String value = jsonObject.getString("value");
                        JSONArray jArray = new JSONArray(value);

                        if (jArray.length() == 0) {
                            Toast.makeText(InboundQCScheduleDetail_Activity.this, "Not found schedule", Toast.LENGTH_SHORT).show();
                            //dialog_massage_not_match();
                        }else {

                            txt_ticket_no.setText(str_ticket_no);
                            Toast.makeText(InboundQCScheduleDetail_Activity.this, "schedule", Toast.LENGTH_SHORT).show();
                            Log.d("TOT","Data length  sum: "+jArray.length());
                            for(int i = 0; i < jArray.length(); i++){
                                Log.d("TOT","Data length : "+jArray.get(i));
                                sum_total = sum_total + jArray.getJSONObject(i).getInt("action_act_qty");
                                sum_total_order = sum_total_order + jArray.getJSONObject(i).getInt("qty");
                                map_inboundQC_Detail_item.put( jArray.getJSONObject(i).getString("id").trim(),
                                        new InboundQC_DetailItem_list(
                                                jArray.getJSONObject(i).getString("id").trim(),
                                                "",
                                                jArray.getJSONObject(i).getString("order_no").trim(),
                                                jArray.getJSONObject(i).getString("ticket_no").trim(),
                                                jArray.getJSONObject(i).getString("parts_no").trim(),
                                                jArray.getJSONObject(i).getString("parts_name").trim(),
                                                jArray.getJSONObject(i).getString("status").trim().contains("WORKING")?jArray.getJSONObject(i).getString("action_act_qty").trim():jArray.getJSONObject(i).getString("qty").trim(),
                                                jArray.getJSONObject(i).getString("unit_qty").trim(),
                                                jArray.getJSONObject(i).getString("action_act_qty").trim(),
                                                jArray.getJSONObject(i).getString("status").trim(),
                                                jArray.getJSONObject(i).getString("lot_no").trim(),
                                                jArray.getJSONObject(i).getString("bc_tire").trim()
                                        ));
                            }
                        }

                        set_view_schedule();

                    }catch (JSONException e) {
                        new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();

        }catch (JSONException e) {
            new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }
    private void load_inbound_qc_detail_scan() {

        map_inboundQC_Detail_item.clear();
        try {
            JSONObject json = new JSONObject();
            json.put("cmd", "INBOUND/QC/DETAIL");
            json.put("ticket_no", str_ticket_no);

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api") + "/ht_api.php",
                    json.toString()
            ) {
                @SuppressLint("StaticFieldLeak")
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response inbound detail: " + response);
                    try {

                        JSONObject jsonObject = new JSONObject(response);
                        String value = jsonObject.getString("value");
                        JSONArray jArray = new JSONArray(value);

                        if (jArray.length() == 0 ) {
                            dialog_massage_not_match();
                            //Toast.makeText(InboundQCScheduleDetail_Activity.this, "Not found schedule", Toast.LENGTH_SHORT).show();
                        }else {
                            String status_label = jArray.getJSONObject(0).getString("status").trim();


                            for(int i = 0; i < jArray.length(); i++){
                                Log.d("TOT","Data length : "+jArray.get(i));
                                sum_total = sum_total + jArray.getJSONObject(i).getInt("action_act_qty");
                                sum_total_order = sum_total_order + jArray.getJSONObject(i).getInt("qty");
                                map_inboundQC_Detail_item.put( jArray.getJSONObject(i).getString("id").trim(),
                                        new InboundQC_DetailItem_list(
                                                jArray.getJSONObject(i).getString("id").trim(),
                                                "",
                                                jArray.getJSONObject(i).getString("order_no").trim(),
                                                jArray.getJSONObject(i).getString("ticket_no").trim(),
                                                jArray.getJSONObject(i).getString("parts_no").trim(),
                                                jArray.getJSONObject(i).getString("parts_name").trim(),
                                                jArray.getJSONObject(i).getString("status").trim().contains("WORKING")?jArray.getJSONObject(i).getString("action_act_qty").trim():jArray.getJSONObject(i).getString("qty").trim(),
                                                jArray.getJSONObject(i).getString("unit_qty").trim(),
                                                jArray.getJSONObject(i).getString("action_act_qty").trim(),
                                                jArray.getJSONObject(i).getString("status").trim(),
                                                jArray.getJSONObject(i).getString("lot_no").trim(),
                                                jArray.getJSONObject(i).getString("bc_tire").trim()
                                        ));
                            }

                        }

                    set_view_schedule_scan();

                    }catch (JSONException e) {
                        new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();

        }catch (JSONException e) {
            new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }
    private void event_confirm(){
//        if (clear_data){
//            dialog_massage_insufficient();
//        }

        confirm_inbound_qc();
//        if (confirm_true_data){
//            confirm_inbound_qc();
//        }

    }
    private void event_clear(){
        txt_ticket_no.setText("");
        txt_actual_plan.setText("Actual / Plan :\n"+ "0.00 / 0.00  PCS");
        txt_part_name.setText("");
        txt_part_name.setBackgroundResource(R.drawable.button_background_gray);
        txt_part_name.setTextColor(Color.BLACK);
        adapter.notifyDataSetChanged();

        b_confirm = false;
        clear_data =true;
        incorrect_data = false;
        confirm_true_data = false;
        map_inboundQC_Detail_item.clear();
        list_inboundQC_Detail_label.clear();
        sum_total=0;
        sum_total_order=0;
        pub_unit="";
    }
    private void confirm_inbound_qc() {
        try {
            JSONObject json = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            Map<String, String> jsonParams = new HashMap<>();

            String Location_QC_id = "";
            for (String kk : Settings.getMap_location().keySet()) {
                Location_list location_list = Settings.getMap_location().get(kk);
               if (location_list.getQc_area().trim().equals("1")){
                   Location_QC_id = location_list.getId();
                Log.d(getString(R.string.tag),"*****>>> id List : "+ Location_QC_id);
                break;
            }
        }
            if(sum_total==0)
            {

                sum_total = sum_total_order;

            }

            for (String key : map_inboundQC_Detail_item.keySet()){
                InboundQC_DetailItem_list  item = map_inboundQC_Detail_item.get(key);
                    Log.d("Log data ",item.getId().trim());

                    jsonParams.put("ref_sch_id", item.getId());
                    jsonParams.put("create_user_id", Settings.getLoginUser().getName());
                    jsonParams.put("item_id", item.getParts_no());
                    jsonParams.put("unit_qty", item.getUnit_qty());
                    jsonParams.put("item_name", item.getParts_name());
                    jsonParams.put("package_id", item.getUnit_qty());
                    jsonParams.put("location_id", Location_QC_id);
                    jsonParams.put("location_name", Location_QC_id);
                    jsonParams.put("package_qty", item.getQty());
                    jsonParams.put("lot_no", item.getLot_no());
                    jsonParams.put("order_no", item.getOrder_no().contains("null")?"":item.getOrder_no() );
                    jsonParams.put("qty", item.getQty());
                    jsonParams.put("slip_divide", "0");
                    jsonParams.put("ng", "0");
                    jsonParams.put("supplier_name", "");
                    jsonParams.put("inspection_flg", "0");
                    jsonParams.put("supplier_id", "0");
                    jsonParams.put("label_id", "1");
                    jsonParams.put("status", "1");
                    jsonParams.put("ticket_no",item.getTicket_no().trim().trim());
                    jsonParams.put("bc_tire", item.getBc_tire().trim());
                    jsonParams.put("process_type", "QC");
                    jsonParams.put("act_qty",sum_total.toString());
                    jsonParams.put("order_qty", sum_total_order.toString());
                    jsonParams.put("userid",Settings.getLoginUser().getName().toString());



                    JSONObject jsonObj = new JSONObject(jsonParams);
                    jsonArray.put(jsonObj);
            }

            ///===> Request
            json.put("cmd", "INBOUND/QC/CONFIRM");
            json.put("value",jsonArray);
            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api") + "/ht_api.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.e("T-T","Data Response : " +response);
                    try {
                        JSONObject jsonObject = new JSONObject(response);

                        int affectedRows = jsonObject.getInt("affected_rows");

                        if (affectedRows == 0) {
                            Log.d("JSON", "Affected rows: " + affectedRows);
                            dialog_massage_insufficient();
                        } else {
                            Log.d("JSON", "Operation completed!");
                            dialog_massage_complete();
                        }
                    }catch (JSONException e) {
                        new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("Can not connect server.")
                                .setContentText(e.getMessage())
                                .show();
                    }


                }
            }.execute();
        }catch (Exception e) {
            new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("Can not connect server.")
                    .setContentText(e.getMessage())
                    .show();


        }
    }
    private void  location_list(){
//        String jArray = Settings.getMap_location().toString();
//        Map<String, String> jsonParams;
//        jsonParams = new HashMap<>();
//        for (String key : map_location_list_item.keySet()) {
//            Location_list item = map_location_list_item.get(key);
//            list_item_location_list.add(new Location_list(
//                    item.getId(),
//                    item.getName(),
//                    item.getFactory_code(),
//                    item.getSection_id(),
//                    item.getDescription(),
//                    item.getQc_area()  ));
//
//        }

        ///get location list
        String Location_QC = "";
        for (String kk : Settings.getMap_location().keySet()){
            Location_list location_list = Settings.getMap_location().get(kk);
            for (int i=0 ; i <kk.length() ; i++){
                String  test = Settings.getList_location().get(i);
                Log.d(getString(R.string.tag),"Location"+ i + " : "+ test);
            }
//            if (location_list.getQc_area().trim().equals("0")){
//                Location_QC = location_list.getId();
//                Log.d(getString(R.string.tag),"Location List : "+ Location_QC);
//                break;
//            }
        }








    }
    private void set_view_schedule(){

        list_inboundQC_Detail_label.clear();

        int no = 0;

        String value_unit_qty = "";
        boolean hasCompleteStatus = false;

        for (String key : map_inboundQC_Detail_item.keySet()) {
            no = (no + 1);
            InboundQC_DetailItem_list item = map_inboundQC_Detail_item.get(key);


            txt_ticket_no.setText(item.getTicket_no());
            if(item.getStatus().contains("WORKING"))
            {
                txt_part_name.setText("Working");
                txt_part_name.setBackgroundResource(R.drawable.button_background_yellow);
                txt_part_name.setTextColor(Color.BLACK);

            }

                hasCompleteStatus = true;
                list_inboundQC_Detail_label.add(new InboundQC_DetailItem_list(
                        item.getId(),
                        String.valueOf(no),
                        item.getOrder_no(),
                        item.getTicket_no(),
                        item.getParts_no(),
                        item.getParts_name(),
                        item.getQty(),
                        item.getUnit_qty(),
                        item.getAction_act_qty(),
                        item.getStatus(),
                        item.getLot_no(),
                        item.getBc_tire()
                ));

        }
        ///check status button confirm
        confirm_true_data = true;


          pub_unit = value_unit_qty;
          if (hasCompleteStatus){
              txt_actual_plan.setText("Actual / Plan :\n" +sum_total.toString()+ " / " +  sum_total_order.toString() + " " +value_unit_qty);
          }else {
              txt_ticket_no.setText("");
              txt_actual_plan.setText("Actual / Plan :\n"+ "0 / 0  PCS");
              //dialog_massage_not_match();
          }

        Log.d("TOT","Data Map List  set view :"+list_inboundQC_Detail_label.size());
      adapter = new InboundQCItem_Detail_Adapter(list_inboundQC_Detail_label , InboundQCScheduleDetail_Activity.this,InboundQCScheduleDetail_Activity.this);
      view_data.setAdapter(adapter);
      dialog_massage_complete();
    }
    private void set_view_schedule_scan(){

        list_inboundQC_Detail_label.clear();

        int no = 0;
        String value_unit_qty = "";
        boolean hasCompleteStatus = false;

        for (String key : map_inboundQC_Detail_item.keySet()) {
            no = (no + 1);
            InboundQC_DetailItem_list item = map_inboundQC_Detail_item.get(key);
            value_unit_qty = String.valueOf(item.getUnit_qty());

            if(item.getStatus().contains("WORKING"))
            {
                txt_part_name.setText("Working");
                txt_part_name.setBackgroundResource(R.drawable.button_background_yellow);
                txt_part_name.setTextColor(Color.BLACK);

            }
            //if (item.getStatus().equals("IMPORTED")){
                hasCompleteStatus = true;
                list_inboundQC_Detail_label.add(new InboundQC_DetailItem_list(
                        item.getId(),
                        String.valueOf(no),
                        item.getOrder_no(),
                        item.getTicket_no(),
                        item.getParts_no(),
                        item.getParts_name(),
                        item.getQty(),
                        item.getUnit_qty(),
                        item.getAction_act_qty(),
                        item.getStatus(),
                        item.getLot_no(),
                        item.getBc_tire()
                ));
            //}
        }

           txt_ticket_no.setText(str_ticket_no);

        pub_unit = value_unit_qty;
        if (hasCompleteStatus){
            txt_actual_plan.setText("Actual / Plan :\n" +sum_total.toString()+ " / " +  sum_total_order.toString() + " " +value_unit_qty);
        }else {
            txt_ticket_no.setText("");
            txt_actual_plan.setText("Actual / Plan :\n"+ "0 / 0  PCS");
            //dialog_massage_not_match();
        }


        Log.d("TOT","Data Map List  set view :"+list_inboundQC_Detail_label.size());
      adapter = new InboundQCItem_Detail_Adapter(list_inboundQC_Detail_label , InboundQCScheduleDetail_Activity.this,InboundQCScheduleDetail_Activity.this);
      view_data.setAdapter(adapter);
      dialog_massage_complete();
    }
    private void dialog_massage_not_match(){

        TextView customTextView = new TextView(InboundQCScheduleDetail_Activity.this);
        customTextView.setText("Ticket No do not match");
        customTextView.setTextColor(Color.RED);
        customTextView.setTextSize(16);
        customTextView.setGravity(Gravity.CENTER);

        new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.WARNING_TYPE)
                .setTitleText("WARNING")
                //.setContentText("Ticket No do not match")
                .setCustomView(customTextView)
                .setConfirmText("NG")
                .setConfirmButtonBackgroundColor(Color.RED)
                .show();


    }
    private void dialog_massage_insufficient(){
        TextView customTextView = new TextView(InboundQCScheduleDetail_Activity.this);
        customTextView.setText("Insufficient information");
        customTextView.setTextColor(Color.RED);
        customTextView.setTextSize(16);
        customTextView.setGravity(Gravity.CENTER);

        new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.WARNING_TYPE)
                .setTitleText("WARNING")
                //.setContentText("Ticket No do not match")
                .setCustomView(customTextView)
                .setConfirmText("NG")
                .setConfirmButtonBackgroundColor(Color.RED)
                .show();
    }
    private void dialog_massage_complete(){
        new SweetAlertDialog(InboundQCScheduleDetail_Activity.this, SweetAlertDialog.SUCCESS_TYPE)
                .setConfirmClickListener(new SweetAlertDialog.OnSweetClickListener() {
                    @Override
                    public void onClick(SweetAlertDialog sDialog) {
                        if (sum_total!=sum_total_order){
                            txt_part_name.setText("Working");
                            txt_part_name.setBackgroundResource(R.drawable.button_background_yellow);
                            txt_part_name.setTextColor(Color.BLACK);
                            sDialog.dismiss();
                        }else {
                            txt_part_name.setText("CONFIRMED");
                            txt_part_name.setBackgroundResource(R.drawable.button_background_green);
                            txt_part_name.setTextColor(Color.BLACK);
                            sDialog.dismiss();
                       }

                    }

                })
                .setTitleText("INFORMATION")
                .setContentText("Operation complete!")
                .show();
                 txt_actual_plan.setText("Actual / Plan :\n" +sum_total.toString()+ " / " +  sum_total_order.toString() + " " +pub_unit);

        /// Clear Data
        //event_clear();

    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId()) {

            if (popupLayout4.getVisibility() == VISIBLE) {
                switch (KeyMapping.fromId(keyCode)) {
                    case P1:

                        btn_cancel.performClick();
                        break;

                }



            }
            else {
                switch (KeyMapping.fromId(keyCode)) {
                    case P1:
                        finish();
                        break;
                }
            }
        }
            return super.onKeyUp(keyCode, event);
    }
    @Override
    public void processData(String data, DecodeResult.Result result, String codeType) {


        if( map_inboundQC_Detail_item.size()==0)
        {

            str_ticket_no = data;
            load_inbound_qc_detail();


        }



    }


    @Override
    public void onClickRow(String id, String part_no, String bc_tire, String qty, String status) {

    }

    @Override
    public void SelectionItemRow(String id, String part_no, String bc_tire, String qty, String status) {
        popupLayout4.setVisibility(View.VISIBLE);
        if (popupLayout4.getVisibility() == VISIBLE) {

            edt_qty.setText("");

            edt_qty.setInputType(InputType.TYPE_NULL);
            edt_qty.requestFocus();

            str_id = id+bc_tire;

            if(qty.equals(".00") || qty.equals(""))
            {
                qty="0";
            }
            txt_qty_total.setText("/"+qty.replace(".00",""));





        }
    }
}
