package com.tomastc.ht_nki.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomastc.ht_nki.ClickRowQCScheculeDetail;
import com.tomastc.ht_nki.ListData.Tranfer_list;
import com.tomastc.ht_nki.R;

import java.text.DecimalFormat;
import java.util.List;

public class Tranfer_Adapter extends RecyclerView.Adapter<Tranfer_Adapter.ViewHolder> {
private List<Tranfer_list> data;
Context context;
DecimalFormat decimalFormat;

private ClickRowQCScheculeDetail onClickRowItem;

public Tranfer_Adapter(List<Tranfer_list> dataset, Context context, ClickRowQCScheculeDetail onClickRowItem) {
    data = dataset;
    this.context = context;
    this.onClickRowItem = onClickRowItem;
}

public class ViewHolder extends RecyclerView.ViewHolder{
    LinearLayout layout;
    TextView txt_no, txt_part, txt_bc_tire,txt_qty, txt_status;
    public ViewHolder(View itemview){
        super(itemview);
        layout = (LinearLayout) itemview.findViewById(R.id.item_row);
        txt_no = (TextView)itemView.findViewById(R.id.txt_no);
        txt_part = (TextView)itemView.findViewById(R.id.txt_part_no);
        txt_bc_tire = (TextView)itemView.findViewById(R.id.txt_bc_tire);
        txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
        txt_status = (TextView)itemView.findViewById(R.id.txt_status);
    }
}


@NonNull
@Override
public Tranfer_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
    View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_tire_transfer,parent,false);
    context = parent.getContext();
    return new Tranfer_Adapter.ViewHolder(content_view);
}

@Override
public void onBindViewHolder(@NonNull Tranfer_Adapter.ViewHolder holder, int position) {
    decimalFormat = new DecimalFormat("#,#00");
    final Tranfer_list item = data.get(position);
    holder.txt_no.setText(item.getId());
    holder.txt_part.setText(item.getPart_no());
    holder.txt_bc_tire.setText(item.getBc_tire());
    holder.txt_qty.setText(item.getQty());
    holder.txt_status.setText(item.getStatus());

    String status = item.getStatus();
    if (status.trim().equals("OK")){
        holder.txt_status.setBackgroundResource(R.color.green);
    }else if (status.trim().equals("NG")){
        holder.txt_status.setBackgroundResource(R.color.red);
    } else {
        holder.layout.setBackgroundResource(R.drawable.background_row);
    }

    holder.layout.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View view) {
            onClickRowItem.SelectionItemRow(item.getId(), item.getPart_no(),
                    item.getBc_tire(), item.getQty(), item.getStatus());
        }
    });


}

@Override
public int getItemCount() {
    return data.size();
}
}
