package com.tomastc.ht_nki.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomastc.ht_nki.ClickRowQCScheculeDetail;
import com.tomastc.ht_nki.ListData.ItemTicket_list;
import com.tomastc.ht_nki.R;

import java.text.DecimalFormat;
import java.util.List;

public class StocktakingLabel_Adapter extends RecyclerView.Adapter<StocktakingLabel_Adapter.ViewHolder> {
    private List<ItemTicket_list> data;
    Context context;
    DecimalFormat decimalFormat;

    private ClickRowQCScheculeDetail onClickRowItem;

    public StocktakingLabel_Adapter(List<ItemTicket_list> dataset, Context context, ClickRowQCScheculeDetail onClickRowItem) {
        data = dataset;
        this.context = context;
        this.onClickRowItem = onClickRowItem;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        LinearLayout layout;
        TextView txt_no, txt_part, txt_ticket_no, txt_t_qty, txt_qty, txt_status;
        public ViewHolder(View itemview){
            super(itemview);
            layout = (LinearLayout) itemview.findViewById(R.id.item_row);
            txt_no = (TextView)itemView.findViewById(R.id.txt_no);
            txt_part = (TextView)itemView.findViewById(R.id.txt_part);
            txt_ticket_no = (TextView)itemView.findViewById(R.id.txt_ticket_no);
            txt_t_qty = (TextView)itemView.findViewById(R.id.txt_t_qty);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_status = (TextView)itemView.findViewById(R.id.txt_status);
        }
    }


    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_stocktaking_label,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,#00");
        final ItemTicket_list item = data.get(position);
        holder.txt_no.setText(item.getId());
        holder.txt_part.setText(item.getItem_id());
        holder.txt_ticket_no.setText(item.getTicket_no());
        holder.txt_t_qty.setText(item.getT_qty());
        holder.txt_qty.setText(item.getQty());
        holder.txt_status.setText(item.getStatus());

        String status = item.getStatus();
        if (status.trim().equals("OK")){
           holder.txt_status.setBackgroundResource(R.color.green);
        }else if (status.trim().equals("NG")){
            holder.txt_status.setBackgroundResource(R.color.red);
        } else {
            holder.layout.setBackgroundResource(R.drawable.background_row);
        }

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickRowItem.SelectionItemRow(item.getLocation_id(), item.getItem_id(),
                        item.getTicket_no(), item.getQty(), item.getStatus());
            }
        });


    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
