package com.tomastc.ht_nki.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomastc.ht_nki.ListData.StockCheck_list_item;
import com.tomastc.ht_nki.R;

import java.text.DecimalFormat;
import java.util.List;

public class Stock_Check_Adapter extends RecyclerView.Adapter<Stock_Check_Adapter.ViewHolder> {
    private List<StockCheck_list_item> data;
    Context context;
    DecimalFormat decimalFormat;
    public Stock_Check_Adapter(List<StockCheck_list_item> dataset, Context context) {
        data = dataset;
        this.context = context;
    }
    public class ViewHolder extends RecyclerView.ViewHolder{
        ConstraintLayout layout;
        TextView txt_no,txt_tire_week,txt_lot_no,txt_location,txt_qty;
        @SuppressLint("WrongViewCast")
        public ViewHolder(View itemview){
            super(itemview);
            layout = (ConstraintLayout)itemview.findViewById(R.id.item_row);
            txt_no = (TextView)itemView.findViewById(R.id.txt_no);
            txt_tire_week = (TextView)itemview.findViewById(R.id.txt_tire_week);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lotno);
            txt_lot_no.setTextSize(10);
            txt_location = (TextView)itemView.findViewById(R.id.txt_location);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_stock_check,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        //decimalFormat = new DecimalFormat("#,#0000");
        final StockCheck_list_item item = data.get(position);

        // พิมพ์ข้อมูลใน log สำหรับแต่ละ item
        Log.d("StockCheck", "======>>>> Item ID: " + item.getItem_id());
        Log.d("StockCheck", "======>>>> Tire: " + item.getBc_tire());
        Log.d("StockCheck", "======>>>> Location ID: " + item.getLocation_id());
        Log.d("StockCheck", "======>>>> Lot No: " + item.getLot_no());
        Log.d("StockCheck", "======>>>> Carry Over: " + item.getCarry_over());
        Log.d("StockCheck", "======>>>> Qty: " + item.getQty());





        holder.txt_no.setText(item.getNo());
        holder.txt_tire_week.setText(item.getBc_tire());
        holder.txt_lot_no.setText(item.getLot_no());
        holder.txt_location.setText(item.getLocation_id());
        holder.txt_qty.setText(item.getQty());





    }



    @Override
    public int getItemCount() {
        Log.d("DEBUG", "Data size: " + data.size());
        return data.size();
    }
}
