package com.tomastc.ht_nki.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomastc.ht_nki.LabelDetail_Activity;
import com.tomastc.ht_nki.ListData.ScheduleLabel_Item;
import com.tomastc.ht_nki.R;

import java.text.DecimalFormat;
import java.util.List;

public class ScheduleLabel_Adapter extends RecyclerView.Adapter<ScheduleLabel_Adapter.ViewHolder> {
    private List<ScheduleLabel_Item> data;
    Context context;
    DecimalFormat decimalFormat;
    public ScheduleLabel_Adapter(List<ScheduleLabel_Item> dataset, Context context) {
        data = dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        ConstraintLayout layout;
        TextView txt_order_no, txt_supplier, txt_part_no, txt_part_name, txt_rank, txt_location, txt_qty;
        @SuppressLint("WrongViewCast")
        public ViewHolder(View itemview){
            super(itemview);
            layout = (ConstraintLayout) itemview.findViewById(R.id.item_row);
            txt_order_no = (TextView)itemView.findViewById(R.id.txt_order_no);
            txt_supplier = (TextView)itemView.findViewById(R.id.txt_supplier);
            txt_part_no = (TextView)itemView.findViewById(R.id.txt_part_no);
            txt_part_name = (TextView)itemView.findViewById(R.id.txt_part_name);
            txt_rank = (TextView)itemView.findViewById(R.id.txt_rank);
            txt_location = (TextView)itemView.findViewById(R.id.txt_location);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);

        }
    }


    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_schedule,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,#00.00");
        final ScheduleLabel_Item item = data.get(position);
        holder.txt_order_no.setText(item.getOrder_no());
        holder.txt_supplier.setText(item.getSupplier_name());
        holder.txt_part_no.setText(item.getPart_no());
        holder.txt_part_name.setText(item.getPart_name());
        holder.txt_rank.setText(item.getRank());
        holder.txt_location.setVisibility(View.GONE);
//        holder.txt_location.setText("Location : "+item.getLocation());
        holder.txt_qty.setText(decimalFormat.format(Double.parseDouble(item.getAct_qty())) +"/"+decimalFormat.format(Double.parseDouble(item.getPlan_qty())) +" "+item.getUnit());

        String status = item.getStatus();
        if (status.toString().trim().equals("COMPLETED")){
            holder.layout.setBackgroundResource(R.color.status_completed);
        }else if (status.toString().trim().equals("WORKING")){
            holder.layout.setBackgroundResource(R.color.status_working);
        }else{//IMPORTED or
            holder.layout.setBackgroundResource(R.color.status_imported);
        }

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent i = new Intent(context.getApplicationContext(), LabelDetail_Activity.class);
                i.putExtra("schedule_id", item.getSchedule_id());
                i.putExtra("order_no", item.getOrder_no());
                i.putExtra("order_dt", item.getOrder_date());
                i.putExtra("part_no", item.getPart_no());
                i.putExtra("part_name", item.getPart_name());
                i.putExtra("rank", item.getRank());
                i.putExtra("location", item.getLocation());
                i.putExtra("status", item.getStatus());
                i.putExtra("plan_qty", item.getPlan_qty());
                i.putExtra("act_qty", item.getAct_qty());
                i.putExtra("qty_per_box", item.getQty_per_box());
                i.putExtra("unit", item.getUnit());
                context.startActivity(i);
            }
        });

    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
