package com.tomastc.ht_nki.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomastc.ht_nki.ListData.OutboundPicking_item;
import com.tomastc.ht_nki.OutboundPickingDetail_Activity;
import com.tomastc.ht_nki.R;

import java.text.DecimalFormat;
import java.util.List;

public class Outbound_Picking_Adapter extends RecyclerView.Adapter<Outbound_Picking_Adapter.ViewHolder> {
    private List<OutboundPicking_item> data;
    Context context;
    DecimalFormat decimalFormat;
    public Outbound_Picking_Adapter(List<OutboundPicking_item> dataset, Context context) {
        data = dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        ConstraintLayout layout;
        TextView txt_order_no, txt_parts_no, txt_parts_name,
                txt_tire_week, txt_lot_no, txt_status,
                txt_location,txt_actual_plan;
        @SuppressLint("WrongViewCast")
        public ViewHolder(View itemview){
            super(itemview);
            layout = itemview.findViewById(R.id.item_row);

            txt_order_no = itemView.findViewById(R.id.txt_value_order_no);
            txt_parts_no = itemView.findViewById(R.id.txt_value_parts_no);
            txt_parts_name = itemView.findViewById(R.id.txt_value_parts_name);
            txt_tire_week = itemView.findViewById(R.id.txt_tire_week);
            txt_lot_no = itemView.findViewById(R.id.txt_value_lot_no);
            txt_status = itemView.findViewById(R.id.txt_value_status);
            txt_location = itemView.findViewById(R.id.txt_value_location);
            txt_actual_plan = itemview.findViewById(R.id.txt_value_actual_plan);

        }
    }


    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_outbound_picking ,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,#00.00");
        final OutboundPicking_item item = data.get(position);

//        int intQty = (int) Math.floor(Double.parseDouble(item.getQty()));
//        int intActionActQty = (int) Math.floor(Double.parseDouble(item.getAction_act_qty()));
//
//        String formattedQty = String.valueOf(intQty);
//        String formattedActionActQty = String.valueOf(intActionActQty);

        int intQty = (int) Math.floor(Double.parseDouble(item.getQty()));
        int intActionActQty = (int) Math.floor(Double.parseDouble(item.getAction_act_qty()));


        String formattedQty = String.valueOf(intQty);
        Log.e("ToT","------> QTY : "+formattedQty);
        String formattedActionActQty = String.valueOf(intActionActQty);
        Log.e("ToT","------> ActionActQty : "+formattedActionActQty);






       ///====> check status
       //status.toString().trim().equals("COMPLETED QC");
        String status = item.getStatus();

        holder.txt_order_no.setText(item.getDo_no());
        holder.txt_parts_no.setText("");
        holder.txt_parts_name.setText("");
        holder.txt_tire_week.setText("");
        holder.txt_lot_no.setText("");
        holder.txt_status.setText("");
        holder.txt_location.setText(item.getLocation_id());
        holder.txt_actual_plan.setText(formattedActionActQty + " / " + formattedQty + " " +item.getUnit_qty()); //intAction_act_Qty + " / " +  formattedQty + " " +item.getUnit_qty()

        if (status.toString().trim().contains("COMPLETED")){
            holder.layout.setBackgroundResource(R.color.status_completed);
        }else if (status.toString().trim().contains("WORKING")){
            holder.layout.setBackgroundResource(R.color.status_working);
        }else{//IMPORTED or
            holder.layout.setBackgroundResource(R.color.status_imported);
        }



        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (status.toString().trim().equals("PICKING COMPLETED")
                        || status.toString().trim().equals("LOADING")){
                    Toast.makeText(context.getApplicationContext(), "Status complete! ", Toast.LENGTH_SHORT).show();
                }else {
                    Log.e("TOT","=========> "+item.getDo_no());
                    Intent i = new Intent(context.getApplicationContext(), OutboundPickingDetail_Activity.class);
                    i.putExtra("do_no", item.getDo_no());
                    i.putExtra("event", "C");
                    context.startActivity(i);
                }
            }
        });

    }

    @Override
    public int getItemCount() {
        Log.d("DEBUG", "Data size: " + data.size());
        return data.size();
    }
}
