package com.tomastc.ht_nki.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomastc.ht_nki.ClickRowQCScheculeDetail;
import com.tomastc.ht_nki.ListData.InboundQC_DetailItem_list;
import com.tomastc.ht_nki.R;

import java.text.DecimalFormat;
import java.util.List;

public class InboundQCItem_Detail_Adapter extends RecyclerView.Adapter<InboundQCItem_Detail_Adapter.ViewHolder> {
    private List<InboundQC_DetailItem_list> data;
    DecimalFormat decimalFormat;
    Context context;

    private ClickRowQCScheculeDetail onClickRowItem;

    public InboundQCItem_Detail_Adapter(List<InboundQC_DetailItem_list> dataset, Context context, ClickRowQCScheculeDetail onClickRowItem) {
        data = dataset;
        this.context = context;
        this.onClickRowItem = onClickRowItem;
    }

    public static class ViewHolder extends RecyclerView.ViewHolder{
        LinearLayout layout;
        TextView txt_no, txt_parts_no, txt_bc_tire, txt_qty, txt_status;
        @SuppressLint("WrongViewCast")
        public ViewHolder(View itemview){
            super(itemview);
            layout = (LinearLayout) itemview.findViewById(R.id.item_row);
            txt_no = (TextView)itemView.findViewById(R.id.txt_no);
            txt_parts_no = (TextView)itemView.findViewById(R.id.txt_parts_no);
            txt_bc_tire = (TextView)itemView.findViewById(R.id.txt_bc_tire);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_status = (TextView)itemView.findViewById(R.id.txt_status);
        }
    }

    @NonNull
    @Override
    public InboundQCItem_Detail_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_inbound_qc_detail_label,parent,false);
        context = parent.getContext();
        return new InboundQCItem_Detail_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull InboundQCItem_Detail_Adapter.ViewHolder holder, int position) {
        final InboundQC_DetailItem_list item = data.get(position);
        double parsedQty = Double.parseDouble(item.getQty());
        int intQty = (int) parsedQty;
        String formattedQty = String.valueOf(intQty);
        Log.e("T-T", "Data QTY format: " + formattedQty);

        holder.txt_no.setText(item.getNo());
        holder.txt_parts_no.setText(item.getParts_no());
        holder.txt_bc_tire.setText(item.getBc_tire());
        holder.txt_qty.setText(formattedQty);
        holder.txt_status.setText(item.getStatus());

        String status = item.getStatus();

        if (status.trim().equals("IMPORTED")){
            holder.txt_status.setText("OK");
            holder.txt_status.setBackgroundResource(R.color.green);
        }
        if (status.trim().equals("COMPLETED QC")){
            holder.txt_status.setText("OK");
        }

        if (status.trim().equals("NG")){
            holder.txt_status.setBackgroundResource(R.color.red);
        } else {
            holder.layout.setBackgroundResource(R.drawable.background_row);
        }

        if(parsedQty==0)
        {
            holder.txt_status.setText("NG");
            holder.txt_status.setBackgroundResource(R.color.color_red);


        }
        if(parsedQty>0)
        {
            holder.txt_status.setText("OK");
            holder.txt_status.setBackgroundResource(R.color.green);


        }

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickRowItem.SelectionItemRow(item.getNo(), item.getParts_no(),
                        item.getBc_tire(), item.getQty(), item.getStatus());
            }
        });

    }

    @Override
    public int getItemCount() {
        Log.e("T-T","Data Count : "+data.size());
        return data.size();
    }
}
