package com.tomastc.ht_nki;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.tomastc.ht_nki.lib.KeyMapping;
import com.tomastc.ht_nki.lib.Settings;

public class OutbountMenu_Activity extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device;
    Intent intent;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_outbount_menu);

        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ Settings.getLoginUser().getName());

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Device : "+Settings.getDeviceNo());

    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.imb_back){
            finish();
        } else if (view.getId() == R.id.btn_outbound_picking) {
                intent = new Intent(OutbountMenu_Activity.this, OutboundPicking_Activity.class);
                startActivity(intent);
        } else if (view.getId() == R.id.btn_outbound_loading) {
                intent = new Intent(OutbountMenu_Activity.this, OutboundLoading_Activity.class);
                startActivity(intent);
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId()) {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    finish();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }
}