package com.tomastc.ht_nki.Adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomastc.ht_nki.ClickRowOutBounddetail;
import com.tomastc.ht_nki.ListData.OutboundPickingDetail_item;
import com.tomastc.ht_nki.R;

import java.text.DecimalFormat;
import java.util.List;

public class Outbound_PickingDetail_Adapter extends RecyclerView.Adapter<Outbound_PickingDetail_Adapter.ViewHolder> {
    private List<OutboundPickingDetail_item> data;
    Context context;
    DecimalFormat decimalFormat;

    private ClickRowOutBounddetail onClickRowItem;
    public Outbound_PickingDetail_Adapter(List<OutboundPickingDetail_item> dataset, Context context, ClickRowOutBounddetail onClickRowItem) {
        data = dataset;
        this.context = context;
        this.onClickRowItem = onClickRowItem;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        ConstraintLayout layout;
        TextView txt_no, txt_parts_no,txt_tire_week, txt_location, txt_ticket_no,txt_qty,txt_status,txt_stock_qty;
        @SuppressLint("WrongViewCast")
        public ViewHolder(View itemview){
            super(itemview);
            layout = itemview.findViewById(R.id.item_row);

            txt_no = itemView.findViewById(R.id.txt_no);
            txt_parts_no = itemView.findViewById(R.id.txt_part_no);
            txt_tire_week = itemView.findViewById(R.id.txt_tire_week);
            txt_location = itemView.findViewById(R.id.txt_location_id);
            txt_ticket_no = itemView.findViewById(R.id.txt_ticket_no);
            txt_qty = itemView.findViewById(R.id.txt_qty);
            txt_status = itemView.findViewById(R.id.txt_status);
            txt_stock_qty = itemView.findViewById(R.id.txt_stock_qty);

        }
    }


    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_outbound_picking_detail ,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,#00.00");
        final OutboundPickingDetail_item item = data.get(position);

        int intQty = (int) Math.floor(Double.parseDouble(item.getQty()));
        int intActionActQty = (int) Math.floor(Double.parseDouble(item.getAction_act_qty()));
        String formattedQty = String.valueOf(intQty);
        Log.e("ToT","------> QTY : "+formattedQty);
        String formattedActionActQty = String.valueOf(intActionActQty);
        Log.e("ToT","------> ActionActQty : "+formattedActionActQty);

       ///====> check status
        String status = item.getStatus();
        Log.e("ToT","******>>>>>>    "+status.toString());
        if (status.trim().equals("IMPORTED")){
            holder.txt_status.setText("OK");
            holder.txt_status.setBackgroundResource(R.color.green);
        }
        if (status.trim().equals("COMPLETED PICKING")){
            holder.txt_status.setText("OK");
        }




        holder.txt_no.setText(item.getNo());
        holder.txt_parts_no.setText(item.getParts_no());
        holder.txt_tire_week.setText(item.getLot_no());
        holder.txt_location.setText(item.getLocation_id());
        holder.txt_ticket_no.setText(item.getTicket_no());
        holder.txt_stock_qty.setText(item.getCount_status().replace(".00",""));
        holder.txt_qty.setText( formattedActionActQty + "/" +formattedQty );

        if(item.getCount_status().replace(".00","").equals(formattedQty.replace(".00","")))
        {
            holder.txt_stock_qty.setBackgroundResource(R.color.green);


        }
        else
        {
            holder.txt_stock_qty.setBackgroundResource(R.color.color_orange);


        }

        if (status.trim().equals("OK")){
            holder.txt_status.setText("OK");
            holder.txt_status.setBackgroundResource(R.color.green);
            holder.txt_stock_qty.setBackgroundResource(R.color.white);
            holder.txt_stock_qty.setText("");
        }
        else if (status.trim().equals("NG")){
            holder.txt_status.setBackgroundResource(R.color.red);
            holder.txt_status.setText("NG");
        } else {
            holder.layout.setBackgroundResource(R.drawable.background_row);
        }


        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                onClickRowItem.SelectionItemRow(item.getNo(), item.getParts_no(),
                        item.getLot_no(),item.getTicket_no(),item.getLocation_id(), item.getQty(), item.getStatus());
            }
        });

    }



    @Override
    public int getItemCount() {
        Log.d("DEBUG", "Data size outbound detail: " + data.size());
        return data.size();
    }
}
