package com.tomastc.ht_nki.Adapter;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomastc.ht_nki.InboundRackScheduleDetail_Activity;
import com.tomastc.ht_nki.ListData.InbounRackSchedule_item;
import com.tomastc.ht_nki.R;

import java.text.DecimalFormat;
import java.util.List;

public class Inbound_Rack_Adapter extends RecyclerView.Adapter<Inbound_Rack_Adapter.ViewHolder> {
    private List<InbounRackSchedule_item> data;
    Context context;
    DecimalFormat decimalFormat;
    public Inbound_Rack_Adapter(List<InbounRackSchedule_item> dataset, Context context) {
        data = dataset;
        this.context = context;
    }
    public class ViewHolder extends RecyclerView.ViewHolder{
        ConstraintLayout layout;
        TextView txt_order_no, txt_ticket_no, txt_parts_no, txt_parts_name, txt_lot_no, txt_qty , txt_value_status,txt_supplier_id;

        public ViewHolder(View itemview){
            super(itemview);
            layout = (ConstraintLayout) itemview.findViewById(R.id.item_row);
            txt_order_no = (TextView)itemView.findViewById(R.id.txt_order_no);
            txt_ticket_no = (TextView)itemview.findViewById(R.id.txt_ticket_no);
            txt_parts_no = (TextView)itemView.findViewById(R.id.txt_part_no);
            txt_parts_name = (TextView)itemView.findViewById(R.id.txt_part_name);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_value_status = (TextView)itemView.findViewById(R.id.txt_status);

        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_inbound_rack,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,#00.00");
        final InbounRackSchedule_item item = data.get(position);

        double parsedQty = Double.parseDouble(item.getQty());
        int intQty = (int) parsedQty;

        double parsed_action_Qty = Double.parseDouble(item.getAction_act_qty());
        int intAction_Qty = (int) parsed_action_Qty;

        holder.txt_order_no.setText(item.getOrder_no());
        holder.txt_ticket_no.setText(item.getTicket_no());
        holder.txt_parts_no.setText(item.getParts_no());
        holder.txt_parts_name.setText(item.getParts_name());
        holder.txt_lot_no.setText(item.getLot_no());
        holder.txt_qty.setText( intAction_Qty+"/"+intQty+" "+ item.getUnit_qty());



        String status = item.getStatus();
        Log.d("TOT","Data Status : "+status);
        if (status.toString().trim().equals("COMPLETED RACK")){
            holder.layout.setBackgroundResource(R.color.status_completed);
        }else if (status.toString().trim().equals("WORKING RACK")){
            holder.layout.setBackgroundResource(R.color.status_working);
        }else{//IMPORTED or
            holder.layout.setBackgroundResource(R.color.status_imported);
        }

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (status.toString().trim().equals("COMPLETED RACK") ){
                    Toast.makeText(context.getApplicationContext(), "Status complete! ", Toast.LENGTH_SHORT).show();
                }else {
                    Intent i = new Intent(context.getApplicationContext(), InboundRackScheduleDetail_Activity.class);
                    i.putExtra("ticket_no", item.getTicket_no());
                    i.putExtra("state", "click");
                    context.startActivity(i);

                }

            }
        });

    }

    @Override
    public int getItemCount() {
        Log.d("DEBUG", "Data size: " + data.size());
        return data.size();
    }
}
