package com.tomas.pcs_asi.lib.common;

import android.os.AsyncTask;
import android.util.Log;


import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AsyncFtpClient extends AsyncTask<String, Void, String> {

    // Callback function to the associated listener
    private final TaskListener taskListener;

    public static class ACTION {
        public final static String DOWNLOAD = "download";
        public final static String UPLOAD = "upload";
    }

    public interface TaskListener {
        public void onFinished(String result);
    }

    public AsyncFtpClient(TaskListener listener) {
        // The listener reference is passed in through the constructor
        this.taskListener = listener;
    }

    @Override
    protected void onPreExecute() {
        // Create Show ProgressBar
    }

    /**
     * Download a file to a FTP server. A FTP URL is generated with the
     * following syntax:
     * ftp://user:password@host:port/filePath;type=i.
     *
     * @param params, Array of String
     *                index 0: FTP server
     *                index 1: FTP user
     *                index 2: FTP password
     *                index 3: action "upload"/"download"
     *                index 4: local
     *                index 5: remote
     *                index 5+...(1): local file n
     *                index 5+...(2): remote file n.
     */
    @Override
    protected String doInBackground(String... params)   {
        String result = "error";

        String ftp_server = params[0];
        String ftp_user = params[1];
        String ftp_password = params[2];
        String action = params[3];

        Log.e("BTA500", ftp_server+"/"+ftp_user+"/"+ftp_password+"/"+action);
        // Parse params to file list <remote, local>
        Map<String, String> fileList = new HashMap<>();
        String[] fileArry = new String[params.length-4];
        System.arraycopy(params, 4, fileArry, 0, params.length - 4);
        for (int i=0;i<fileArry.length;i+=2) {
            fileList.put(fileArry[i+1], fileArry[i]);
        }

        FtpClient ftpClient = new FtpClient(ftp_server, ftp_user, ftp_password);
        switch (action) {
            case ACTION.DOWNLOAD:
                try {
                    ftpClient.download(fileList);
                    result = "success";
                } catch (IOException e) {
                    Log.e("BTA500", e.getMessage());
                    result = e.getMessage();
                }
                break;
            case ACTION.UPLOAD:
                try {
                    ftpClient.upload(fileList);
                    result = "success";
                } catch (IOException e) {
                    Log.e("BTA500", e.getMessage());
                    result = e.getMessage();
                }
                break;
            default:
                Log.e("BTA500", "action not available");
        }

        return result;
    }

    @Override
    protected void onPostExecute(String result)  {
        super.onPostExecute(result);

        // In onPostExecute we check if the listener is valid
        if(this.taskListener != null) {

            // And if it is we call the callback function on it.
            this.taskListener.onFinished(result);
        }
    }
}
