package com.tomas.pcs_asi;

import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import com.tomas.pcs_asi.ListData.User_Lists;
import com.tomas.pcs_asi.lib.MyAlert;
import com.tomas.pcs_asi.lib.ProductionSchedule;
import com.tomas.pcs_asi.lib.Settings;
import com.tomas.pcs_asi.lib.common.AsyncHttpClient;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.LinkedHashMap;
import java.util.Map;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {
    private static int title_click = 0;
    Map<String, User_Lists> map_user;
    ConstraintLayout layout_alert;
    TextView txt_message, txt_version;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Log.d(getString(R.string.tag), "on create");

        layout_alert = (ConstraintLayout)findViewById(R.id.layout_alert);
        txt_message = (TextView)findViewById(R.id.txt_message);
        txt_version = (TextView)findViewById(R.id.txt_version);
        txt_version.setText("PCS_ASI version "+BuildConfig.VERSION_NAME);
        map_user = new LinkedHashMap<>();

        Settings.init(MainActivity.this);
        Log.d(getString(R.string.tag), "Setting");

        init();
    }

    private void init() {
        layout_alert.setVisibility(View.VISIBLE);
        txt_message.setText("กรุณารอสักครู่ กำลังดาว์นโหลดข้อมูล...");
        // download user data from web
        try {
            JSONObject json = new JSONObject();
            json.put("cmd", "search");
            new AsyncHttpClient(getApplicationContext()
                    ,Settings.getMgmtList().get("web_api") + "/users.php"
                    , json.toString()
            ) {
                @Override
                public void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response: " + response);
                    // update mapItems
                    try {
                        JSONArray jArray = new JSONArray(response);
                        Log.d(getString(R.string.tag), "response json length: " + jArray.length());
                        if (jArray.length() == 0){
                            MyAlert alert =  new MyAlert(MainActivity.this);
                            alert.setMessage("ไม่พบข้อมูล Users");
                            alert.show();
                            layout_alert.setVisibility(View.GONE);
                        }else {
                            for (int i = 0; i < jArray.length(); i++) {
                                map_user.put( jArray.getJSONObject(i).getString("Code").trim(),
                                        new User_Lists(
                                                jArray.getJSONObject(i).getString("Code").trim(),
                                                jArray.getJSONObject(i).getString("NameEng").trim(),
                                                jArray.getJSONObject(i).getString("Role").trim(),
                                                jArray.getJSONObject(i).getString("type").trim(),
                                                jArray.getJSONObject(i).getString("diebond").trim(),
                                                jArray.getJSONObject(i).getString("oven_diebond").trim(),
                                                jArray.getJSONObject(i).getString("plasma").trim(),
                                                jArray.getJSONObject(i).getString("wirebond").trim(),
                                                jArray.getJSONObject(i).getString("bonding_ins").trim(),
                                                jArray.getJSONObject(i).getString("mold").trim(),
                                                jArray.getJSONObject(i).getString("oven_mold").trim(),
                                                jArray.getJSONObject(i).getString("dicer").trim(),
                                                jArray.getJSONObject(i).getString("appearance").trim(),
                                                jArray.getJSONObject(i).getString("classify").trim()));}

                            Settings.setMap_user(map_user);
                            Toast.makeText(getApplicationContext(), "ดาวน์โหลดรหัสพนักงานเรียบร้อยเเล้ว!", Toast.LENGTH_LONG).show();
                            layout_alert.setVisibility(View.GONE);
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                        layout_alert.setVisibility(View.GONE);
                        new SweetAlertDialog(MainActivity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }
                    .execute();
        } catch (JSONException e) {
            e.printStackTrace();
            layout_alert.setVisibility(View.GONE);
            new SweetAlertDialog(MainActivity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {

            case R.id.layout_title:
                if (++title_click == 7) {
                    title_click = 0;
                    Toast.makeText(getApplicationContext(), "Settings mode!", Toast.LENGTH_LONG).show();

                    // call Settings activity
                    Log.d(getString(R.string.tag), "start settings activity");
                    Intent intent = new Intent(MainActivity.this, Setting_Activity.class);
                    startActivity(intent);
                }
                break;

            case R.id.btn_sch:
                Intent intent = new Intent(MainActivity.this, DB_Schedule_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_diebond:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.DIE_BOND));
                Intent_ProcessSheet();
                break;

            case R.id.btn_oven_diebond:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.OVEN_DIE_BOND));
                ProcessSheet_Oven();
                break;

            case R.id.btn_wirebond:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.WIRE_BOND));
                Intent_ProcessSheet();
                break;

            case R.id.btn_bonding_ins:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.BONDING_INS));
                Intent_ProcessSheet();
                break;

            case R.id.btn_mold:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.MOLD));
                Intent_ProcessSheet();
                break;

            case R.id.btn_oven_mold:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.OVEN_MOLD));
                ProcessSheet_Oven();
                break;

            case R.id.btn_dicer:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.DICER));
                ProcessSheet_Oven();
                break;

            case R.id.btn_appearance:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.APPEARANCE));
                Intent_ProcessSheet();
                break;

            case R.id.btn_classify:
                Settings.setPROCESS(String.valueOf(ProductionSchedule.PROCESS.CLASSIFY));
                ProcessSheet_Oven();
                break;

            case R.id.btn_lotout:
                Intent lot_out = new Intent(MainActivity.this, Lotout_Activity.class);
                startActivity(lot_out);
                break;

            case R.id.btn_close:
                finishAffinity();
                System.exit(0);
                break;
        }
    }

    private void ProcessSheet_Oven() {
        Intent i = new Intent(MainActivity.this, Search_ProcessSheet_Lot_Activity.class);
        startActivity(i);
    }

    private void Intent_ProcessSheet() {
        Intent intent1 = new Intent(MainActivity.this, Search_ProcessSheet_Activity.class);
        startActivity(intent1);
    }
}