package com.tomas.pcs_asi;

import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.tomas.pcs_asi.Adapter.Lot_Ins_Adapter;
import com.tomas.pcs_asi.ListData.Get_Lot_Ins;
import com.tomas.pcs_asi.lib.ConvertStringToCalendar;
import com.tomas.pcs_asi.lib.KeyMapping;
import com.tomas.pcs_asi.lib.ProductionSchedule;
import com.tomas.pcs_asi.lib.Settings;
import com.tomas.pcs_asi.lib.common.AsyncHttpClient;
import com.tomas.pcs_asi.lib.common.Scanner;
import com.tomas.pcs_asi.lib.common.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class Ins_Lot_Activity extends Scanner implements View.OnClickListener {
    TextView txt_header, txt_ics, txt_job_order, txt_qty_lot, txt_message;
    String str_ics, str_job, str_process, str_qty_lot, str_finish, str_lot_no, b_ins_plan_start_dt, b_ins_plan_end_dt, process_check
    ,status_check, str_sch_id, str_qty_input, wirebond_mag_no_output, str_check_time, dt_format = "yyyy-MM-dd HH:mm:ss", app_plan_start_dt
    , app_plan_end_dt, mag_no_input, mag_no_output;
    ConstraintLayout layout_alert;
    RecyclerView view_lot;
    List<Get_Lot_Ins> list_item;
    Lot_Ins_Adapter lot_ins_adapter;
    Calendar calendar;
    SimpleDateFormat date_time_fm;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_ins_lot);
        default_view = (EditText) findViewById(R.id.txt_label_issue_tmp);

        date_time_fm = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        list_item = new ArrayList<Get_Lot_Ins>();
        layout_alert = (ConstraintLayout)findViewById(R.id.layout_alert);
        txt_header = (TextView) findViewById(R.id.txt_header_lot);
        txt_ics = (TextView) findViewById(R.id.txt_ics);
        txt_job_order = (TextView) findViewById(R.id.txt_job_order);
        txt_qty_lot = (TextView) findViewById(R.id.txt_qty_lot);
        txt_message = (TextView)findViewById(R.id.txt_message);

        view_lot = (RecyclerView)findViewById(R.id.view_lot);
        view_lot.setHasFixedSize(true);
        view_lot.setRecycledViewPool(new RecyclerView.RecycledViewPool());
        view_lot.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
        view_lot.addItemDecoration(new DividerItemDecoration(this, DividerItemDecoration.VERTICAL));
        view_lot.setItemAnimator(new DefaultItemAnimator());

        str_process = Settings.getPROCESS();
        str_ics = Settings.getICS();
        str_job = Settings.getJobOrder();

        txt_header.setText(str_process+" LOT");
        txt_ics.setText("ICS : "+str_ics);
        txt_job_order.setText("JOB ORDER : "+str_job);

        if (str_process.trim().equals(ProductionSchedule.PROCESS.BONDING_INS.toString())){
            Get_Schedule_Lot_INS(str_ics, str_job);
        }else {//appearance
            Get_Schedule_Lot_APP(str_ics, str_job);
        }
    }



    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.imb_back:
                Intent intent = new Intent(Ins_Lot_Activity.this, Search_ProcessSheet_Activity.class);
                startActivity(intent);
                finish();
                break;
        }
    }

    private void Get_Schedule_Lot_APP(String ics, String job_order) {
        list_item.clear();
        try {
            layout_alert.setVisibility(View.VISIBLE);
            txt_message.setText("กรุณารอสักครู่ กำลังค้นหาข้อมูล...");

            JSONObject json = new JSONObject();
            json.put("cmd", "get_sch_lot_app");
            json.put("ics_product", ics);
            json.put("job_order", job_order);

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api")+ "/production_plan.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response: " + response);
                    try {
                        JSONArray jArray = new JSONArray(response);
                        for (int i = 0; i < jArray.length(); i++){
                            str_qty_lot = jArray.getJSONObject(i).getString("Qty_Lot").trim();
                            str_finish =   jArray.getJSONObject(i).getString("FINISHED").trim();

                            String status = jArray.getJSONObject(i).getString("status").trim();
                            String check_time = jArray.getJSONObject(i).getString("appearance_check_times").trim() == "null" ? "" : jArray.getJSONObject(i).getString("appearance_check_times").trim();
                            Log.d(getString(R.string.tag), "app check_time1: " + check_time);

                            list_item.add(new Get_Lot_Ins(
                                    jArray.getJSONObject(i).getString("sch_id").trim(),
                                    jArray.getJSONObject(i).getString("ICSProductCode").trim(),
                                    str_qty_lot,
                                    jArray.getJSONObject(i).getString("lot_no").trim(),
                                    jArray.getJSONObject(i).getString("process").trim(),
                                    status,
                                    jArray.getJSONObject(i).getString("appearance_act_end_dt").trim() == "null" ? "" : jArray.getJSONObject(i).getString("appearance_act_end_dt").trim(),
                                    check_time,
                                    str_finish));
                        }
                        txt_qty_lot.setText(str_finish + " / "+str_qty_lot+ " LOT");
                        View_data();
                        layout_alert.setVisibility(View.GONE);
                    }catch (JSONException e) {
                        layout_alert.setVisibility(View.GONE);
                        new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();
        }catch (JSONException e) {
            layout_alert.setVisibility(View.GONE);
            new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }

    private void Get_Schedule_Lot_INS(String ics, String job_order) {
        list_item.clear();
        try {
            layout_alert.setVisibility(View.VISIBLE);
            txt_message.setText("กรุณารอสักครู่ กำลังค้นหาข้อมูล...");

            JSONObject json = new JSONObject();
            json.put("cmd", "get_sch_lot_ins");
            json.put("ics_product", ics);
            json.put("job_order", job_order);

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api")+ "/production_plan.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response: " + response);

                    try {
                        JSONArray jArray = new JSONArray(response);
                        for (int i = 0; i < jArray.length(); i++){
                            str_qty_lot = jArray.getJSONObject(i).getString("Qty_Lot").trim();
                            str_finish =   jArray.getJSONObject(i).getString("FINISHED").trim();

                            String status = jArray.getJSONObject(i).getString("status").trim();
                            String check_time = jArray.getJSONObject(i).getString("bonding_ins_check_times").trim() == "null" ? "" : jArray.getJSONObject(i).getString("bonding_ins_check_times").trim();
                            Log.d(getString(R.string.tag), "check_time1: " + check_time);

                            list_item.add(new Get_Lot_Ins(
                                    jArray.getJSONObject(i).getString("sch_id").trim(),
                                    jArray.getJSONObject(i).getString("ICSProductCode").trim(),
                                    str_qty_lot,
                                    jArray.getJSONObject(i).getString("lot_no").trim(),
                                    jArray.getJSONObject(i).getString("process").trim(),
                                    status,
                                    jArray.getJSONObject(i).getString("bonding_ins_act_end_dt").trim() == "null" ? "" : jArray.getJSONObject(i).getString("bonding_ins_act_end_dt").trim(),
                                    check_time,
                                    str_finish));
                        }
                        txt_qty_lot.setText(str_finish + " / "+str_qty_lot+ " LOT");
                        View_data();
                        layout_alert.setVisibility(View.GONE);
                    }catch (JSONException e) {
                        layout_alert.setVisibility(View.GONE);
                        new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();
        }catch (JSONException e) {
            layout_alert.setVisibility(View.GONE);
            new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }

    private void View_data() {
        Log.d(getString(R.string.tag), String.valueOf(list_item.size()));

        lot_ins_adapter = new Lot_Ins_Adapter(list_item, Ins_Lot_Activity.this, str_process);
        view_lot.setAdapter(lot_ins_adapter);
        Log.d(getString(R.string.tag), "set adapter");
    }

    @Override
    public void processData(String data, DecodeResult.Result result, String codeType) {
        if (data.trim().equals(""))
            return;

        try {
            Log.d(getString(R.string.tag), "scan data : " + data);
            if (!data.trim().equals("")){
                str_lot_no = data.trim();
                if (str_process.trim().equals(ProductionSchedule.PROCESS.BONDING_INS.toString())){
                    Check_ProcessSheet_INS(str_ics, str_job, str_lot_no);
                }else {//appearance
                    Check_ProcessSheet_APP(str_ics, str_job, str_lot_no);
                }
            }
            Utils.hideKeyboardFrom(getApplicationContext(), default_view);

        } catch (Exception e) {
            Log.e(getString(R.string.tag), "ERROR: " + e.getMessage());
        }
    }

    private void Check_ProcessSheet_APP(String ics, String job_order, String lot_no) {
        try {
            layout_alert.setVisibility(View.VISIBLE);
            txt_message.setText("กรุณารอสักครู่ กำลังค้นหาข้อมูล...");

            JSONObject json = new JSONObject();
            json.put("cmd", "check_process_sheet");
            json.put("ics_product", ics);
            json.put("job_order", job_order);
            json.put("lot_no", lot_no);

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api")+ "/production_plan.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response: " + response);

                    try {
                        JSONArray jArray = new JSONArray(response);
                        if (jArray.length() == 0){
                            str_lot_no = "";
                            layout_alert.setVisibility(View.GONE);
                            new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.WARNING_TYPE)
                                    .setTitleText("แจ้งเตือน")
                                    .setContentText("ไม่พบ Lot no.!")
                                    .show();
                        }else {
                            for (int i = 0; i < jArray.length(); i++){
                                process_check = jArray.getJSONObject(i).getString("process").trim();
                                status_check = jArray.getJSONObject(i).getString("status").trim();
                                str_sch_id = jArray.getJSONObject(i).getString("sch_id").trim();
                                str_qty_input = jArray.getJSONObject(i).getString("appearance_output").trim() == "null" ? jArray.getJSONObject(i).getString("dicer_output").trim() : jArray.getJSONObject(i).getString("appearance_output").trim();
                                str_check_time = jArray.getJSONObject(i).getString("appearance_check_times").trim() == "null" ? "" : jArray.getJSONObject(i).getString("appearance_check_times").trim();
                                Log.d(getString(R.string.tag), "app response: " + str_qty_input+"|"+str_check_time);

                                JSONObject obj = jArray.getJSONObject(i);
                                JSONObject array_start_dt = obj.getJSONObject("appearance_plan_start_dt");
                                app_plan_start_dt = array_start_dt.getString("date");
                                app_plan_start_dt = app_plan_start_dt.substring(0,19);
                                Log.d(getString(R.string.tag), "app_plan_start_dt: " + app_plan_start_dt);

                                JSONObject array_end_dt = obj.getJSONObject("appearance_plan_end_dt");
                                app_plan_end_dt = array_end_dt.getString("date");
                                app_plan_end_dt = app_plan_end_dt.substring(0,19);
                                Log.d(getString(R.string.tag), "app_plan_end_dt: " + app_plan_end_dt);
                            }
                            Check_Status();
//                            layout_alert.setVisibility(View.GONE);
                        }
                    }catch (JSONException e) {
                        layout_alert.setVisibility(View.GONE);
                        new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();
        }catch (JSONException e) {
            layout_alert.setVisibility(View.GONE);
            new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }
    private void Check_ProcessSheet_INS(String ics, String job_order, String lot_no) {
        try {
            layout_alert.setVisibility(View.VISIBLE);
            txt_message.setText("กรุณารอสักครู่ กำลังค้นหาข้อมูล...");

            JSONObject json = new JSONObject();
            json.put("cmd", "check_process_sheet");
            json.put("ics_product", ics);
            json.put("job_order", job_order);
            json.put("lot_no", lot_no);

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api")+ "/production_plan.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response: " + response);

                    try {
                        JSONArray jArray = new JSONArray(response);
                        if (jArray.length() == 0){
                            layout_alert.setVisibility(View.GONE);
                            str_lot_no = "";
                            new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.WARNING_TYPE)
                                    .setTitleText("แจ้งเตือน")
                                    .setContentText("ไม่พบ Lot no.!")
                                    .show();
                        }else {
                            for (int i = 0; i < jArray.length(); i++){
                                process_check = jArray.getJSONObject(i).getString("process").trim();
                                status_check = jArray.getJSONObject(i).getString("status").trim();
                                str_sch_id = jArray.getJSONObject(i).getString("sch_id").trim();
                                str_qty_input = jArray.getJSONObject(i).getString("bonding_ins_output").trim() == "null" ? jArray.getJSONObject(i).getString("wirebond_output").trim() : jArray.getJSONObject(i).getString("bonding_ins_output").trim();
                                wirebond_mag_no_output = jArray.getJSONObject(i).getString("wirebond_mag_no_output").trim() == "null" ? "" : jArray.getJSONObject(i).getString("wirebond_mag_no_output").trim();
                                mag_no_output = jArray.getJSONObject(i).getString("bonding_ins_mag_no_output").trim()== "null" ? "" : jArray.getJSONObject(i).getString("bonding_ins_mag_no_output").trim();
                                str_check_time = jArray.getJSONObject(i).getString("bonding_ins_check_times").trim() == "null" ? "" : jArray.getJSONObject(i).getString("bonding_ins_check_times").trim();
                                Log.d(getString(R.string.tag), "response: " + str_qty_input+"|"+str_check_time);

                                JSONObject obj = jArray.getJSONObject(i);
                                JSONObject array_start_dt = obj.getJSONObject("bonding_ins_plan_start_dt");
                                b_ins_plan_start_dt = array_start_dt.getString("date");
                                b_ins_plan_start_dt = b_ins_plan_start_dt.substring(0,19);
                                Log.d(getString(R.string.tag), "b_ins_plan_start_dt: " + b_ins_plan_start_dt);

                                JSONObject array_end_dt = obj.getJSONObject("bonding_ins_plan_end_dt");
                                b_ins_plan_end_dt = array_end_dt.getString("date");
                                b_ins_plan_end_dt = b_ins_plan_end_dt.substring(0,19);
                                Log.d(getString(R.string.tag), "b_ins_plan_end_dt: " + b_ins_plan_end_dt);

                            }
                            Check_MagNo();
                        }
                    }catch (JSONException e) {
                        layout_alert.setVisibility(View.GONE);
                        new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();
        }catch (JSONException e) {
            layout_alert.setVisibility(View.GONE);
            new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }

    private void Check_MagNo() {
        try {
            layout_alert.setVisibility(View.VISIBLE);
            txt_message.setText("กรุณารอสักครู่ กำลังค้นหาข้อมูล...");

            JSONObject json = new JSONObject();
            json.put("cmd", "search");
            json.put("process", str_process);
            json.put("sch_id", str_sch_id);
            json.put("check_times", str_check_time);

            new AsyncHttpClient(getApplicationContext(),
                    Settings.getMgmtList().get("web_api") + "/event_ins.php",
                    json.toString()) {
                @Override
                protected void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response: " + response);

                    try {
                        JSONArray jArray = new JSONArray(response);
                        if (jArray.length() > 0){
                            for (int i = 0; i < jArray.length(); i++) {
                                mag_no_input = jArray.getJSONObject(i).getString("mag_no_input").trim()== "null" ? "" : jArray.getJSONObject(i).getString("mag_no_input").trim();
                                //mag_no_output = jArray.getJSONObject(i).getString("mag_no_output").trim()== "null" ? "" : jArray.getJSONObject(i).getString("mag_no_output").trim();
                            }
                        }else{
                            mag_no_input = "";
                            //mag_no_output = "";
                        }
                        Log.d(getString(R.string.tag), "mag_no_input: " + mag_no_input);
                        //Log.d(getString(R.string.tag), "mag_no_output: " + mag_no_output);
                        Check_Status();
                        layout_alert.setVisibility(View.GONE);
                    }catch (JSONException e) {
                        layout_alert.setVisibility(View.GONE);
                        new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText(e.getMessage())
                                .show();
                    }
                }
            }.execute();

        }catch (JSONException e) {
            layout_alert.setVisibility(View.GONE);
            new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(e.getMessage())
                    .show();
        }
    }

    private void Check_Status() {
        if (str_process.trim().equals(ProductionSchedule.PROCESS.BONDING_INS.toString())) {
            Settings.setMcType(ProductionSchedule.MACHINE.DB_INS.toString());
            if (status_check.trim().equals(ProductionSchedule.STATUS.WIRE_BOND_FINISHED.toString())) {
                //first check
                str_check_time = "1";
                //next page -->> ins_start
                Settings.setMagNo(wirebond_mag_no_output);
                Check_Plan_start_end(b_ins_plan_start_dt, "Start Plan BONDING_INS", "START");

            } else if (status_check.trim().equals(ProductionSchedule.STATUS.BONDING_INS_WAIT.toString())) {
                //next page -->> ins_start
                //ไม่ต้องเช็ค เพราะไม่ใช่ครั้งที่1
//            Check_Plan_start_end(b_ins_plan_start_dt, "Start Finish BONDING_INS", "START");
                Settings.setMagNo(mag_no_output);
                Settings.setOverdueDt("");
                Settings.setOverdueTitle("");
                Intent_page("START");

            } else if (status_check.trim().equals(ProductionSchedule.STATUS.BONDING_INS_WORKING.toString())) {
                //next page -->> ins_output
                Settings.setMagNo(mag_no_input);
                Check_Plan_start_end(b_ins_plan_end_dt, "Finish Plan BONDING_INS", "OUTPUT");

            } else if (status_check.trim().equals(ProductionSchedule.STATUS.BONDING_INS_FINISHED.toString())) {
                layout_alert.setVisibility(View.GONE);
                new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.WARNING_TYPE)
                        .setTitleText("แจ้งเตือน")
                        .setContentText("สถานะ ProcessSheet : BONDING_INS_FINISHED")
                        .show();

            } else {
                layout_alert.setVisibility(View.GONE);
                new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.WARNING_TYPE)
                        .setTitleText("แจ้งเตือน")
                        .setContentText("สถานะ ProcessSheet : "+status_check)
                        .show();
            }
        }else if (str_process.trim().equals(ProductionSchedule.PROCESS.APPEARANCE.toString())) {
            Settings.setMcType(ProductionSchedule.MACHINE.APP_INS.toString());
            if (status_check.trim().equals(ProductionSchedule.STATUS.DICER_FINISHED.toString())) {
                //first check
                str_check_time = "1";
                Check_Plan_start_end(app_plan_start_dt, "Start Plan APPEARANCE", "START");

            } else if (status_check.trim().equals(ProductionSchedule.STATUS.APPEARANCE_WAIT.toString())) {

                Settings.setOverdueDt("");
                Settings.setOverdueTitle("");
                Intent_page("START");

            } else if (status_check.trim().equals(ProductionSchedule.STATUS.APPEARANCE_WORKING.toString())) {
                //next page -->> ins_output
                Check_Plan_start_end(app_plan_end_dt, "Finish Plan APPEARANCE", "OUTPUT");

            } else if (status_check.trim().equals(ProductionSchedule.STATUS.APPEARANCE_FINISHED.toString())) {
                layout_alert.setVisibility(View.GONE);
                new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.WARNING_TYPE)
                        .setTitleText("แจ้งเตือน")
                        .setContentText("สถานะ ProcessSheet : APPEARANCE_FINISHED")
                        .show();

            } else {
                layout_alert.setVisibility(View.GONE);
                new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.WARNING_TYPE)
                        .setTitleText("แจ้งเตือน")
                        .setContentText("สถานะ ProcessSheet : "+status_check)
                        .show();
            }
        }else{
            layout_alert.setVisibility(View.GONE);
            new SweetAlertDialog(Ins_Lot_Activity.this, SweetAlertDialog.WARNING_TYPE)
                    .setTitleText("แจ้งเตือน")
                    .setContentText("สถานะ ProcessSheet : "+status_check)
                    .show();
        }
    }

    private void Check_Plan_start_end(String plan_dt, String message, String page) {
        calendar = ConvertStringToCalendar.convert(plan_dt,dt_format);
        String p_date1 = date_time_fm.format(calendar.getTime());
        Log.d(getString(R.string.tag), "calendar: " + p_date1);

        calendar.add(Calendar.MINUTE, 30);
        String p_date2 = date_time_fm.format(calendar.getTime());
        Log.d(getString(R.string.tag), "calendar: " + p_date2);

        Calendar now = Calendar.getInstance();
        Calendar now_dt = (Calendar) now.clone();
        String str_now = date_time_fm.format(now_dt.getTime());
        Log.d(getString(R.string.tag), "now_dt: " + str_now);

        if (now_dt.after(calendar)){
            Log.d(getString(R.string.tag), "if alert");
            Settings.setOverdueDt(plan_dt);
            Settings.setOverdueTitle(message);
        }else {
            Log.d(getString(R.string.tag), "else ");
            Settings.setOverdueDt("");
            Settings.setOverdueTitle("");
        }
        Intent_page(page);
    }

    private void Intent_page(String page) {

        // Discard the ScanManager class instance.
        mScanManager.removeDataListener(Ins_Lot_Activity.this);
        // Discard the ScanManager class instance to release the resources.
        mScanManager.releaseScanManager();

        Settings.setSchId(str_sch_id);
        Settings.setLotNo(str_lot_no);
        Settings.setSTATUS(status_check);
        Settings.setQtyInput(str_qty_input);
        Settings.setCheckTime(str_check_time);

        if (page.trim().equals("START")){
            Intent intent = new Intent(Ins_Lot_Activity.this, Ins_Start_Activity.class);
            startActivity(intent);
            finish();

        }else{
            Intent i = new Intent(Ins_Lot_Activity.this, Ins_Output_Activity.class);
            startActivity(i);
            finish();
        }
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    Intent intent = new Intent(Ins_Lot_Activity.this, Search_ProcessSheet_Activity.class);
                    startActivity(intent);
                    finish();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }
}