package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Get_Item_BOM;
import com.tomas.pcs_asi.ListData.Get_Item_Tools;
import com.tomas.pcs_asi.R;
import com.tomas.pcs_asi.lib.ProductionSchedule;

import java.util.List;

public class Tools_Adapter extends RecyclerView.Adapter<Tools_Adapter.ViewHolder>{
    private List<Get_Item_Tools> data;
    public Context context;

    public Tools_Adapter(List<Get_Item_Tools> dataset, Context context) {
        data= dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout;
        public TextView txt_tool_name, txt_status;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.row_item);
            txt_tool_name = (TextView)itemView.findViewById(R.id.txt_tool_name);
            txt_status = (TextView) itemView.findViewById(R.id.txt_status);
        }
    }

    @NonNull
    @Override
    public Tools_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_tools,parent,false);
        context = parent.getContext();
        return new Tools_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull Tools_Adapter.ViewHolder holder, int position) {
        final Get_Item_Tools item_tools = data.get(position);
        holder.txt_tool_name.setText(item_tools.getToolName());
        String status = item_tools.getStatus();
        if (status.trim().equals(ProductionSchedule.STATUS_TM.CHANGE.toString())){
            holder.txt_status.setText(status);
        }else {
            holder.txt_status.setVisibility(View.GONE);
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
