package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Get_Schedule_DB;
import com.tomas.pcs_asi.R;

import java.util.List;

public class Schedule_DB_Adapter extends RecyclerView.Adapter<Schedule_DB_Adapter.ViewHolder >{
    private List<Get_Schedule_DB> data;
    public Context context;

    public Schedule_DB_Adapter(List<Get_Schedule_DB> dataset, Context context){
        data= dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public ConstraintLayout layout;
        public TextView txt_ics, txt_job, txt_qty_lot;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (ConstraintLayout)itemView.findViewById(R.id.row_item);
            txt_ics = (TextView)itemView.findViewById(R.id.txt_ics);
            txt_job = (TextView)itemView.findViewById(R.id.txt_job);
            txt_qty_lot = (TextView)itemView.findViewById(R.id.txt_qty_lot);
        }
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_schedule_db,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final Get_Schedule_DB schedule_db = data.get(position);
        int all_lot, finished_lot, working_lot;
        all_lot = Integer.parseInt(schedule_db.getQty_lot());
        finished_lot = Integer.parseInt(schedule_db.getFINISHED());
        working_lot = Integer.parseInt(schedule_db.getWORKING());

        holder.txt_ics.setText("ICS : "+schedule_db.getICSProductCode());
        holder.txt_job.setText("JOB ORDER : "+schedule_db.getJob_order());

        if (all_lot == finished_lot){
            holder.txt_qty_lot.setText(finished_lot+" LOT");
            holder.layout.setBackgroundResource(R.drawable.btn_bg_finished);

        }else if (finished_lot == 0 && working_lot == 0){
            holder.txt_qty_lot.setText(finished_lot+" / "+all_lot+" LOT");
            holder.layout.setBackgroundResource(R.drawable.btn_bg_new);

        }else {
            holder.txt_qty_lot.setText(finished_lot+" / "+all_lot+" LOT");
            holder.layout.setBackgroundResource(R.drawable.btn_bg_working);
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
