package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.NG_Lists;
import com.tomas.pcs_asi.ListData.RandomCheck_NG_Lists;
import com.tomas.pcs_asi.R;
import com.tomas.pcs_asi.lib.ProductionSchedule;

import java.util.List;

public class RandomCheckNG_Adapter extends RecyclerView.Adapter<RandomCheckNG_Adapter.ViewHolder> {
    private List<RandomCheck_NG_Lists>data;
    public Context context;
    public RandomCheckNG_Adapter(List<RandomCheck_NG_Lists> data, Context context) {
        this.data = data;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout row_item;
        public TextView txt_no,txt_name, txt_qty, txt_process;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);

            row_item = (LinearLayout)itemView.findViewById(R.id.row_item);
            txt_no = (TextView)itemView.findViewById(R.id.txt_no);
            txt_name = (TextView)itemView.findViewById(R.id.txt_ng_name);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_process = (TextView) itemView.findViewById(R.id.txt_process);
        }
    }

    @NonNull
    @Override
    public RandomCheckNG_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_random_list_ng,parent,false);
        context = parent.getContext();
        return new RandomCheckNG_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull RandomCheckNG_Adapter.ViewHolder holder, int position) {
        final RandomCheck_NG_Lists lists = data.get(position);
        holder.txt_no.setText(lists.getNo()+":");
        holder.txt_name.setText(lists.getNg_name());
        holder.txt_qty.setText(lists.getNg_qty());
        holder.txt_process.setText(lists.getProcess());
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
