package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Item_Oven;
import com.tomas.pcs_asi.R;
import com.tomas.pcs_asi.lib.ProductionSchedule;

import java.util.List;

public class Oven_Adapter extends RecyclerView.Adapter<Oven_Adapter.ViewHolder> {
    public Context context;
    private List<Item_Oven> data;
    String process;

    public Oven_Adapter (List<Item_Oven> dataset, Context context, String process) {
        data= dataset;
        this.context = context;
        this.process = process;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout;
        public TextView txt_ics, txt_job_order, txt_lot_no, txt_mag_no;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.item_row);
            txt_ics = (TextView)itemView.findViewById(R.id.txt_ics);
            txt_job_order = (TextView)itemView.findViewById(R.id.txt_job);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot);
            txt_mag_no = (TextView)itemView.findViewById(R.id.txt_mag_no);
        }
    }

    @NonNull
    @Override
    public Oven_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_oven,parent,false);
        context = parent.getContext();
        return new Oven_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull Oven_Adapter.ViewHolder holder, int position) {
        final Item_Oven item = data.get(position);
        if (process.trim().equals(ProductionSchedule.PROCESS.OVEN_MOLD.toString())){
            holder.txt_mag_no.setVisibility(View.GONE);

        }else if (process.trim().equals(ProductionSchedule.PROCESS.DICER.toString())){
            holder.txt_mag_no.setVisibility(View.GONE);
            int i_output = Integer.parseInt(item.getMag_no());//dicer output
            Log.d("ASI", "i_output: " + String.valueOf(i_output));

            if (i_output > 0){
                holder.layout.setBackgroundResource(R.color.white);
            }else {
                holder.layout.setBackgroundResource(R.color.red);
            }
        }else if (process.trim().equals("DICER_START")){
            holder.txt_mag_no.setVisibility(View.GONE);
        }

        holder.txt_ics.setText(item.getIcs_code());
        holder.txt_job_order.setText(item.getJob_order());
        holder.txt_lot_no.setText(item.getLot_no());
        holder.txt_mag_no.setText(item.getMag_no());

    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
