package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.NG_Lists;
import com.tomas.pcs_asi.R;
import com.tomas.pcs_asi.lib.ProductionSchedule;

import java.util.List;

public class NG_Adapter extends RecyclerView.Adapter<NG_Adapter.ViewHolder> {
    private List<NG_Lists>data;
    public Context context;
    String process;

    public NG_Adapter(List<NG_Lists> data, Context context, String process) {
        this.data = data;
        this.context = context;
        this.process = process;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout,layout_sch_id;
        public TextView txt_name, txt_qty, txt_sch_id;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.row_item);
            layout_sch_id = (LinearLayout)itemView.findViewById(R.id.layout_sch_id);
            txt_name = (TextView)itemView.findViewById(R.id.txt_name);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_sch_id = (TextView) itemView.findViewById(R.id.txt_sch_id);
        }
    }

    @NonNull
    @Override
    public NG_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_list_ng,parent,false);
        context = parent.getContext();
        return new NG_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull NG_Adapter.ViewHolder holder, int position) {
        final NG_Lists lists = data.get(position);
        holder.txt_name.setText(lists.getNg_name());
        holder.txt_qty.setText(lists.getNg_qty());

        if (process.trim().equals(ProductionSchedule.PROCESS.DICER.toString())){
            holder.layout_sch_id.setVisibility(View.VISIBLE);
            holder.txt_sch_id.setText(lists.getSch_id());
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
