package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Get_Lot_Plasma;
import com.tomas.pcs_asi.R;
import com.tomas.pcs_asi.lib.ProductionSchedule;

import java.util.List;

public class Lot_Plasma_Adapter extends RecyclerView.Adapter<Lot_Plasma_Adapter.ViewHolder >{
    public Context context;
    private List<Get_Lot_Plasma> data;

    public Lot_Plasma_Adapter(List<Get_Lot_Plasma> data, Context context) {
        this.context = context;
        this.data = data;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public ConstraintLayout layout;
        public TextView txt_lot_no, txt_status;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (ConstraintLayout)itemView.findViewById(R.id.row_item);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_status = (TextView)itemView.findViewById(R.id.txt_status);
        }
    }

    @NonNull
    @Override
    public Lot_Plasma_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_lot,parent,false);
        context = parent.getContext();
        return new Lot_Plasma_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull Lot_Plasma_Adapter.ViewHolder holder, int position) {
        final Get_Lot_Plasma lot_plasma = data.get(position);
        holder.txt_lot_no.setText(lot_plasma.getLot_no());

        String status = lot_plasma.getStatus();
        if (!lot_plasma.getWirebond_act_end_dt().trim().equals("")){
            holder.layout.setBackgroundResource(R.drawable.btn_bg_finished);

        }else if (status.trim().equals(ProductionSchedule.STATUS.WIRE_BOND_WORKING.toString())){
            holder.layout.setBackgroundResource(R.drawable.btn_bg_working);

        }else if (status.trim().equals(ProductionSchedule.STATUS.PLASMA.toString())){
            holder.layout.setBackgroundResource(R.drawable.btn_bg_wait);

        }else if (status.trim().equals(ProductionSchedule.STATUS.PLASMA_FINISHED.toString())){
            holder.layout.setBackgroundResource(R.drawable.btn_bg_oven);

        }else if (status.trim().equals(ProductionSchedule.STATUS.DIE_BOND_FINISHED.toString())){
            holder.layout.setBackgroundResource(R.drawable.btn_bg_new);
        }else{
            holder.layout.setBackgroundResource(R.drawable.img_backgroup);
        }

        if (status.trim().equals(ProductionSchedule.STATUS.CANCEL.toString())){
            holder.txt_status.setText("CANCEL");
        }else if (status.trim().equals(ProductionSchedule.STATUS.LOTOUT.toString())){
            holder.txt_status.setText("LOTOUT");
        }else{
            holder.txt_status.setText("");
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
