package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Get_Lot_Ins;
import com.tomas.pcs_asi.ListData.Get_Lot_WB;
import com.tomas.pcs_asi.R;
import com.tomas.pcs_asi.lib.ProductionSchedule;

import java.util.List;

public class Lot_Ins_Adapter extends RecyclerView.Adapter<Lot_Ins_Adapter.ViewHolder> {
    private List<Get_Lot_Ins> data;
    public Context context;
    String process;

    public Lot_Ins_Adapter(List<Get_Lot_Ins> data, Context context, String process) {
        this.data = data;
        this.context = context;
        this.process = process;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public ConstraintLayout layout;
        public TextView txt_lot_no, txt_time;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (ConstraintLayout)itemView.findViewById(R.id.row_item);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_time = (TextView)itemView.findViewById(R.id.txt_time);
        }
    }


    @NonNull
    @Override
    public Lot_Ins_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_ins_lot,parent,false);
        context = parent.getContext();
        return new Lot_Ins_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull Lot_Ins_Adapter.ViewHolder holder, int position) {
            final Get_Lot_Ins get_lot_ins = data.get(position);
            holder.txt_lot_no.setText(get_lot_ins.getLot_no());

            String status = get_lot_ins.getStatus();
            String str_process = get_lot_ins.getProcess();
            if (process.trim().equals(ProductionSchedule.PROCESS.BONDING_INS.toString())) {
                if (!get_lot_ins.getAct_end_dt().trim().equals("")) {
                    holder.layout.setBackgroundResource(R.drawable.btn_bg_finished);

                } else if (status.trim().equals(ProductionSchedule.STATUS.BONDING_INS_WORKING.toString())) {
                    holder.layout.setBackgroundResource(R.drawable.btn_bg_working);

                } else if (status.trim().equals(ProductionSchedule.STATUS.BONDING_INS_WAIT.toString())) {
                    holder.layout.setBackgroundResource(R.drawable.btn_bg_wait);

                } else if (status.trim().equals(ProductionSchedule.STATUS.WIRE_BOND_FINISHED.toString())) {
                    holder.layout.setBackgroundResource(R.drawable.btn_bg_new);
                }else{
                    holder.layout.setBackgroundResource(R.drawable.img_backgroup);
                }
            }else{//appearance
                if (!get_lot_ins.getAct_end_dt().trim().equals("")
                    ||str_process.trim().equals(ProductionSchedule.PROCESS.CLASSIFY.toString()) ) {

                    holder.layout.setBackgroundResource(R.drawable.btn_bg_finished);

                } else if (status.trim().equals(ProductionSchedule.STATUS.APPEARANCE_WORKING.toString())) {
                    holder.layout.setBackgroundResource(R.drawable.btn_bg_working);

                } else if (status.trim().equals(ProductionSchedule.STATUS.APPEARANCE_WAIT.toString())) {
                    holder.layout.setBackgroundResource(R.drawable.btn_bg_wait);

                } else if (status.trim().equals(ProductionSchedule.STATUS.DICER_FINISHED.toString())) {
                    holder.layout.setBackgroundResource(R.drawable.btn_bg_new);
                }else{
                    holder.layout.setBackgroundResource(R.drawable.img_backgroup);
                }
            }

        if (status.trim().equals(ProductionSchedule.STATUS.CANCEL.toString())){
            holder.txt_time.setText("CANCEL");
        }else if (status.trim().equals(ProductionSchedule.STATUS.LOTOUT.toString())){
            holder.txt_time.setText("LOTOUT");
        }else{
            holder.txt_time.setText(get_lot_ins.getCheck_times());
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
