package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Get_Lot_DB;
import com.tomas.pcs_asi.ListData.Get_Schedule_DB;
import com.tomas.pcs_asi.R;
import com.tomas.pcs_asi.lib.ProductionSchedule;

import java.util.List;

public class Lot_DB_Adapter extends RecyclerView.Adapter<Lot_DB_Adapter.ViewHolder > {
    private List<Get_Lot_DB> data;
    public Context context;
    String process;

    public Lot_DB_Adapter(List<Get_Lot_DB> dataset, Context context, String Process) {
        data = dataset;
        this.context = context;
        process = Process;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public ConstraintLayout layout;
        public TextView txt_lot_no, txt_status;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (ConstraintLayout)itemView.findViewById(R.id.row_item);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_status = (TextView) itemView.findViewById(R.id.txt_status);
        }
    }

    @NonNull
    @Override
    public Lot_DB_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_lot,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull Lot_DB_Adapter.ViewHolder holder, int position) {
        final Get_Lot_DB lot_db = data.get(position);
        String status = lot_db.getStatus();
        holder.txt_lot_no.setText(lot_db.getLot_no());


        if (process.trim().equals("MOLD")){
            if(status.trim().equals(ProductionSchedule.STATUS.LOTOUT.toString())){
                holder.layout.setBackgroundResource(R.drawable.img_backgroup);

            }else if (!lot_db.getOven_act_end_dt().trim().equals("")) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_finished);

            } else if (status.trim().equals(ProductionSchedule.STATUS.BONDING_INS_FINISHED.toString())) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_new);

            } else if (status.trim().equals(ProductionSchedule.STATUS.MOLD_WORKING.toString())) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_working);

            } else if (status.trim().equals(ProductionSchedule.STATUS.MOLD_WAIT.toString())) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_wait);

            } else if (status.trim().equals(ProductionSchedule.STATUS.MOLD_OVEN.toString())) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_oven);
            }
        }else {//DIE BOND

            if (!lot_db.getOven_act_end_dt().trim().equals("")) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_finished);

            } else if (status.trim().equals(ProductionSchedule.STATUS.IMPORTED.toString())) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_new);

            } else if (status.trim().equals(ProductionSchedule.STATUS.DIE_BOND_WORKING.toString())
            ||status.trim().equals(ProductionSchedule.STATUS.DIE_BOND_AGAIN.toString())) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_working);

            } else if (status.trim().equals(ProductionSchedule.STATUS.DIE_BOND_WAIT.toString())) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_wait);

            } else if (status.trim().equals(ProductionSchedule.STATUS.DIE_BOND_OVEN.toString())) {
                holder.layout.setBackgroundResource(R.drawable.btn_bg_oven);
            }else {
                holder.layout.setBackgroundResource(R.drawable.img_backgroup);
            }
        }

        if (status.trim().equals(ProductionSchedule.STATUS.CANCEL.toString())){
            holder.txt_status.setText("CANCEL");
        }else if (status.trim().equals(ProductionSchedule.STATUS.LOTOUT.toString())){
            holder.txt_status.setText("LOTOUT");
        }else{
            holder.txt_status.setText("");
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
