package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Item_Classify;
import com.tomas.pcs_asi.ListData.Item_LotOut;
import com.tomas.pcs_asi.R;

import java.util.List;

public class LotOut_Adapter extends RecyclerView.Adapter<LotOut_Adapter.ViewHolder> {
    public Context context;
    private List<Item_LotOut> data;
    String process;

    public LotOut_Adapter(List<Item_LotOut> dataset, Context context) {
        data = dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout;
        public TextView txt_ics, txt_job_order, txt_lot_no, txt_process;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.row_item);
            txt_ics = (TextView)itemView.findViewById(R.id.txt_ics);
            txt_job_order = (TextView)itemView.findViewById(R.id.txt_job_order);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_process = (TextView)itemView.findViewById(R.id.txt_process);
        }
    }

    @NonNull
    @Override
    public LotOut_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_lotout,parent,false);
        context = parent.getContext();
        return new LotOut_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull LotOut_Adapter.ViewHolder holder, int position) {
        final Item_LotOut item = data.get(position);
        holder.txt_ics.setText(item.getIcs());
        holder.txt_job_order.setText(item.getJob_order());
        holder.txt_lot_no.setText(item.getLot_no());
        holder.txt_process.setText(item.getProcess());
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
