package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Item_Classify;
import com.tomas.pcs_asi.R;

import java.util.List;

public class Classify_Adapter extends RecyclerView.Adapter<Classify_Adapter.ViewHolder> {
    public Context context;
    private List<Item_Classify> data;
    String process;

    public Classify_Adapter(List<Item_Classify> dataset, Context context, String process) {
        data= dataset;
        this.context = context;
        this.process = process;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout;
        public TextView txt_job_order, txt_lot_no;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.row_item);
            txt_job_order = (TextView)itemView.findViewById(R.id.txt_job_order);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
        }
    }

    @NonNull
    @Override
    public Classify_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_classify,parent,false);
        context = parent.getContext();
        return new Classify_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull Classify_Adapter.ViewHolder holder, int position) {
        final Item_Classify item = data.get(position);
        holder.txt_job_order.setText(item.getJob_order());
        holder.txt_lot_no.setText(item.getLot_no());
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
