package com.tomas.pcs_asi.Adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.pcs_asi.ListData.Get_Item_BOM;
import com.tomas.pcs_asi.R;
import com.tomas.pcs_asi.lib.ProductionSchedule;
import com.tomas.pcs_asi.lib.Settings;

import java.util.List;

public class BOM_Adapter extends RecyclerView.Adapter<BOM_Adapter.ViewHolder> {

    private List<Get_Item_BOM> data;
    public Context context;

    public BOM_Adapter(List<Get_Item_BOM> dataset, Context context) {
        data= dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout;
        public TextView txt_part_name, txt_lot_no, txt_rank, txt_disbursement, txt_start_date, txt_service_life, txt_exp, txt_status;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.row_item);
            txt_part_name = (TextView)itemView.findViewById(R.id.txt_ics_part);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_part);
            txt_rank = (TextView)itemView.findViewById(R.id.txt_rank);
            txt_disbursement = (TextView)itemView.findViewById(R.id.txt_disbursement);
            txt_start_date = (TextView)itemView.findViewById(R.id.txt_start_date);
            txt_service_life = (TextView)itemView.findViewById(R.id.txt_service_life);
            txt_exp = (TextView)itemView.findViewById(R.id.txt_exp);
            txt_status = (TextView) itemView.findViewById(R.id.txt_status);
        }
    }

    @NonNull
    @Override
    public BOM_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_bom,parent,false);
        context = parent.getContext();
        return new BOM_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull BOM_Adapter.ViewHolder holder, int position) {
        final Get_Item_BOM item_bom = data.get(position);
        holder.txt_part_name.setText(item_bom.getPartName().trim());
        holder.txt_lot_no.setText("Lot No. :"+item_bom.getLotNo().trim());

        String status = item_bom.getStatus();
        if (status.trim().equals(ProductionSchedule.STATUS_TM.ADD.toString())) {
            holder.txt_status.setText(status);
        }else {
            holder.txt_status.setVisibility(View.GONE);
        }
        String process = Settings.getPROCESS();
        Log.d("ASI", "adapter process  : " + process);

        if(process.trim().equals(ProductionSchedule.PROCESS.WIRE_BOND.toString())){
            holder.txt_rank.setVisibility(View.GONE);
            holder.txt_disbursement.setVisibility(View.GONE);
            holder.txt_start_date.setVisibility(View.GONE);
            holder.txt_service_life.setVisibility(View.GONE);
            holder.txt_exp.setVisibility(View.GONE);

        }else if (process.trim().equals(ProductionSchedule.PROCESS.MOLD.toString())) {
            holder.txt_rank.setVisibility(View.GONE);
            holder.txt_disbursement.setText("วัน/เวลาเบิก : " + item_bom.getDisbursement());
            holder.txt_start_date.setText("วันเริ่มใช้งาน : " + item_bom.getStart_date());
            holder.txt_service_life.setText("อายุการใช้งาน : " + item_bom.getService_Life());
            holder.txt_exp.setText("วันหมดอายุ : " + item_bom.getMaterial_Exp());
            Log.d("ASI", "MOLD : " + item_bom.getLotNo());

        }else {
            holder.txt_rank.setText("Rank : " + item_bom.getRank());
            holder.txt_disbursement.setText("วัน/เวลาเบิก : " + item_bom.getDisbursement());
            holder.txt_start_date.setText("วันเริ่มใช้งาน : " + item_bom.getStart_date());
            holder.txt_service_life.setText("อายุการใช้งาน : " + item_bom.getService_Life());
            holder.txt_exp.setText("วันหมดอายุ : " + item_bom.getMaterial_Exp());
            Log.d("ASI", "DIEBOND : " + item_bom.getLotNo());
        }
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
