package sample.sample_socket_client;

import android.Manifest;
import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.text.SpannableStringBuilder;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;


import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;

public class MainActivity extends AppCompatActivity implements View.OnKeyListener  {

    EditText et;         // 送信テキスト

    private EditText editTextIP;
    private EditText editTextPORT;
    private EditText editTextDATA;

    String IPAddress  = "192.168.100.100";
    String port  = "23";
    String sendData = "";

    String setting[] = new String[2];

    private final static String SettingFILE_NAME = "SocketSetting.csv";
    File dir = Environment.getExternalStoragePublicDirectory("SocketWedge");
    File file = new File(dir.getPath(), SettingFILE_NAME);



    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);


        //Permission for access the internal storage
        verifyStoragePermissions(this);

        if(!dir.exists()){dir.mkdirs();}
        if (file.exists()) {
            try {
                InputStreamReader isr = new InputStreamReader(new FileInputStream(file), StandardCharsets.UTF_8);
                BufferedReader br = new BufferedReader(isr);
                String line;

                // ReadLine
                while ((line = br.readLine()) != null) {
                    setting = line.split(",", 0);
                }
                br.close();
            } catch (IOException e) {
                System.out.println(e);
            }
        }else{
            // SetDefaultの値に合わせる
            setting[0] = "192.168.100.100";
            setting[1] = "23";
        }

        IPAddress = setting[0];
        port = setting[1];

        editTextIP = findViewById(R.id.editText_IP);
        editTextPORT = findViewById(R.id.editText_port);
        editTextDATA = findViewById(R.id.editTextData);

        editTextPORT.setText(port);
        editTextIP.setText(IPAddress);
        editTextDATA.setText(sendData);


        Button button = (Button) findViewById(R.id.button);

        editTextIP.setOnKeyListener(this);
        editTextPORT.setOnKeyListener(this);
        editTextDATA.setOnKeyListener(this);

        // When pressing Send
        button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
               startSendData();
            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        saveData();
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    @Override
    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if(event.getKeyCode() != KeyEvent.KEYCODE_ENTER) return false;
        if(event.getAction() == KeyEvent.ACTION_DOWN) return true;


        if(v.equals(editTextIP) && editTextIP.length() > 0) {
            saveData();
            editTextPORT.requestFocus();
        }
        else if(v.equals(editTextPORT) && editTextPORT.length() > 0) {
            saveData();
            editTextDATA.requestFocus();
        }
        else if(v.equals(editTextDATA) && editTextDATA.length() > 0) {
            startSendData();
        }
        return true;
    }

    //内部ストレージの任意フォルダにアクセスするために必要
    private static final int REQUEST_EXTERNAL_STORAGE_CODE = 0x01;
    private static String[] mPermissions = {
            Manifest.permission.READ_EXTERNAL_STORAGE,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
    };

    void startSendData(){
        IPAddress = editTextIP.getText().toString();
        port = editTextPORT.getText().toString();
        sendData = editTextDATA.getText().toString();

        // IP and Port setting
        InetSocketAddress inetSocketAddress = new InetSocketAddress(IPAddress, Integer.parseInt(port));

        // Android needs thread to use Socket Communication
        AsyncTask<InetSocketAddress, Void, Void> task = new AsyncTask<InetSocketAddress, Void, Void>() {
            @Override
            protected Void doInBackground(InetSocketAddress... inetSocketAddresses) {
                Socket socket = null;
                try {
                    // Connect
                    socket = new Socket();
                    socket.connect(inetSocketAddresses[0]);

                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));

                    // SendData
                    writer.write(sendData);

                    // Close may be required to send the data (Uncleared)
                    writer.close();

                    socket.close();
                } catch (SocketException e) {
                    e.printStackTrace();
                } catch (IOException e) {
                    e.printStackTrace();
                }

                return null;
            }
        };
        editTextDATA.setText("");
        task.execute(inetSocketAddress);
    }


    void saveData(){
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(
                    new OutputStreamWriter( new FileOutputStream(file,false),StandardCharsets.UTF_8));
            bufferedWriter.write(editTextIP.getText().toString() + "," + editTextPORT.getText().toString());
            bufferedWriter.flush();
            bufferedWriter.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private static void verifyStoragePermissions(Activity activity) {
        int readPermission = ContextCompat.checkSelfPermission(activity, mPermissions[0]);
        int writePermission = ContextCompat.checkSelfPermission(activity, mPermissions[1]);

        if (writePermission != PackageManager.PERMISSION_GRANTED ||
                readPermission != PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(
                    activity,
                    mPermissions,
                    REQUEST_EXTERNAL_STORAGE_CODE
            );
        }
    }

}
