﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using System.Data;
using System.Globalization;
using System.IO;

namespace SCRAP_WEB
{
    public partial class rptExportData : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {

            if (!Page.IsPostBack)
            {

                try
                {
                    string type = Page.Request["type"].ToString();
                    _genReport(Page.Request["filter"].ToString(),type);
                }
                catch { };


            }
        }








        private void _genReport(string filter,string type)
        {

            // Set the processing mode for the ReportViewer to Local
            rptview.ProcessingMode = ProcessingMode.Local;
            LocalReport rep = rptview.LocalReport;
            rep.ReportPath = "rptPowerSummary.rdlc";

            // Create a report data source for the sales order data
            ReportDataSource dsMaintenanceDS = new ReportDataSource();
            dsMaintenanceDS.Name = "dsRpt";
            DataTable dt = _genDataSource(filter);
            dsMaintenanceDS.Value = dt;
            rep.DataSources.Clear();

           
            rep.DataSources.Add(dsMaintenanceDS);
            rep.Refresh();
           
         
            if(type=="1")
            {
                savereport();

            }
            

      
       
            //}
        }

        private void savereport()
        {
            string FileName = "file_" + DateTime.Now.ToString("yyyyMMdd_HHmmss", new CultureInfo("en-US")) + ".xls";


        
            string extension;
            string encoding;
            string mimeType;
            string[] streams;
            Warning[] warnings;

            string contentType = "application/Excel";

            Byte[] mybytes = rptview.LocalReport.Render("Excel", null,
                            out extension, out encoding,
                            out mimeType, out streams, out warnings);
            using (FileStream fs = File.Create(Server.MapPath(@"\Excel_log\") + FileName))
            {
                fs.Write(mybytes, 0, mybytes.Length);
            }

            //Response.ClearHeaders();
            //Response.ClearContent();
            //Response.Buffer = true;
            //Response.Clear();
            Response.ContentType = contentType;
            Response.AddHeader("Content-Disposition", "attachment; filename=" + FileName);
            Response.WriteFile(Server.MapPath(@"\Excel_log\" + FileName));
            Response.Flush();
            //Response.Close();
            //Response.End();   
        }

        private DataTable _genDataSource(string filter)
        {
            DataTable dt = new DataTable();

            string startdate = string.Empty;
            string enddate = string.Empty;
            string starttime = string.Empty;
            string endtime = string.Empty;
            if (filter.IndexOf('|') != -1)
            {
                string[] arr = filter.Split('|');
                startdate = arr[0];
                enddate = arr[1];
                starttime = arr[2];
                endtime = arr[3];

            }

            string sqlquery = string.Empty;
            using (FcSql.Function fc = new FcSql.Function())
            {


                if (startdate.Trim().Length == 0)
                {
                    startdate = DateTime.Now.ToString("yyyy-01-01", new CultureInfo("en-US"));
                    enddate = DateTime.Now.AddDays(1).ToString("yyyy-MM-dd", new CultureInfo("en-US"));
                    starttime = "00:00:00";
                    endtime = "23:59:00";



                }


                string strquery = string.Empty;
                strquery = string.Format("select *,daykwh+nightkwh+holidaykwh as AllKwh,daybaht+nightbaht+holidaybaht as AllBaht from PeriodMonth as m Cross join PowerMeters as pm left outer join (select case when a.sum_month is null then case when b.sum_month is null then c.sum_month else b.sum_month end else a.sum_month end as sum_month,case when a.sum_year is null then case when b.sum_year is null then c.sum_year else b.sum_year end else a.sum_year end as sum_year,  mt.PowerMeter_ID,mt.PowerMeter_Name,case when a.sum_PowerEnergy is null then 0 else a.sum_PowerEnergy end as daykwh,case when a.sum_Bath is null then 0 else a.sum_Bath end as daybaht,case when b.sum_PowerEnergy is null then 0 else b.sum_PowerEnergy end as nightkwh,case when b.sum_Bath is null then 0 else b.sum_Bath end as nightbaht,case when c.sum_PowerEnergy is null then 0 else c.sum_PowerEnergy end as holidaykwh,case when c.sum_Bath is null then 0 else c.sum_Bath end as holidaybaht from PowerMeters as mt left outer join "+
" powersummary_normal('{0} {2}','{1} {3}',1,1)	as a on mt.PowerMeter_ID=a.PowerMeter_ID left outer join "+
" powersummary_normal('{0} {2}','{1} {3}',1,2)	as b on mt.PowerMeter_ID=b.PowerMeter_ID left outer join " +
" powersummary_holiday('{0} {2}','{1} {3}',2)	as c on mt.PowerMeter_ID=c.PowerMeter_ID Where charindex('Sub_Main',mt.Control_Type)>0) as temp on m.monthid=temp.sum_month  and pm.PowerMeter_ID=temp.PowerMeter_ID Where charindex('Sub_Main',pm.Control_Type)>0	order by m.monthid,temp.PowerMeter_ID ", DateTime.Parse(startdate).ToString("yyyy-MM-dd", new CultureInfo("en-US")), DateTime.Parse(enddate).ToString("yyyy-MM-dd", new CultureInfo("en-US")), starttime, endtime);
                dt = fc.SQL_DataTable(strquery.ToString());
                fc.closeconnection();
              





            }
            return dt;





        }

        protected void btnexport_Click(object sender, EventArgs e)
        {
            savereport();

        }


    }
}