﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Net.Sockets;
using System.Threading;

namespace SmartDeviceProjectExecute1
{
    public partial class Form1 : Form
    {
        private BTClientLib.BtrieveDbClient dbClient;
        private String dbName, dbHost;
        private int dbPort;


        private static int _CYCLE_TIME = 500;
        private static int _MAX_DATA_INPUT_LEN = 1024;
        private static int _MAX_RETRY_READ = 30;

        static Int32 term_signal = 0;
        static Boolean debug = false;
        static Boolean checkInputStream = true;
        static Boolean exitWhenDataUnavailable = false;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            dbName = txtDbName.Text.ToString();
            dbHost = txtDbHost.Text.ToString();
            dbPort = Int32.Parse(txtDbPort.Text.ToString());
            dbClient = new BTClientLib.BtrieveDbClient(dbHost, dbPort, dbName);
        }

        private void btnQuerySend_Click(object sender, EventArgs e)
        {
            List<Dictionary<string, string>> rows = dbClient.Query(txtQuerySql.Text.ToString());
            Console.WriteLine(String.Format("return rows : {0}", rows.Count));
        }

        private void btnExecuteSend_Click(object sender, EventArgs e)
        {
            int affected_rows = dbClient.Execute(txtExecuteSql.Text.ToString());
            Console.WriteLine(String.Format("affected rows : {0}", affected_rows)); 
        }

        static String SocketConnect(String server, int port, String msg)
        {
            // Reset term_signal
            term_signal = 0;

            // String to store the response ASCII representation.
            String inputData = String.Empty;

            try
            {
                // Create a TcpClient.
                // Note, for this client to work you need to have a TcpServer
                // connected to the same address as specified by the server, port
                // combination.
                TcpClient client = new TcpClient(server, port);

                // we have connected
                NetworkStream stream = client.GetStream();
                //stream.ReadTimeout = _TIMEOUT_mSEC;

                // Receive from server
                Byte[] data = new Byte[_MAX_DATA_INPUT_LEN];

                int max_try_when_success = (int)_MAX_RETRY_READ; // data unavailabled on socket success status

                try
                {
                    do
                    {
                        try
                        {
                            if (max_try_when_success == 0)
                            {
                                throw new Exception("Socket disconnected");
                            }
                            if (checkInputStream && !stream.DataAvailable)
                                throw new Exception("Data not availabled");

                            // Read the first batch of the TcpServer response bytes.
                            Int32 bytes = stream.Read(data, 0, data.Length);
                            Console.WriteLine("bytes read :" + bytes);
                            inputData += System.Text.Encoding.ASCII.GetString(data, 0, bytes);

                            if (inputData.Contains("HELLO"))
                            {
                                Console.WriteLine("Received : " + inputData);
                                inputData = String.Empty; // Reset input data
                                if (msg.Length > 0)
                                {
                                    Byte[] outputBytes = Encoding.ASCII.GetBytes(msg + "\n");
                                    stream.Write(outputBytes, 0, outputBytes.Length);

                                    Console.WriteLine("Sent : " + msg);

                                    msg = String.Empty;
                                }
                            }
                            else if (inputData.Contains('\n') || inputData.Length >= _MAX_DATA_INPUT_LEN)
                            {
                                Console.WriteLine("Received : " + inputData);

                                term_signal = 1;
                            }


                        }
                        catch (Exception e)
                        {
                            if (debug)
                            {
                                Console.WriteLine("Error Message: {0}", e.Message);
                                Console.WriteLine("Error: {0}", e);
                            }

                            if (e.Message.Contains("period of time"))
                            {
                                Console.Write(".");
                            }
                            else if (
                                !exitWhenDataUnavailable
                                && (e.Message.Contains("Data not availabled")
                                  || e.Message.Contains("Unable to read data from the transport connection"))
                                )
                            {
                                Console.Write(".");
                                if (max_try_when_success > 0) max_try_when_success--;

                                Thread.Sleep(_CYCLE_TIME);
                            }
                            else
                            {
                                term_signal = 1;
                            }

                        }

                    } while (term_signal == 0);
                }
                finally
                {
                    Console.WriteLine("Stream closed.");
                    stream.Close();
                    Console.WriteLine("Socket closed.");
                    client.Close();
                }

            }
            catch (ArgumentNullException e)
            {
                Console.WriteLine("ArgumentNullException: {0}", e);
            }
            catch (SocketException e)
            {
                Console.WriteLine("SocketException: {0}", e);
            }
            catch (Exception e)
            {
                if (e.Message.Contains("Socket disconnected"))
                {
                    Console.WriteLine("Bye.");
                }
                else
                {
                    Console.WriteLine("Exception: {0}", e);
                }
            }

            return inputData;

        }

        private void btnSocketTest_Click(object sender, EventArgs e)
        {
            String ret = SocketConnect(txtDbHost.Text.ToString(), Int32.Parse(txtDbPort.Text.ToString()), txtQuerySql.Text.ToString());
            Console.WriteLine("Socket return msg : " + ret);
        }
    }
}