﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using BTClientLib.lib;
using Newtonsoft.Json;

namespace BTClientLib
{
    public class BtrieveDbClient
    {
        public String host;
        public int port;
        public String dbName;

        public BtrieveDbClient(String host, int port, String dbName) 
        {
            this.host = host;
            this.port = port;
            this.dbName = dbName;
        }

        public List<Dictionary<string, string>> Query(String sql)
        {
            String msg = "{ \"cmd\":\"QUERY\", \"conn_str\":\"Host=localhost;Port=1583;Database=" + this.dbName + ";\", \"sql\":\"" + sql + "\"}";
            SocketClient client = new SocketClient(this.host, this.port, msg);
            JsonResponseQuery resp = JsonConvert.DeserializeObject<JsonResponseQuery>(client.response);
            return resp.data;
        }

        public int Execute(String sql)
        {
            String msg = "{ \"cmd\":\"EXECUTE\", \"conn_str\":\"Host=localhost;Port=1583;Database=" + this.dbName + ";\", \"sql\":\"" + sql + "\"}";
            SocketClient client = new SocketClient(this.host, this.port, msg);
            JsonResponseExecute resp = JsonConvert.DeserializeObject<JsonResponseExecute>(client.response);
            return resp.affected_rows;
        }
    }
}
