﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Threading;

namespace BTClientLib.lib
{
    class SocketClient
    {
        public String response;

        private static int _CYCLE_TIME = 500;
        private static int _MAX_DATA_INPUT_LEN = 1024;
        private static int _MAX_RETRY_READ = 30;

        private static Boolean debug = false;
        private static Boolean checkInputStream = true;
        private static Boolean exitWhenDataUnavailable = false;

        public SocketClient(String server, int port, String msg)
        {
            // Reset term_signal
            Int32 term_signal = 0;

            // String to store the response ASCII representation.
            String inputData = String.Empty;

            try
            {
                // Create a TcpClient.
                // Note, for this client to work you need to have a TcpServer
                // connected to the same address as specified by the server, port
                // combination.
                TcpClient client = new TcpClient(server, port);

                // we have connected
                NetworkStream stream = client.GetStream();
                //stream.ReadTimeout = _TIMEOUT_mSEC;

                // Receive from server
                Byte[] data = new Byte[_MAX_DATA_INPUT_LEN];

                int max_try_when_success = (int)_MAX_RETRY_READ; // data unavailabled on socket success status

                try
                {
                    do
                    {
                        try
                        {
                            if (max_try_when_success == 0)
                            {
                                throw new Exception("Socket disconnected");
                            }
                            if (checkInputStream && !stream.DataAvailable)
                                throw new Exception("Data not availabled");

                            // Read the first batch of the TcpServer response bytes.
                            Int32 bytes = stream.Read(data, 0, data.Length);
                            Console.WriteLine("bytes read :" + bytes);
                            inputData += Encoding.ASCII.GetString(data, 0, bytes);

                            if (inputData.Contains("HELLO"))
                            {
                                Console.WriteLine("Received : " + inputData);
                                inputData = String.Empty; // Reset input data
                                if (msg.Length > 0)
                                {
                                    Byte[] outputBytes = Encoding.ASCII.GetBytes(msg + "\n");
                                    stream.Write(outputBytes, 0, outputBytes.Length);

                                    Console.WriteLine("Sent : " + msg);

                                    msg = String.Empty;
                                }
                            }
                            else if (inputData.Contains("\n\n\n"))
                            {
                                Console.WriteLine("Received : " + inputData);

                                term_signal = 1;
                            }
                            else if (inputData.Length >= _MAX_DATA_INPUT_LEN)
                            {
                                Console.WriteLine("Received : " + Encoding.ASCII.GetString(data, 0, bytes));
                            }


                        }
                        catch (Exception e)
                        {
                            if (debug)
                            {
                                Console.WriteLine("Error Message: {0}", e.Message);
                                Console.WriteLine("Error: {0}", e);
                            }

                            if (e.Message.Contains("period of time"))
                            {
                                Console.Write(".");
                            }
                            else if (
                                !exitWhenDataUnavailable
                                && (e.Message.Contains("Data not availabled")
                                  || e.Message.Contains("Unable to read data from the transport connection"))
                                )
                            {
                                Console.Write(".");
                                if (max_try_when_success > 0) max_try_when_success--;

                                Thread.Sleep(_CYCLE_TIME);
                            }
                            else
                            {
                                term_signal = 1;
                            }

                        }

                    } while (term_signal == 0);
                }
                finally
                {
                    Console.WriteLine("Stream closed.");
                    stream.Close();
                    Console.WriteLine("Socket closed.");
                    client.Close();
                }

            }
            catch (ArgumentNullException e)
            {
                Console.WriteLine("ArgumentNullException: {0}", e);
            }
            catch (SocketException e)
            {
                Console.WriteLine("SocketException: {0}", e);
            }
            catch (Exception e)
            {
                if (e.Message.Contains("Socket disconnected"))
                {
                    Console.WriteLine("Bye.");
                }
                else
                {
                    Console.WriteLine("Exception: {0}", e);
                }
            }

            this.response = inputData;
        }
    }
}
