﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;

namespace lib
{
    internal class Utils
    {

        public static Dictionary<string, string> parseArrayData(Dictionary<string, string> cols, string[] data)
        {
            int i = 0;
            foreach (KeyValuePair<string, string> col in cols)
            {
                cols[col.Key] = data[i++];
            }

            return cols;
        }

        public static List<string> regexPattern(string input, string pattern)
        {
            List<string> output = new List<string>();
            MatchCollection matches = Regex.Matches(input, pattern, RegexOptions.IgnoreCase);
            object[] words = new object[1024];

            int index = 0;
            foreach (Match match in matches)
            {
                match.Groups.CopyTo(words, index);
                index += 2;
            }

            // Display captured groups.
            for (int ctr = 1; ctr <= words.GetUpperBound(0); ctr += 2)
            {
                if (words[ctr] == null)
                    break;
                output.Add(words[ctr].ToString());
            }

            return output;
        }

        public static string getCsvFormatString(int cols)
        {
            string tmp = "";
            for (int i = 0; i < cols; i++)
            {
                tmp += (i > 0 ? "," : "") + "\"{" + i + "}\"";
            }

            return tmp;
        }

    }
}
