﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

// State object for reading client data asynchronously  
public class StateObject
{
    // Size of receive buffer.  
    public const int BufferSize = 1024;

    // Receive buffer.  
    public byte[] buffer = new byte[BufferSize];

    // Received data string.
    public StringBuilder sb = new StringBuilder();

    // Client socket.
    public Socket workSocket = null;
}

public enum ConnectionState : byte
{
    Listen = 0,
    Accepted = 1,
    Busy = 2,
    Stop = 3
}

public class AsynchronousSocketListener
{
    private Form handleForm;
    // Thread signal.  
    public static ManualResetEvent allDone = new ManualResetEvent(false);
    ManualResetEvent _stopSignal = new ManualResetEvent(false); // Your "stopper"
    ManualResetEvent _exitedSignal = new ManualResetEvent(false);


    //private static Thread thread;
    private static bool isStop = true;

    public AsynchronousSocketListener(Form frm)
    {
        handleForm = frm;
    }

    public async Task StartListening(int port)
    {
        Thread thread = new Thread(() => StartListening_(port));
        thread.Start();
        isStop = false;
    }

    public void StartListening_(int port)
    {
        // Establish the local endpoint for the socket.  
        // The DNS name of the computer  
        // running the listener is "host.contoso.com".  
        IPHostEntry ipHostInfo = Dns.GetHostEntry(Dns.GetHostName());
        IPAddress ipAddress = IPAddress.Parse("0.0.0.0"); //ipHostInfo.AddressList[0];
        IPEndPoint localEndPoint = new IPEndPoint(ipAddress, port);

        // Create a TCP/IP socket.  
        Socket listener = new Socket(ipAddress.AddressFamily,
            SocketType.Stream, ProtocolType.Tcp);

        _stopSignal.Reset();

        // Bind the socket to the local endpoint and listen for incoming connections.  
        try
        {
            listener.Bind(localEndPoint);
            listener.Listen(100);
            //Callback delegate
            if (handleForm.InvokeRequired)
            {
                handleForm.Invoke((Action)delegate // <--- HERE
                {
                    OnStateChanged(ConnectionState.Listen);
                });
            }

            while (!_stopSignal.WaitOne(0))
            {
                // Set the event to nonsignaled state.  
                allDone.Reset();

                // Start an asynchronous socket to listen for connections.  
                Console.WriteLine("Waiting for a connection...");
                listener.BeginAccept(
                    new AsyncCallback(AcceptCallback),
                    listener);

                // Wait until a connection is made before continuing.  
                allDone.WaitOne();
            }


            //listener.Shutdown(SocketShutdown.Both);
            //listener.Close();
        }
        catch (Exception e)
        {
            Console.WriteLine(e.ToString());
        }
        finally
        {
            _exitedSignal.Set();
        }

        Console.WriteLine("end start listener");
        listener.Close();
        //Callback delegate
        if (handleForm.InvokeRequired)
        {
            try
            {
                handleForm.Invoke((Action)delegate // <--- HERE
                {
                    OnStateChanged(ConnectionState.Stop);
                });
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
            }
        }

    }

    public void StopListening()
    {
        allDone.Set();
        _stopSignal.Set();
        _exitedSignal.WaitOne();
    }

    public void AcceptCallback(IAsyncResult ar)
    {
        try
        {
            // Signal the main thread to continue.  
            allDone.Set();

            Console.WriteLine("Accepted connection.");
            //Callback delegate
            if (handleForm.InvokeRequired && !_stopSignal.WaitOne(0))
            {
                handleForm.Invoke((Action)delegate // <--- HERE
                {
                    OnStateChanged(ConnectionState.Accepted);
                });
            }

            // Get the socket that handles the client request.  
            Socket listener = (Socket)ar.AsyncState;
            Socket handler = listener.EndAccept(ar);
            //Send(((StateObject)ar.AsyncState).workSocket, "READY");


            // Create the state object.  
            StateObject state = new StateObject();
            state.workSocket = handler;
            handler.BeginReceive(state.buffer, 0, StateObject.BufferSize, 0,
                new AsyncCallback(ReadCallback), state);

            // Send ready
            byte[] bytes = Encoding.ASCII.GetBytes("HELLO\r\n");
            handler.BeginSend(bytes, 0, bytes.Length, 0
                , new AsyncCallback(SendCallback), state);

        }
        catch (Exception e)
        {
            Console.WriteLine(e.Message);
        }
    }

    public void ReadCallback(IAsyncResult ar)
    {
        String content = String.Empty;

        try
        {

            Console.WriteLine("Read retrieved.");

            // Retrieve the state object and the handler socket  
            // from the asynchronous state object.  
            StateObject state = (StateObject)ar.AsyncState;
            Socket handler = state.workSocket;

            // Read data from the client socket.
            int bytesRead = handler.EndReceive(ar);

            Console.WriteLine(bytesRead + " bytes read.");
            if (bytesRead > 0)
            {
                //Callback delegate
                if (handleForm.InvokeRequired)
                {
                    handleForm.Invoke((Action)delegate // <--- HERE
                    {
                        OnStateChanged(ConnectionState.Busy);
                    });
                }

                // There  might be more data, so store the data received so far.  
                state.sb.Append(Encoding.ASCII.GetString(
                    state.buffer, 0, bytesRead));

                Console.WriteLine(state.sb.ToString());

                // Check for end-of-file tag. If it is not there, read
                // more data.  
                content = state.sb.ToString();
                if (content.IndexOf("\n") > -1)
                {
                    // All the data has been read from the
                    // client. Display it on the console.  
                    Console.WriteLine("Read {0} bytes from socket. \n Data : {1}",
                        content.Length, content);


                    // Echo the data back to the client.  
                    //Send(handler, content);

                    //Response OK
                    //Send(handler, "OK");

                    //Callback delegate
                    if (handleForm.InvokeRequired)
                    {
                        handleForm.Invoke((Action)delegate // <--- HERE
                        {
                            String msg = OnReceive(content);

                            //Response OK
                            Send(handler, msg);

                        });
                    }

                }
                else
                {
                    // Not all data received. Get more.  
                    handler.BeginReceive(state.buffer, 0, StateObject.BufferSize, 0,
                    new AsyncCallback(ReadCallback), state);
                }
            }
        }
        catch (SocketException e)
        {
            Console.Write(e.Message);
        }
    }

    public event Receive OnReceive;
    public delegate String Receive(string content);
    public event StateChanged OnStateChanged;
    public delegate void StateChanged(ConnectionState state);

    private void Send(Socket handler, String data)
    {
        // Convert the string data to byte data using ASCII encoding.  
        byte[] byteData = Encoding.ASCII.GetBytes(data);

        // Begin sending the data to the remote device.  
        handler.BeginSend(byteData, 0, byteData.Length, 0,
            new AsyncCallback(SendCallback), handler);
    }

    private void SendCallback(IAsyncResult ar)
    {
        try
        {
            // Retrieve the socket from the state object.  
            Socket handler = (Socket)ar.AsyncState;

            // Complete sending the data to the remote device.  
            int bytesSent = handler.EndSend(ar);
            Console.WriteLine("Sent {0} bytes to client.", bytesSent);

            handler.Shutdown(SocketShutdown.Both);
            handler.Close();

        }
        catch (Exception e)
        {
            Console.WriteLine(e.ToString());
        }
    }
}