﻿Imports System
Imports System.IO
Imports System.Reflection

Public Class LogWriter
    Private m_exePath As String = String.Empty
    Private Shared logWriter As LogWriter = Nothing

    Public Shared Disable As Boolean = False

    Public Shared Function getInstance() As LogWriter
        If logWriter Is Nothing Then
            logWriter = New LogWriter()
        End If

        Return logWriter
    End Function
    Private Sub New()
        m_exePath = Path.GetDirectoryName(Me.GetType().Assembly.GetModules()(0).FullyQualifiedName)
    End Sub


    Public Sub Log(ByVal logMessage As String)
        Try
            Using w As StreamWriter = File.AppendText(m_exePath & "\" & "log.txt")
                Log(logMessage, w)

                w.Flush()
                w.Close()
            End Using
        Catch ex As Exception
        End Try
    End Sub
    Public Sub Log(ByVal arry As String())
        Try
            Using w As StreamWriter = File.AppendText(m_exePath & "\" & "log.txt")
                Dim tmp As String = "["
                Dim first As Boolean = True
                For Each str As String In arry
                    tmp += String.Format("{0}""{1}""\n", If(first, "", ","), str)
                    first = False
                Next
                tmp += "]"
                Log(tmp, w)

                w.Flush()
                w.Close()
            End Using
        Catch ex As Exception
        End Try
    End Sub

    Public Sub Log(ByVal logMessage As String, ByVal txtWriter As TextWriter)
        If Disable Then Return

        Try
            txtWriter.WriteLine("{0}| {1}", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"), logMessage)
        Catch ex As Exception
        End Try
    End Sub
End Class
