﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Collections;
using System.IO;
using System.Data.OleDb;
using System.Diagnostics;


namespace BT500_tranfer
{
    public partial class BT500_tranfer : Form
    {
        private DataTable dt;
        private Int32 tmt_recive = 0;
        UdpClient udpClient;
        Thread thdUDPServer;

        public BT500_tranfer()
        {
            InitializeComponent();
        }

        public void serverThread()
        {
            try
            {
                udpClient = new UdpClient(8080);

                string command = string.Empty;
                while (true)
                {
                    try
                    {
                        IPEndPoint RemoteIpEndPoint = new IPEndPoint(IPAddress.Any, 0);
                        Byte[] receiveBytes = udpClient.Receive(ref RemoteIpEndPoint);
                        string returnData = Encoding.ASCII.GetString(receiveBytes);
                        if (returnData.Length > 0)
                        {
                            this.Invoke(new MethodInvoker(delegate()
                            {
                                call(returnData.ToString());

                            }));
                        }
                    }
                    catch (Exception e)
                    {


                    };


                }
            }
            catch { };
        }
        private void call(string txt)
        {

            if (txt.Length > 0)
            {
                if(txt.IndexOf("part|")!=-1)
                {
                    try
                    {
                        string[] arrstr = txt.Split('|');
                        if (dtmt.Rows.Count == int.Parse(arrstr[1]))
                        {
                            MessageBox.Show("Verify import data The imported data is correct and complete " + dtmt.Rows.Count.ToString() + " Items.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Information);

                        }
                        else
                        {
                            MessageBox.Show("Verify import data The imported data is incomplete.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);


                        }
                    }
                    catch
                    {
                        MessageBox.Show("Verify import data The imported data is incomplete.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);

                    
                    }

                }
                else if (txt.IndexOf("user|") != -1)
                {
                    try
                    {
                        string[] arrstr = txt.Split('|');
                        if (dtmt_user.Rows.Count == int.Parse(arrstr[1]))
                        {
                            MessageBox.Show("Verify import data The imported data is correct and complete " + dtmt_user.Rows.Count.ToString() + " Items.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Information);

                        }
                        else
                        {
                            MessageBox.Show("Verify import data The imported data is incomplete.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);


                        }
                    }
                    catch
                    {
                      
                        MessageBox.Show("Verify import data The imported data is incomplete.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);


                    }

                }
                else
                {

                    getdata(txt);

                }
            }
            else
            {


            }

        }

        private void getdata(string datalog)
        {
            byte[] data = Convert.FromBase64String(datalog);
            string data_row = System.Text.Encoding.UTF8.GetString(data);
            if (data_row.IndexOf("#") != -1)
            {

                string data_xcode = data_row.Substring(0, data_row.Length - 4);
                string codecheck = Crc16Ccitt(Encoding.ASCII.GetBytes(data_xcode)).ToString("X");
                if (codecheck.Length < 4)
                {
                    codecheck = "0" + codecheck;

                }
                if (data_row.IndexOf(codecheck) != -1)
                {

                    String[] arrmain = data_row.Split('#');
                    foreach (string str_row in arrmain)
                    {




                        string str_row_chkeck = str_row.Replace(codecheck, "");
                        if (str_row_chkeck.IndexOf("|") != -1)
                        {


                            string[] drdata = str_row_chkeck.Split('|');

                            string tranid = drdata[0].ToString();
                            string trandate = drdata[1].ToString();
                            string scantime = drdata[2].ToString();
                            string scancode1 = drdata[3].ToString();
                            string scancode2 = drdata[4].ToString();
                            string scancode3 = drdata[5].ToString();
                            string userid = drdata[6].ToString();                          
                            string scanstatus = drdata[7].ToString();
                            string type = drdata[8].ToString();
                            string scantypecode1 = drdata[9].ToString();
                            string scantypecode2 = drdata[10].ToString();
                            string scantypecode3 = drdata[11].ToString();
                            try
                            {
                                tmt_recive = int.Parse(drdata[12].ToString());
                            }
                            catch { };
                            scantypecode1 = scantypecode1 == "1" ? "Character" : "Barcode";
                            scantypecode2 = scantypecode2 == "1" ? "Character" : "Barcode";
                            scantypecode3 = scantypecode3 == "1" ? "Character" : "Barcode";
                            DataRow dr = dt.NewRow();
                            dr[0] = tranid;
                            dr[1] = trandate == "null" ? "" : trandate;
                            dr[2] = scantime == "null" ? "" : scantime;
                            dr[3] = scancode1=="null"?"":scancode1;
                            dr[4] = scancode2 == "null" ? "" : scancode2;
                            dr[5] = scancode3 == "null" ? "" : scancode3;
                            dr[6] = userid == "null" ? "" : userid;
                            dr[8] = scanstatus == "null" ? "" : scanstatus;
                            dr[7] = type == "null" ? "" : type;
                            dr[9] = scantypecode1 == "null" ? "" : scantypecode1;
                            dr[10] = scantypecode2 == "null" ? "" : scantypecode2;
                            dr[11] = scantypecode3 == "null" ? "" : scantypecode3;
                            dt.Rows.Add(dr);




                        }


                    }


                }

            }

            int num = dt.Rows.Count;

            DataView view = dt.DefaultView;
            view.Sort = "#";
            dgv.DataSource = dt.DefaultView.ToTable();
            if ((num)== tmt_recive)
            {
                MessageBox.Show("The information has been received.Total number "+num.ToString("N0")+" Items.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Information);


            }
    
        }



            
           
        
        private void button1_Click(object sender, EventArgs e)
        {
            dt.Clear();
            dgv.DataSource = null;

        }
        private string import_data = string.Empty;
        private string import_data_user = string.Empty;
        private void button2_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.Filter = "Excel files (*.xlsx)|*.xlsx|All files (*.*)|*.*";
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {

                try
                {
                    dtmt_user = null;
                    import_data_user = string.Empty;
                    dgv2.DataSource = null;
                    string FullPath = System.IO.Path.GetFullPath(openFileDialog.FileName);
                    pgb.Visible = true;

                    Thread t = new Thread(() => loaddata(FullPath));
                    t.Start();
                    progressTimer.Enabled = true;


                }
                catch (Exception err)
                {
                    MessageBox.Show(err.ToString(), "Message", MessageBoxButtons.OK, MessageBoxIcon.Error);


                }

                 
                


                




                //ReadExcelFile("Sheet1", FullPath);

                
                
                
                
                //string ConnStr = "Provider=Microsoft.Jet.OLEDB.4.0;" +
                //  "Data Source=" + FullPath +
                //  ";Extended Properties='Excel 8.0;'";
                //string CmdText = "select * from [Sheet1$]";





                //OleDbConnection Con = new OleDbConnection(ConnStr);
                //OleDbDataAdapter adptr = new OleDbDataAdapter(CmdText, Con);
                //DataTable dt = new DataTable();
                //adptr.Fill(dt);
                //ArrayList ardate = new ArrayList();
                //string _date = string.Empty;



            }
        }
        private string str_cmd_instr = string.Empty;
        private string str_cmd_instr_user = string.Empty;
        private DataTable dtmt = new DataTable();
        private DataTable dtmt_user = new DataTable();
        private int rowcount_tmt = 0;
        private int rowcount_tmt2 = 0;
        internal delegate void SetDataSourceDelegate(DataTable dtmt);
        private void setDataSource(DataTable dtmt)
        {
            // Invoke method if required:
            if (this.InvokeRequired)
            {
                this.Invoke(new SetDataSourceDelegate(setDataSource), dtmt);
            }
            else
            {
                progressTimer.Enabled = false;
                dgv1.DataSource = dtmt;
                pgb.Invoke(new MethodInvoker(delegate { pgb.Visible = false; }));
                rowcount_tmt = 0;
            }
        }
        internal delegate void SetDataSourceDelegate2(DataTable dtmt_user);
        private void setDataSource_user(DataTable dtmt_user)
        {
            // Invoke method if required:
            if (this.InvokeRequired)
            {
                this.Invoke(new SetDataSourceDelegate2(setDataSource_user), dtmt_user);
            }
            else
            {
                progressTimer2.Enabled = false;
                dgv2.DataSource = dtmt_user;
                pgb2.Invoke(new MethodInvoker(delegate { pgb2.Visible = false; }));
                rowcount_tmt2 = 0;
            }
        }
        private void loaddata(string FullPath)
        {
            try
            {
                int pointnum = 0;
                dtmt = new DataTable();
                dtmt.Columns.Add("point_number");
                dtmt.Columns.Add("partno_1");
                dtmt.Columns.Add("partno_scan_type_1");
                dtmt.Columns.Add("partno_digi_from_1");
                dtmt.Columns.Add("partno_digi_to_1");
                dtmt.Columns.Add("partno_2");
                dtmt.Columns.Add("partno_scan_type_2");
                dtmt.Columns.Add("partno_digi_from_2");
                dtmt.Columns.Add("partno_digi_to_2");
                dtmt.Columns.Add("partno_3");
                dtmt.Columns.Add("partno_scan_type_3");
                dtmt.Columns.Add("partno_digi_from_3");
                dtmt.Columns.Add("partno_digi_to_3");

                string sError = string.Empty;




                Application.DoEvents();
                Microsoft.Office.Interop.Excel.Application xlApp = new Microsoft.Office.Interop.Excel.Application();
                Microsoft.Office.Interop.Excel.Workbook xlWorkbook = xlApp.Workbooks.Open(FullPath);
                Microsoft.Office.Interop.Excel._Worksheet xlWorksheet = xlWorkbook.Sheets[1];
                Microsoft.Office.Interop.Excel.Range xlRange = xlWorksheet.UsedRange;

                int rowCount = xlRange.Rows.Count;
                int colCount = xlRange.Columns.Count;


                //iterate over the rows and columns and print to the console as it appears in the file
                //excel is not zero based!!
                for (int i = 1; i <= rowCount; i++)
                {
                    for (int j = 1; j <= colCount; j++)
                    {
                        //new line
                        if (j == 1)
                            Console.Write("\r\n");

                        if (i == 3 && j == 5)
                        {
                            try
                            {
                                string chkcol = xlRange.Cells[i, j].Value2.ToString();
                                if (chkcol.ToLower().IndexOf("parts no") != -1)
                                {

                                    pointnum = 3;

                                }
                                else
                                {
                                    pointnum = 2;

                                }
                            }
                            catch
                            {
                                pointnum = 2;
                            };


                        }

                        //write the value to the console
                        if (xlRange.Cells[i, j] != null && xlRange.Cells[i, j].Value2 != null)
                        {


                            if (i >= 4 && j >= 3)
                            {
                                import_data = import_data + "|" + xlRange.Cells[i, j].Value2.ToString();
                            }
                        }
                    }

                    if (import_data.Length > 0)
                    {
                        import_data = import_data + "*" + pointnum.ToString() + "#";

                    }
                }
                xlApp.Application.Quit(); // THIS IS WHAT IS CAUSES EXCEL TO CLOSE
                xlApp.Quit();

                GC.Collect();
                GC.WaitForPendingFinalizers();
                foreach (Process proc in System.Diagnostics.Process.GetProcessesByName("EXCEL"))
                {
                    proc.Kill();
                }

                import_excel(import_data, dtmt);
            }
            catch (Exception err)
            {
                if (err.ToString().IndexOf("CLSID") != -1)
                {
                    MessageBox.Show("Your computer does not have Microsoft Office.Please install Microsoft Office.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Error);

                }
                else
                {
                    MessageBox.Show(err.ToString(), "Message", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

            }


                   
        }
        private void loaddata_user(string FullPath)
        {
            try
            {
                dtmt_user = new DataTable();
                dtmt_user.Columns.Add("userid");
                dtmt_user.Columns.Add("username");
                dtmt_user.Columns.Add("password");
                dtmt_user.Columns.Add("firstname");
                dtmt_user.Columns.Add("lastname");
                dtmt_user.Columns.Add("position");


                string sError = string.Empty;




                Application.DoEvents();
                Microsoft.Office.Interop.Excel.Application xlApp = new Microsoft.Office.Interop.Excel.Application();
                Microsoft.Office.Interop.Excel.Workbook xlWorkbook = xlApp.Workbooks.Open(FullPath);
                Microsoft.Office.Interop.Excel._Worksheet xlWorksheet = xlWorkbook.Sheets[1];
                Microsoft.Office.Interop.Excel.Range xlRange = xlWorksheet.UsedRange;

                int rowCount = xlRange.Rows.Count;
                int colCount = xlRange.Columns.Count;


                //iterate over the rows and columns and print to the console as it appears in the file
                //excel is not zero based!!
                for (int i = 1; i <= rowCount; i++)
                {
                    for (int j = 1; j <= colCount; j++)
                    {
                        //new line
                        if (j == 1)
                            Console.Write("\r\n");

                        //write the value to the console
                        if (xlRange.Cells[i, j] != null && xlRange.Cells[i, j].Value2 != null)
                        {
                            if (i >= 2 && j >= 1)
                            {
                                import_data_user = import_data_user + "|" + xlRange.Cells[i, j].Value2.ToString();
                            }
                        }
                    }
                    import_data_user = import_data_user + "#";
                }
                xlApp.Application.Quit(); // THIS IS WHAT IS CAUSES EXCEL TO CLOSE
                xlApp.Quit();

                GC.Collect();
                GC.WaitForPendingFinalizers();
                foreach (Process proc in System.Diagnostics.Process.GetProcessesByName("EXCEL"))
                {
                    proc.Kill();
                }

                import_excel_user(import_data_user, dtmt_user);
            }
            catch (Exception err)
            {
                if (err.ToString().IndexOf("CLSID") != -1)
                {
                    MessageBox.Show("Your computer does not have Microsoft Office.Please install Microsoft Office.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Error);

                }
                else
                {
                    MessageBox.Show(err.ToString(), "Message", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

            }



        }

        private void import_excel(string items,DataTable dtmt)
        {

            if (items.IndexOf("#") != -1)
            {

                string[] arr_items = items.Split('#');
                string point=string.Empty;
                string str_items = string.Empty;
                foreach(String str in arr_items)
                {
                    if(str.Length>0)
                    {
                        if(str.IndexOf("*")!=-1)
                        {
                            string[] sp = str.Split('*');
                            str_items = sp[0];
                            point = sp[1];

                        }

                        if(str_items.IndexOf("|")!=-1)
                        {

                            string[] str_list = str_items.Split('|');

                            string partno1 = string.Empty;
                            string partno2 = string.Empty;
                            string partno3 = string.Empty;
                            string type1 = string.Empty;
                            string type2 = string.Empty;
                            string type3 = string.Empty;
                            string dgt_from1 = string.Empty;
                            string dgt_to1 = string.Empty;
                            string dgt_from2 = string.Empty;
                            string dgt_to2 = string.Empty;
                            string dgt_from3 = string.Empty;
                            string dgt_to3 = string.Empty;

                            if (point == "3")
                            {

                                try { partno1 = str_list[1].ToString(); }
                                catch { partno1 = ""; }
                                try { partno2 = str_list[2].ToString(); }
                                catch { partno2 = ""; }
                                try { partno3 = str_list[3].ToString(); }
                                catch { partno3 = ""; }
                                try { type1 = str_list[4].ToString(); }
                                catch { partno1 = ""; }
                                try { type2 = str_list[5].ToString(); }
                                catch { partno2 = ""; }
                                try { type3 = str_list[6].ToString(); }
                                catch { partno3 = ""; }
                                if (type1.ToLower() == "character")
                                {
                                    type1 = "1";
                                }
                                else
                                {
                                    type1 = "2";

                                }
                                if (type2.ToLower() == "character")
                                {
                                    type2 = "1";
                                }
                                else
                                {
                                    type2 = "2";
                                }
                                if (type3.ToLower() == "character")
                                {
                                    type3 = "1";
                                }
                                else
                                {
                                    type3 = "2";
                                }
                                try { dgt_from1 = str_list[7].ToString(); }
                                catch { dgt_from1 = ""; }
                                try { dgt_to1 = str_list[8].ToString(); }
                                catch { dgt_from1 = ""; }
                                try { dgt_from2 = str_list[9].ToString(); }
                                catch { dgt_from2 = ""; }
                                try { dgt_to2 = str_list[10].ToString(); }
                                catch { dgt_from2 = ""; }
                                try { dgt_from3 = str_list[11].ToString(); }
                                catch { dgt_from3 = ""; }
                                try { dgt_to3 = str_list[12].ToString(); }
                                catch { dgt_from3 = ""; }
                            }
                            else
                            {


                                try { partno1 = str_list[1].ToString(); }
                                catch { partno1 = ""; }
                                try { partno2 = str_list[2].ToString(); }
                                catch { partno2 = ""; }
                                try { partno3 = ""; }
                                catch { partno3 = ""; }
                                try { type1 = str_list[3].ToString(); }
                                catch { partno1 = ""; }
                                try { type2 = str_list[4].ToString(); }
                                catch { partno2 = ""; }
                                try { type3 = ""; }
                                catch { partno3 = ""; }
                                if (type1.ToLower() == "character")
                                {
                                    type1 = "1";
                                }
                                else
                                {
                                    type1 = "2";

                                }
                                if (type2.ToLower() == "character")
                                {
                                    type2 = "1";
                                }
                                else
                                {
                                    type2 = "2";
                                }
                        
                                try { dgt_from1 = str_list[5].ToString(); }
                                catch { dgt_from1 = ""; }
                                try { dgt_to1 = str_list[6].ToString(); }
                                catch { dgt_from1 = ""; }
                                try { dgt_from2 = str_list[7].ToString(); }
                                catch { dgt_from2 = ""; }
                                try { dgt_to2 = str_list[8].ToString(); }
                                catch { dgt_from2 = ""; }
                             


                            }
                      



                            str_cmd_instr = str_cmd_instr + point + "|" + partno1 + "|" + type1 + "|" + dgt_from1 + "|" + dgt_to1 + "|" + partno2 + "|" + type2 + "|" + dgt_from2 + "|" + dgt_to2 + "|" + partno3 + "|" + type3 + "|" + dgt_from3 + "|" + dgt_to3 + "#";

                            DataRow drnew = dtmt.NewRow();
                            drnew[0] = point;
                            drnew[1] = partno1;
                            drnew[2] = type1;
                            drnew[3] = dgt_from1;
                            drnew[4] = dgt_to1;
                            drnew[5] = partno2;
                            drnew[6] = type2;
                            drnew[7] = dgt_from2;
                            drnew[8] = dgt_to2;
                            drnew[9] = partno3;
                            drnew[10] = type3;
                            drnew[11] = dgt_from3;
                            drnew[12] = dgt_to3;
                            dtmt.Rows.Add(drnew);



                            

                        }




                    }



                }


                setDataSource(dtmt);

            }
            




        }
        private void import_excel_user(string items, DataTable dtmt_user)
        {

            if (items.IndexOf("#") != -1)
            {

                string[] arr_items = items.Split('#');
                foreach (String str in arr_items)
                {
                    if (str.Length > 0)
                    {

                        if (str.IndexOf("|") != -1)
                        {


                            string[] str_list = str.Split('|');

                            string userid = string.Empty;
                            string username = string.Empty;
                            string password = string.Empty;
                            string firstname = string.Empty;
                            string lastname = string.Empty;
                            string position = string.Empty;
                           


                            try { userid = str_list[1].ToString(); }
                            catch { userid = ""; }
                            try { username = str_list[2].ToString(); }
                            catch { username = ""; }
                            try { password = str_list[3].ToString(); }
                            catch { password = ""; }
                            try { firstname = str_list[4].ToString(); }
                            catch { firstname = ""; }
                            try { lastname = str_list[5].ToString(); }
                            catch { lastname = ""; }
                            try { position = str_list[6].ToString(); }
                            catch { position = ""; }


                            if (username.Length > 0)
                            {
                                str_cmd_instr_user = str_cmd_instr_user + username + "|" + password + "|" + firstname + "|" + lastname + "|" + position + "#";

                                DataRow drnew0 = dtmt_user.NewRow();
                                drnew0[0] = userid;
                                drnew0[1] = username;
                                drnew0[2] = password;
                                drnew0[3] = firstname;
                                drnew0[4] = lastname;
                                drnew0[5] = position;

                                dtmt_user.Rows.Add(drnew0);
                            }





                        }




                    }



                }


                setDataSource_user(dtmt_user);

            }





        }
        private void progressTimer_Tick(object sender, EventArgs e)
        {

            try
            {
                pgb.Value = rowcount_tmt + 2;
                rowcount_tmt = rowcount_tmt + 2;
            }
            catch
            {
                pgb.Value = 95;
                rowcount_tmt = 95;

            }
        
        }
   
        private void button3_Click(object sender, EventArgs e)
        {
            if (txtIP.Text.Length == 0)
            {

                MessageBox.Show("Please enter the IP address of BT-A500.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);


            }
            else
            {
                arritem.Clear();
                icount = 0;
                iround = 1;
                irow = 0;
                pgb.Visible = true;
                dtmt_user = null;
                dgv2.DataSource = null;
                import_data_user = string.Empty;
                Thread t = new Thread(() => importdata());
                t.Start();
                progressTimer.Enabled = true;
            }




        }
        private ArrayList arritem = new ArrayList();
        private int irow = 0;
        private int icount = 0;
        private int iround = 1;
        private void importdata()
        {
            string data_import = string.Empty;
            if (this.InvokeRequired)
            {
                if (str_cmd_instr == "")
                {
                    progressTimer.Enabled = false;
                    try
                    {
                        pgb.Invoke(new MethodInvoker(delegate { pgb.Visible = false; }));
                    }
                    catch { }
                    rowcount_tmt = 0;
                    MessageBox.Show("Data not found import.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);

                }
                else
                {
                    string[] split_cmd = str_cmd_instr.Split('#');
              
                    foreach (String strline in split_cmd)
                    {
                        if (strline.Length > 0)
                        {
                            string items = irow.ToString() + "|" + strline;
                            string codecheck = Crc16Ccitt(Encoding.ASCII.GetBytes(items)).ToString("X");
                            if (codecheck.Length < 4)
                            {
                                codecheck = "0" + codecheck;

                            }
                            data_import = data_import + items + "|" + codecheck + "|*part#";
                            icount++;
                            irow++;

                            if (icount == 100)
                            {
                                arritem.Add(data_import);
                                iround++;
                                icount = 0;
                                data_import = string.Empty;
                            }
                            if(irow>=split_cmd.Length-1)
                            {
                                arritem.Add(data_import);
                                iround++;
                                icount = 0;
                                data_import = string.Empty;

                            }
                           

                        }


                    }
        
                    if(arritem.Count>0)
                    {


                        foreach (string str in arritem)
                        {
                            if (str.Length > 0)
                            {
                                System.Threading.Thread.Sleep(3000);
                                //byte[] plantext = System.Text.Encoding.UTF8.GetBytes(str);
                                //string en64str = System.Convert.ToBase64String(plantext);
                                using (UdpClient udpClient = new UdpClient())
                                {
                                    udpClient.Connect(txtIP.Text.Trim(), 8080);
                                    Byte[] senddata = Encoding.ASCII.GetBytes(str);
                                    udpClient.Send(senddata, senddata.Length);


                                }


                            }



                        }



                    }
                    

                    System.Threading.Thread.Sleep(3000);
                    pgb.Invoke(new MethodInvoker(delegate { pgb.Visible = false; }));
                    progressTimer.Enabled = false;
                    rowcount_tmt = 0;

                }

            }
            else
            {


                progressTimer.Enabled = false;
                pgb.Invoke(new MethodInvoker(delegate { pgb.Visible = false; }));
                rowcount_tmt = 0;

            }


        }

        private void importdata_user()
        {
            string data_import = string.Empty;
            if (this.InvokeRequired)
            {
                if (str_cmd_instr_user == "")
                {
                    progressTimer2.Enabled = false;
                    try
                    {
                        pgb2.Invoke(new MethodInvoker(delegate { pgb2.Visible = false; }));
                    }
                    catch { }
                    rowcount_tmt2 = 0;
                    MessageBox.Show("Data not found import.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);

                }
                else
                {
                    string[] split_cmd = str_cmd_instr_user.Split('#');

                    foreach (String strline in split_cmd)
                    {
                        if (strline.Length > 0)
                        {
                            string items = irow.ToString() + "|" + strline;
                            string codecheck = Crc16Ccitt(Encoding.ASCII.GetBytes(items)).ToString("X");
                            if (codecheck.Length < 4)
                            {
                                codecheck = "0" + codecheck;

                            }
                            data_import = data_import + items + "|" + codecheck  +"|*user#";
                            icount++;
                            irow++;

                            if (icount == 100)
                            {
                                arritem.Add(data_import);
                                iround++;
                                icount = 0;
                                data_import = string.Empty;
                            }
                            if (irow >= split_cmd.Length - 1)
                            {
                                arritem.Add(data_import);
                                iround++;
                                icount = 0;
                                data_import = string.Empty;

                            }


                        }


                    }

                    if (arritem.Count > 0)
                    {


                        foreach (string str in arritem)
                        {
                            if (str.Length > 0)
                            {
                                System.Threading.Thread.Sleep(3000);
                                //byte[] plantext = System.Text.Encoding.UTF8.GetBytes(str);
                                //string en64str = System.Convert.ToBase64String(plantext);
                                using (UdpClient udpClient = new UdpClient())
                                {
                                    udpClient.Connect(txtIP.Text.Trim(), 8080);
                                    Byte[] senddata = Encoding.ASCII.GetBytes(str);
                                    udpClient.Send(senddata, senddata.Length);


                                }


                            }



                        }



                    }


                    System.Threading.Thread.Sleep(3000);
                    pgb2.Invoke(new MethodInvoker(delegate { pgb2.Visible = false; }));
                    progressTimer.Enabled = false;
                    rowcount_tmt2 = 0;

                }

            }
            else
            {


                progressTimer2.Enabled = false;
                pgb2.Invoke(new MethodInvoker(delegate { pgb2.Visible = false; }));
                rowcount_tmt2 = 0;

            }


        }


        private void BT500_tranfer_Load(object sender, EventArgs e)
        {
            dt = new DataTable();
            dt.Columns.Add("#",typeof(System.Int32));
            dt.Columns.Add("Date");
            dt.Columns.Add("Scan_time");
            dt.Columns.Add("1st_Scan_code");
            dt.Columns.Add("2nd_Scan_code");
            dt.Columns.Add("3rd_Scan_code");
            dt.Columns.Add("User_ID");
            dt.Columns.Add("OK/NG");
            dt.Columns.Add("Scan_Point");
            dt.Columns.Add("1st_Scan_type");
            dt.Columns.Add("2nd_Scan_type");
            dt.Columns.Add("3rd_Scan_type");

           
          


            thdUDPServer = new Thread(new ThreadStart(serverThread));
            thdUDPServer.Start();
        }


        public ushort Crc16Ccitt(byte[] bytes)
        {
            const ushort poly = 4129;
            ushort[] table = new ushort[256];
            ushort initialValue = 0xffff;
            ushort temp, a;
            ushort crc = initialValue;
            for (int i = 0; i < table.Length; ++i)
            {
                temp = 0;
                a = (ushort)(i << 8);
                for (int j = 0; j < 8; ++j)
                {
                    if (((temp ^ a) & 0x8000) != 0)
                        temp = (ushort)((temp << 1) ^ poly);
                    else
                        temp <<= 1;
                    a <<= 1;
                }
                table[i] = temp;
            }
            for (int i = 0; i < bytes.Length; ++i)
            {
                crc = (ushort)((crc << 8) ^ table[((crc >> 8) ^ (0xff & bytes[i]))]);
            }
            return crc;
        }

        private void btn_connect_Click(object sender, EventArgs e)
        {
            if (txtIP.Text.Length == 0)
            {

                MessageBox.Show("Please enter the IP address of BT-A500.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);


            }
            else
            {
                using (UdpClient udpClient = new UdpClient())
                {
                    udpClient.Connect(txtIP.Text.Trim(), 8080);
                    Byte[] senddata = Encoding.ASCII.GetBytes("connect");
                    udpClient.Send(senddata, senddata.Length);


                }
            }
        }

      

        private void btn_loadcsv_user_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog = new OpenFileDialog();
            openFileDialog.Filter = "Excel files (*.xlsx)|*.xlsx|All files (*.*)|*.*";
            if (openFileDialog.ShowDialog() == DialogResult.OK)
            {
                try
                {
                    dtmt = null;
                    import_data = string.Empty;
                    dgv1.DataSource = null;
                    string FullPath = System.IO.Path.GetFullPath(openFileDialog.FileName);
                    pgb2.Visible = true;

                    Thread t = new Thread(() => loaddata_user(FullPath));
                    t.Start();
                    progressTimer2.Enabled = true;
                } 
                catch (Exception err)
                {
                    MessageBox.Show(err.ToString(), "Message", MessageBoxButtons.OK, MessageBoxIcon.Error);


                }




            }
        }

        private void btn_send_user_Click(object sender, EventArgs e)
        {
            if (txtIP.Text.Length == 0)
            {

                MessageBox.Show("Please enter the IP address of BT-A500.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Warning);


            }
            else
            {
                arritem.Clear();
                icount = 0;
                iround = 1;
                irow = 0;
                pgb2.Visible = true;
                dtmt = null;
                import_data = string.Empty;
                dgv1.DataSource = null;
                Thread t = new Thread(() => importdata_user());
                t.Start();
                progressTimer2.Enabled = true;
            }
        }

        private void progressTimer2_Tick(object sender, EventArgs e)
        {

            try
            {
                pgb2.Value = rowcount_tmt2 + 2;
                rowcount_tmt2 = rowcount_tmt2 + 2;
            }
            catch
            {
                pgb2.Value = 95;
                rowcount_tmt2 = 95;

            }
        
        }

        private void btn_exportxls_Click(object sender, EventArgs e)
        {

        }

        private void btn_exportcsv_Click(object sender, EventArgs e)
        {
            try
            {
                ToCSV(dt, Application.StartupPath + "//bt_a500_log.csv");
                var p = new Process();
                p.StartInfo.FileName = Application.StartupPath + "//bt_a500_log.csv";  // just for example, you can use yours.
                p.Start();
            }
            catch (Exception err)
            {
                if (err.ToString().IndexOf("CLSID") != -1)
                {
                    MessageBox.Show("Your computer does not have Microsoft Office.Please install Microsoft Office.", "Message", MessageBoxButtons.OK, MessageBoxIcon.Error);

                }
                else
                {
                    MessageBox.Show(err.ToString(), "Message", MessageBoxButtons.OK, MessageBoxIcon.Error);
                }

            }

        }

        private void ToCSV(DataTable dtDataTable, string strFilePath)
        {
            StreamWriter sw = new StreamWriter(strFilePath, false);
            //headers
            for (int i = 0; i < dtDataTable.Columns.Count; i++)
            {
                sw.Write(dtDataTable.Columns[i]);
                if (i < dtDataTable.Columns.Count - 1)
                {
                    sw.Write(",");
                }
            }
            sw.Write(sw.NewLine);
            foreach (DataRow dr in dtDataTable.Rows)
            {
                for (int i = 0; i < dtDataTable.Columns.Count; i++)
                {
                    if (!Convert.IsDBNull(dr[i]))
                    {
                        string value = dr[i].ToString();
                        if (value.Contains(','))
                        {
                            value = String.Format("\"{0}\"", value);
                            sw.Write(value);
                        }
                        else
                        {
                            sw.Write(dr[i].ToString());
                        }
                    }
                    if (i < dtDataTable.Columns.Count - 1)
                    {
                        sw.Write(",");
                    }
                }
                sw.Write(sw.NewLine);
            }
            sw.Close();
        }

        private void btn_clear_part_Click(object sender, EventArgs e)
        {
            dtmt = null;
            import_data = string.Empty;
            dgv1.DataSource = null;
        }

        private void btn_clear_user_Click(object sender, EventArgs e)
        {
            dtmt_user = null;
            import_data_user = string.Empty;
            dgv2.DataSource = null;
        }

        private void BT500_tranfer_FormClosing(object sender, FormClosingEventArgs e)
        {
           

            if (MessageBox.Show("Do you want to close the program?", "Confirm", MessageBoxButtons.YesNo) == DialogResult.No)
            {
                
                e.Cancel = true;
               
           
            }
        }

        private void BT500_tranfer_FormClosed(object sender, FormClosedEventArgs e)
        {
            udpClient.Close();
            thdUDPServer.Abort();

            thdUDPServer.Abort();
            Application.Exit();
            Application.ExitThread();

        }

       
    }
}