package com.tomas.ht_mast.lib.common;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 *
 * @author nack_ki
 */
public class DatetimeUtil {

    public static enum DATETIME_FIELD {

        YEAR,
        MONTH,
        DATE,
        HOUR,
        MINUTE,
        SECOND
    }

    public enum DF_DATE {

        DF_SECOND(1000),
        DF_MINUTE(60 * 1000),
        DF_HOUR(60 * 60 * 1000),
        DF_DAY(24 * 60 * 60 * 1000);
        private final int id;

        DF_DATE(final int id) {
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public static DF_DATE fromId(final int id) {
            for (DF_DATE e : DF_DATE.values()) {
                if (e.id == id) {
                    return e;
                }
            }
            return null;
        }
    }

    public static String getDateTime() {
        DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static String getDateTime(String format) {
        DateFormat dateFormat = new SimpleDateFormat(format);
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static String getDateTime(long sec) {
        DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date(sec);
        return dateFormat.format(date);
    }

    public static String getDateTime(long sec, String format) {
        DateFormat dateFormat = new SimpleDateFormat(format);
        Date date = new Date(sec);
        return dateFormat.format(date);
    }

    public static String getDateTime(DATETIME_FIELD dt) {
        String datetime = getDateTime();
        String buff = "";
        switch (dt) {
            case YEAR:
                buff = datetime.substring(0, 4);
                break;
            case MONTH:
                buff = datetime.substring(4, 6);
                break;
            case DATE:
                buff = datetime.substring(6, 8);
                break;
            case HOUR:
                buff = datetime.substring(8, 10);
                break;
            case MINUTE:
                buff = datetime.substring(10, 12);
                break;
            case SECOND:
                buff = datetime.substring(12, 14);
                break;
        }
        return buff;
    }

    public static Date toDate(String d, String format) throws ParseException {
        return new SimpleDateFormat(format).parse(d);
    }

    public static long dateDiff(String from, String to, String format, DF_DATE unit) {
        long diff = -1;
        try {
            diff = (toDate(to, format).getTime() - toDate(from, format).getTime()) / unit.getId();
        } catch (ParseException e) {
            System.err.println(e.getMessage());
        }
        return diff;
    }

    public static String changeDateFormat(String d, String format, String new_format) {
        DateFormat dateFormat = new SimpleDateFormat(new_format);
        Date date = null;
        try {
            date = new SimpleDateFormat(format).parse(d);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return dateFormat.format(date);
    }

    public static String print(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Date toDate(Timestamp timestamp) {
        long milliseconds = timestamp.getTime() + (timestamp.getNanos() / 1000000);
        return new Date(milliseconds);
    }

    public static Timestamp toTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Date add(Date date, int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);

        return cal.getTime();
    }

    public static long fromJulian(String input, String format){
        long secs = 0;
        try {
            secs = toDate(input, format).getTime();
        } catch (ParseException e) {
            System.err.println(e.getMessage());
        }

        return secs;
    }
}

