package com.tomas.ht_mast;

import android.annotation.SuppressLint;
import android.app.DatePickerDialog;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Color;
import android.graphics.Interpolator;
import android.graphics.pdf.PdfDocument;
import android.os.Bundle;
import android.os.Handler;
import android.service.autofill.Dataset;
import android.text.InputType;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.Switch;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.keyence.autoid.sdk.scan.DecodeResult;

import com.tomas.ht_mast.Adapter.Workhistory_Adapter;

import com.tomas.ht_mast.ListData.Workhistory_Item;
import com.tomas.ht_mast.lib.AlertProgress;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.Scanner;
import com.tomas.ht_mast.lib.SettingsHelper;
import com.tomas.ht_mast.lib.db.DBHelper;

import org.json.JSONObject;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class Workhistory_Activity extends Scanner implements View.OnClickListener {
    TextView txt_user, txt_device, txt_date,txt_result;

    CheckBox chkok,chkng;

    EditText txt_partno1,txt_partno2,txt_partno3;
    DecimalFormat decimalFormat;
    AlertProgress alert;

    RecyclerView view_workhistory;

    private ArrayList<Workhistory_Item> list_item_sch = new ArrayList<>();
    Workhistory_Adapter workhistory_adapter;

    Integer page = 0,check_page=0,item_perpage=10,item_scroll_page=10;

    Integer icount_scan=0;

    String str_date_from,datefilter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activeity_work_history);


        decimalFormat = new DecimalFormat("##0.00");

        alert = new AlertProgress(Workhistory_Activity.this);


        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        String date = df.format(calendar.getTime());



        txt_date = (TextView) findViewById(R.id.txt_date);
        txt_date.setText(date);
        txt_date.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                final Calendar currentDate = Calendar.getInstance();
                new DatePickerDialog(Workhistory_Activity.this, new DatePickerDialog.OnDateSetListener() {
                    @Override
                    public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                        str_date_from = ( year+"-"+
                                (String.format("%2s",monthOfYear + 1).replace(' ','0'))+"-"+
                                (String.format("%2s",dayOfMonth).replace(' ','0')));
                        txt_date.setText(str_date_from);
                        datefilter = " and scan_date between '"+str_date_from+" 00:00:00' and '"+str_date_from+" 23:59:59'";
                        list_item_sch.clear();
                        get_work_history();

                    }
                }, currentDate.get(Calendar.YEAR), currentDate.get(Calendar.MONTH), currentDate.get(Calendar.DATE)).show();
            }
        });

        txt_partno1 = (EditText) findViewById(R.id.txt_partno1);
        txt_partno1.setInputType(InputType.TYPE_NULL); // disable soft input
        txt_partno1.setOnKeyListener(new View.OnKeyListener() {
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                // If the event is a key-down event on the "enter" button
                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
                        (keyCode == KeyEvent.KEYCODE_ENTER)) {

                    return true;
                }
                return false;
            }
        });
        txt_partno1.requestFocus();

        txt_partno2 = (EditText) findViewById(R.id.txt_partno2);
        txt_partno2.setInputType(InputType.TYPE_NULL); // disable soft input
        txt_partno2.setOnKeyListener(new View.OnKeyListener() {
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                // If the event is a key-down event on the "enter" button
                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
                        (keyCode == KeyEvent.KEYCODE_ENTER)) {

                    return true;
                }
                return false;
            }
        });
        txt_partno3 = (EditText) findViewById(R.id.txt_partno3);
        txt_partno3.setInputType(InputType.TYPE_NULL); // disable soft input
        txt_partno3.setOnKeyListener(new View.OnKeyListener() {
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                // If the event is a key-down event on the "enter" button
                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
                        (keyCode == KeyEvent.KEYCODE_ENTER)) {


                    return true;
                }
                return false;
            }
        });


        view_workhistory = (RecyclerView) findViewById(R.id.view_workhistory);
        view_workhistory.setHasFixedSize(true);
        view_workhistory.setRecycledViewPool(new RecyclerView.RecycledViewPool());
        view_workhistory.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
        view_workhistory.addItemDecoration(new DividerItemDecoration(this, DividerItemDecoration.VERTICAL));
        view_workhistory.setItemAnimator(new DefaultItemAnimator());
        view_workhistory.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);

                if (!recyclerView.canScrollVertically(1)) {


                  page   =  list_item_sch.size();


                  if(page > check_page) {

                      get_work_history();
                      check_page = page;

                      if(page.equals(item_scroll_page*2))
                      {

                          recyclerView.smoothScrollToPosition(item_scroll_page);
                      }
                      else {
                          recyclerView.smoothScrollToPosition(item_scroll_page * page);
                      }
                  }


                }
            }

        });



        chkok = (CheckBox) findViewById(R.id.chkOK);
        chkok.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked)
            {
               filter_work_history();

            }
        });
        chkng = (CheckBox) findViewById(R.id.chkNG);
        chkng.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener()
        {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked)
            {
               filter_work_history();

            }
        });
        chkok.setChecked(true);
        chkng.setChecked(true);



    }
    @Override
    protected void onStart() {
        super.onStart();

        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        datefilter = df.format(calendar.getTime());

        datefilter = " and scan_date between '"+datefilter+" 00:00:00' and '"+datefilter+" 23:59:59'";

        get_work_history();


    }

    private  void clear()
    {
        txt_partno1.setText("");
        txt_partno2.setText("");
        txt_partno3.setText("");
        icount_scan=0;

        filter_work_history();


    }

    private  void filter_work_history() {
        page = 0;
        check_page = 0;
        list_item_sch.clear();
        view_workhistory.removeAllViews();
        get_work_history();

    }


    @SuppressLint("Range")
    public  void get_work_history()
    {
        try {

            String filter="";




            if(chkng.isChecked() && chkok.isChecked())
            {
                filter = " and (scan_status='OK' or  scan_status='NG')";
            }

            else if(chkng.isChecked() && !chkok.isChecked())
            {

                filter = " and scan_status='NG' ";

            }

            else if(chkok.isChecked() && !chkng.isChecked())
            {

                filter = " and scan_status='OK' ";

            }

            if(!txt_partno1.getText().toString().equals(""))
            {

                filter = filter + " and scan_code1='"+txt_partno1.getText().toString().trim()+"'";

            }
            if(!txt_partno2.getText().toString().equals(""))
            {

                filter = filter + " and scan_code2='"+txt_partno2.getText().toString().trim()+"'";

            }
            if(!txt_partno3.getText().toString().equals(""))
            {

                filter = filter + " and scan_code3='"+txt_partno3.getText().toString().trim()+"'";

            }

            String str_work_history = "select tranid,scan_date,scan_time,scan_code1,scan_code2,scan_code3,userid,scan_status,type from log_transaction Where 1=1 "+datefilter+" "+filter+" limit "+item_perpage+" offset "+page;



            SQLiteDatabase db = DBHelper.getDB();
            db.isOpen();
            Cursor resx = db.rawQuery(str_work_history, null);
            resx.moveToFirst();
            while (resx.isAfterLast() == false) {

                try {



                    String strtran_date = resx.getString(resx.getColumnIndex("scan_date"));
                    SimpleDateFormat format_input = new SimpleDateFormat("yyyy-MM-dd");
                    SimpleDateFormat format_output = new SimpleDateFormat("dd-MMM-yyyy");
                    try {
                       String[] arr = strtran_date.split(" ");
                       Date ddate = format_input.parse(arr[0].trim());
                       strtran_date = format_output.format(ddate);


                    } catch (Exception e) {
                        new SweetAlertDialog(this, SweetAlertDialog.WARNING_TYPE)
                                .setTitleText("WARNING")
                                .setContentText(e.getMessage())
                                .show();
                    }


                    list_item_sch.add(new Workhistory_Item(
                            resx.getString(resx.getColumnIndex("tranid")),
                            strtran_date,
                            resx.getString(resx.getColumnIndex("scan_time")),
                            resx.getString(resx.getColumnIndex("scan_code1")),
                            resx.getString(resx.getColumnIndex("scan_code2")),
                            resx.getString(resx.getColumnIndex("scan_code3")),
                            resx.getString(resx.getColumnIndex("userid")),
                            resx.getString(resx.getColumnIndex("type")),
                            resx.getString(resx.getColumnIndex("scan_status")),
                            "***"));


                    resx.moveToNext();
                } catch (Exception e) {

                    e.printStackTrace();


                }
            }
            db.close();



            if(list_item_sch.size()>0) {
                workhistory_adapter = new Workhistory_Adapter(list_item_sch, this);
                view_workhistory.setAdapter(workhistory_adapter);
            }
            else
            {
                new SweetAlertDialog(Workhistory_Activity.this, SweetAlertDialog.WARNING_TYPE)
                        .setTitleText("WARNING")
                        .setContentText("Data Not found!!!")
                        .show();
                view_workhistory.removeAllViews();

            }



        } catch (Exception e) {
            e.printStackTrace();

        }



    }


    public void processData(String data, DecodeResult.Result result, String codeType) {

        try {


            if(result.toString().trim().equals("SUCCESS")) {

                switch (icount_scan) {
                    case 0 :
                    {

                        final Handler handler = new Handler();
                        handler.postDelayed(new Runnable() {
                            @Override
                            public void run() {

                                txt_partno1.setText(data);
                                txt_partno2.setText("");
                                txt_partno3.setText("");
                                icount_scan = 1;
                                filter_work_history();

                            }
                        },300);

                        break;
                    }
                    case 1 :
                    {
                        final Handler handler = new Handler();
                        handler.postDelayed(new Runnable() {
                            @Override
                            public void run() {

                                txt_partno2.setText(data);
                                txt_partno3.setText("");
                                icount_scan = 2;
                                filter_work_history();

                            }
                        },300);


                        break;
                    }
                    case 2 :
                    {
                        final Handler handler = new Handler();
                        handler.postDelayed(new Runnable() {
                            @Override
                            public void run() {

                                txt_partno3.setText(data);
                                filter_work_history();


                            }
                        },300);

                        break;
                    }

                }

            }
            if (data.trim().equals(""))
                return;





        } catch (Exception e) {
            Log.e(getString(R.string.tag), "ERROR: " + e.getMessage());
        }


    }

    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.imb_back:
                intent = new Intent(this, MainMenu_Activity.class);
                startActivity(intent);
                break;



        }
    }


    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P2.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    Intent intent = new Intent(this, MainMenu_Activity.class);
                    startActivity(intent);
                    break;
                case P2:
                    clear();
                    break;
                case ENT:
                    filter_work_history();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void onBackPressed() {
        finishAffinity();
        System.exit(0);
    }
}