package com.tomas.ht_mast;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.tomas.ht_mast.lib.AlertProgress;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.SettingsHelper;

import java.text.DecimalFormat;

public class SubMenu_Activity  extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device;
    DecimalFormat decimalFormat;
    AlertProgress alert;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activeity_sub_menu);

        decimalFormat = new DecimalFormat("##0.00");

        alert = new AlertProgress(SubMenu_Activity.this);


        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ SettingsHelper.username);

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Position : "+ SettingsHelper.position);


    }


    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.btn_import:
                intent = new Intent(SubMenu_Activity.this, Import_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_importuser:
                intent = new Intent(SubMenu_Activity.this, Import_user_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_export:
                intent = new Intent(SubMenu_Activity.this, Export_Activity.class);
                startActivity(intent);
                break;



            case R.id.btn_mainmenu:
                intent = new Intent(SubMenu_Activity.this, MainMenu_Activity.class);
                startActivity(intent);
                break;
        }
    }


    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:

                    Intent intent = new Intent(SubMenu_Activity.this, MainMenu_Activity.class);
                    startActivity(intent);
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void onBackPressed() {
        finishAffinity();
        System.exit(0);
    }
}