package com.tomas.ht_mast;

import static android.content.ContentValues.TAG;

import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.tomas.ht_mast.ListData.ItemFifo_list;
import com.tomas.ht_mast.ListData.LabelItem_out_sh_list;
import com.tomas.ht_mast.ListData.Payload_list_out;
import com.tomas.ht_mast.lib.ActionType;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.Scanner;
import com.tomas.ht_mast.lib.Settings;
import com.tomas.ht_mast.lib.common.AsyncFtpClient;
import com.tomas.ht_mast.lib.common.AsyncHttpClient;
import com.tomas.ht_mast.lib.common.FileUtil;
import com.tomas.ht_mast.lib.common.MyAlertDialog;
import com.tomas.ht_mast.lib.common.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class PrinterSetting_Activity extends Scanner implements View.OnClickListener {

    TextView txt_settings_device_no ;
    private Button btn_settings_submit, btn_settings_cancel, btn_restore_default_factory;

    public static Map<Integer, String> prop_map = new HashMap<>();

    public static final Map<Integer, String> prop_key = new HashMap<Integer, String>() {{
        put(R.id.txt_settings_device_no, "printer");
    }};

    private void init() {
        prop_map = new HashMap<Integer, String>() {{
            put(R.id.txt_settings_device_no, Settings.getPrinter());
        }};

    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_printer_setting);
        default_view = (EditText) findViewById(R.id.txt_label_issue_tmp);
        init();

        txt_settings_device_no = (TextView) findViewById(R.id.txt_settings_device_no);

        // button
        btn_settings_submit = (Button) findViewById(R.id.btn_settings_submit);
        btn_settings_cancel = (Button) findViewById(R.id.btn_settings_cancel);
        txt_settings_device_no.setText(Settings.getPrinter());
        txt_settings_device_no.setTextColor(getResources().getColor(R.color.black));


        // Event
        btn_settings_submit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                Map<String, String> map = Settings.getSettingList();
                Iterator iter = prop_map.keySet().iterator();
                while (iter.hasNext()) {
                    Integer key = (Integer) iter.next();
                    map.put(prop_key.get(key), ((TextView) findViewById((int)key)).getText().toString());
                }
                Settings.updateSettingsFile(map, getApplicationContext().getFilesDir().getAbsolutePath());

                    Settings.readSettingFile(getApplicationContext().getFilesDir());
                    new MyAlertDialog(PrinterSetting_Activity.this, "Alert",
                            "Settings saved.",
                            new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int which) {
                                    finish();
                                }
                    });
            }
        });
        btn_settings_cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.imb_back:
                finish();
                break;
        }
    }


    @Override
    public void processData(String data, DecodeResult.Result result, String codeType) {
        try {
            Log.d(getString(R.string.tag), "data read:" + data);

            String[] tokens = data.split(getString(R.string.DELIMITER_SCAN_TOKEN), -1);
            Log.d(getString(R.string.tag), Arrays.deepToString(tokens));

            txt_settings_device_no.setText(tokens[0]);
            txt_settings_device_no.setTextColor(getResources().getColor(R.color.gray));


            Utils.hideKeyboardFrom(getApplicationContext(), default_view);

        }catch (Exception e) {
            Log.e(getString(R.string.tag), "ERROR: " + e.getMessage());
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId()) {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    finish();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }

}
