package com.tomas.ht_mast;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Handler;
import android.text.InputType;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Switch;
import android.widget.TextView;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.tomas.ht_mast.lib.AlertProgress;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.Scaner_Pokayoke;
import com.tomas.ht_mast.lib.SettingsHelper;
import com.tomas.ht_mast.lib.db.DBHelper;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class Pokayoke3Points_Activity extends Scaner_Pokayoke implements View.OnClickListener {
    TextView txt_user, txt_device, txt_date,txt_result;

    EditText txt_partno1,txt_partno2,txt_partno3;
    DecimalFormat decimalFormat;
    AlertProgress alert;

    Switch sw;


    String pubpartno1="",pubpartno2="",pubpartno3="", pubtypescan1="",pubtypescan2="",pubtypescan3="";

    Integer icount_scan=0;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activeity_pokayoke_3points);



        decimalFormat = new DecimalFormat("##0.00");

        alert = new AlertProgress(Pokayoke3Points_Activity.this);

        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        String  date = df.format(calendar.getTime());


        sw = (Switch) findViewById(R.id.simpleSwitch);

        txt_date = (TextView) findViewById(R.id.txt_date);
        txt_date.setText(date);


        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ SettingsHelper.username);

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Position : "+ SettingsHelper.position);


        txt_result = (TextView) findViewById(R.id.txt_result);
        txt_result.setText("");
        txt_result.setBackgroundColor(Color.GRAY);


        txt_partno1 = (EditText) findViewById(R.id.txt_partno1);
        txt_partno1.setInputType(InputType.TYPE_NULL); // disable soft input
        txt_partno1.setOnKeyListener(new View.OnKeyListener() {
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                // If the event is a key-down event on the "enter" button
                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
                        (keyCode == KeyEvent.KEYCODE_ENTER)) {

                    return true;
                }
                return false;
            }
        });


        txt_partno2 = (EditText) findViewById(R.id.txt_partno2);
        txt_partno2.setInputType(InputType.TYPE_NULL); // disable soft input
        txt_partno2.setOnKeyListener(new View.OnKeyListener() {
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                // If the event is a key-down event on the "enter" button
                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
                        (keyCode == KeyEvent.KEYCODE_ENTER)) {

                    return true;
                }
                return false;
            }
        });
        txt_partno3 = (EditText) findViewById(R.id.txt_partno3);
        txt_partno3.setInputType(InputType.TYPE_NULL); // disable soft input
        txt_partno3.setOnKeyListener(new View.OnKeyListener() {
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                // If the event is a key-down event on the "enter" button
                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
                        (keyCode == KeyEvent.KEYCODE_ENTER)) {





                    return true;
                }
                return false;
            }
        });

    }
    @SuppressLint("Range")
    public void fc_checkmatching(String partno)
    {

        String partnofilter="";
        String scantypefilter ="";
        if(partno.equals("1"))
        {
            partnofilter = txt_partno1.getText().toString();
            if(pubtypescan1.trim().equals("OCR"))
            {
                scantypefilter="1";

            }
            else
            {
                scantypefilter="2";
            }
        }
        else if (partno.equals("2"))
        {
            partnofilter = txt_partno2.getText().toString();
            if(pubtypescan2.trim().equals("OCR"))
            {
                scantypefilter="1";

            }
            else
            {
                scantypefilter="2";
            }

        }
        else if (partno.equals("3"))
        {
            partnofilter = txt_partno3.getText().toString();
            if(pubtypescan3.trim().equals("OCR"))
            {
                scantypefilter="1";

            }
            else
            {
                scantypefilter="2";
            }

        }
        try {

            SQLiteDatabase db = DBHelper.getDB();
            db.isOpen();



            String str_findpartno = "select scan_code"+partno+",digit_from"+partno+",digit_to"+partno+" from mst_part where type=3 and scan_type"+partno+"="+scantypefilter+" and scan_code"+partno+" like '%"+partnofilter+"%'";



            Cursor resx = db.rawQuery(str_findpartno, null);
            resx.moveToFirst();
            while (resx.isAfterLast() == false) {

                try {

                    if(partno.equals("1")) {
                        String digitfrom = resx.getString(resx.getColumnIndex("digit_from1"));
                        String digitto = resx.getString(resx.getColumnIndex("digit_to1"));
                        String str_partno = resx.getString(resx.getColumnIndex("scan_code1"));


                        try {
                            str_partno = str_partno.substring(0, Integer.valueOf(digitto));
                            str_partno = str_partno.substring(Integer.valueOf(digitfrom) - 1, str_partno.length());
                        } catch (Exception err) {

                            err.printStackTrace();

                        }


                        pubpartno1 = resx.getString(resx.getColumnIndex("scan_code1"));
                        break;


                    }
                    else if (partno.equals("2")) {
                        String digitfrom = resx.getString(resx.getColumnIndex("digit_from2"));
                        String digitto = resx.getString(resx.getColumnIndex("digit_to2"));
                        String str_partno = resx.getString(resx.getColumnIndex("scan_code2"));


                        try {
                            str_partno = str_partno.substring(0, Integer.valueOf(digitto));
                            str_partno = str_partno.substring(Integer.valueOf(digitfrom) - 1, str_partno.length());
                        } catch (Exception err) {

                            err.printStackTrace();

                        }


                        pubpartno2 = resx.getString(resx.getColumnIndex("scan_code2"));
                        break;


                    }
                    else if (partno.equals("3")) {


                        String digitfrom = resx.getString(resx.getColumnIndex("digit_from3"));
                        String digitto = resx.getString(resx.getColumnIndex("digit_to3"));
                        String str_partno = resx.getString(resx.getColumnIndex("scan_code3"));


                        try {
                            str_partno = str_partno.substring(0, Integer.valueOf(digitto));
                            str_partno = str_partno.substring(Integer.valueOf(digitfrom) - 1, str_partno.length());
                        } catch (Exception err) {

                            err.printStackTrace();

                        }


                        pubpartno3 = resx.getString(resx.getColumnIndex("scan_code3"));
                        break;


                    }



                    resx.moveToNext();
                } catch (Exception e) {

                    e.printStackTrace();

                }
            }
            db.close();




        } catch (Exception e) {
            e.printStackTrace();

        }



    }

    public void fc_result()
    {
        if(txt_partno1.getText().toString().trim().equals("") || txt_partno2.getText().toString().trim().equals("")
                || txt_partno3.getText().toString().trim().equals("")) {

            new SweetAlertDialog(Pokayoke3Points_Activity.this, SweetAlertDialog.WARNING_TYPE)
                    .setTitleText("WARNING")
                    .setContentText("Invalid 3 Points!")
                    .show();

        }
        else {
            fc_checkmatching("1");
            fc_checkmatching("2");
            fc_checkmatching("3");


            if (!pubpartno1.equals("") && !pubpartno2.equals("") && !pubpartno3.equals("")) {
                txt_result.setText("OK");
                txt_result.setBackgroundColor(Color.GREEN);

                fc_saveresult();

                final Handler handler = new Handler();
                handler.postDelayed(new Runnable() {
                    @Override
                    public void run() {

                        clear();


                    }
                }, 1500);


            } else {
                txt_result.setText("NG");
                txt_result.setBackgroundColor(Color.RED);
                fc_saveresult();
                pubpartno1 = "";
                pubpartno2 = "";
                pubpartno3 = "";
                pubtypescan1 = "";
                pubtypescan2 = "";
                pubtypescan3 = "";
                icount_scan = 0;

            }


        }

    }


    @SuppressLint("Range")
    public void fc_saveresult()
    {

        try {



            String userid = SettingsHelper.userid;
            String result = txt_result.getText().toString();

            String partno1 = txt_partno1.getText().toString().trim();
            String partno2 = txt_partno2.getText().toString().trim();
            String partno3 = txt_partno3.getText().toString().trim();



            Calendar calendar = Calendar.getInstance();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String  date = df.format(calendar.getTime());

            SimpleDateFormat dt = new SimpleDateFormat("HH:mm");
            String  time = dt.format(calendar.getTime());






            String id="";

            try {
                SQLiteDatabase db = DBHelper.getDB();
                db.isOpen();
                Cursor resx = db.rawQuery("select tranid as id from log_transaction order by CAST(tranid as real) desc", null);
                resx.moveToFirst();
                while (resx.isAfterLast() == false) {

                    try {

                        id = resx.getString(resx.getColumnIndex("id"));
                        resx.moveToNext();
                        break;
                    } catch (Exception e) {

                        e.printStackTrace();

                    }
                }

                db.close();
            }catch(Exception e) {

                e.printStackTrace();

            }


            if(id.equals(""))
            {
                id = "1";

            }
            else
            {
                id = String.valueOf(Integer.valueOf(id) + 1);

            }

            SQLiteDatabase db_inst = DBHelper.getDB();
            db_inst.isOpen();
            String str_inst = "insert into log_transaction (tranid,scan_date,scan_time,scan_code1,scan_code2,scan_code3,userid,scan_status,type,scan_type_code1,scan_type_code2,scan_type_code3) values ('"+ id +"','"+date+"','"+time+"','"+partno1+"','"+partno2+"','"+partno3+"','"+userid+"','"+result+"','3','"+pubtypescan1+"','"+pubtypescan2+"','"+pubtypescan3+"')";
            db_inst.execSQL(str_inst);
            db_inst.close();


        } catch (Exception e) {
            e.printStackTrace();

        }


    }
    private  void clear()
    {

        txt_partno1.setText("");
        txt_partno2.setText("");
        txt_partno3.setText("");
        txt_result.setText("");
        txt_result.setBackgroundColor(Color.GRAY);
        pubpartno1="";
        pubpartno2="";
        pubpartno3="";
        pubtypescan1="";
        pubtypescan2="";
        pubtypescan3="";
        icount_scan=0;


    }

    @Override
    protected void onStart() {
        super.onStart();

    }


    public void processData(String data, DecodeResult.Result result, String codeType) {

        try {


                    if(result.toString().trim().equals("SUCCESS")) {

                         switch (icount_scan) {
                             case 0 :
                             {

                                 final Handler handler = new Handler();
                                 handler.postDelayed(new Runnable() {
                                     @Override
                                     public void run() {

                                             txt_partno1.setText(data);
                                             txt_partno2.setText("");
                                             txt_partno3.setText("");
                                             pubtypescan1 = codeType;
                                             icount_scan = 1;

                                     }
                                 },300);

                                 break;
                             }
                             case 1 :
                             {
                                 final Handler handler = new Handler();
                                 handler.postDelayed(new Runnable() {
                                     @Override
                                     public void run() {

                                             txt_partno2.setText(data);
                                             txt_partno3.setText("");
                                             pubtypescan2 = codeType;
                                             icount_scan = 2;

                                     }
                                 },300);


                                 break;
                             }
                             case 2 :
                             {
                                 final Handler handler = new Handler();
                                 handler.postDelayed(new Runnable() {
                                     @Override
                                     public void run() {

                                             txt_partno3.setText(data);
                                             pubtypescan3 = codeType;

                                             if (sw.isChecked()) {
                                                 fc_result();
                                             }

                                     }
                                 },300);

                                 break;
                             }

                         }

                    }
                    if (data.trim().equals(""))
                        return;





        } catch (Exception e) {
            Log.e(getString(R.string.tag), "ERROR: " + e.getMessage());
        }


    }

    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.imb_back:
                intent = new Intent(this, MainMenu_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_confirm:

                fc_result();


                break;

            case R.id.btn_clear:


               clear();


                break;



            case R.id.btn_main:
                intent = new Intent(this, MainMenu_Activity.class);
                startActivity(intent);
                break;
        }
    }


    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {

        if (keyCode >= KeyMapping.P2.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    Intent intent = new Intent(this, MainMenu_Activity.class);
                    startActivity(intent);
                    break;
                case P2:
                    clear();
                    break;
                case ENT:
                    fc_result();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void onBackPressed() {
        finishAffinity();
        System.exit(0);
    }
}