package com.tomas.ht_mast;

import static com.tomas.ht_mast.lib.KeyMapping.P1;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

import com.tomas.ht_mast.ListData.Factory_list;
import com.tomas.ht_mast.ListData.ItemMaster_list;
import com.tomas.ht_mast.ListData.Location_list;
import com.tomas.ht_mast.ListData.PackingStandard_list;
import com.tomas.ht_mast.ListData.Supplier_list;
import com.tomas.ht_mast.lib.AlertProgress;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.Settings;
import com.tomas.ht_mast.lib.SettingsHelper;
import com.tomas.ht_mast.lib.common.AsyncHttpClient;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class MainMenu_Activity extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device;
    DecimalFormat decimalFormat;
    AlertProgress alert;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        decimalFormat = new DecimalFormat("##0.00");

        alert = new AlertProgress(MainMenu_Activity.this);


        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ SettingsHelper.username);

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Position : "+ SettingsHelper.position);


    }


    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.btn_pk2point:
                intent = new Intent(MainMenu_Activity.this, Pokayoke2Points_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_pk3point:
                intent = new Intent(MainMenu_Activity.this, Pokayoke3Points_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_work_history:
                intent = new Intent(MainMenu_Activity.this, Workhistory_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_data_sync:
                intent = new Intent(MainMenu_Activity.this, SubMenu_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_close:
                finishAffinity();
                System.exit(0);
                break;
        }
    }


    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    finishAffinity();
                    System.exit(0);
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void onBackPressed() {
        finishAffinity();
        System.exit(0);
    }
}