package com.tomas.ht_mast;

import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.tomas.ht_mast.lib.Scanner;
import com.tomas.ht_mast.lib.Settings;
import com.tomas.ht_mast.lib.SettingsHelper;
import com.tomas.ht_mast.lib.User;
import com.tomas.ht_mast.lib.common.AsyncHttpClient;
import com.tomas.ht_mast.lib.common.Utils;
import com.tomas.ht_mast.lib.db.CreateDB;
import com.tomas.ht_mast.lib.db.DBHelper;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileWriter;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class Login_Activity extends Scanner implements View.OnClickListener  {

    EditText edt_password, edt_userid;
    Button btn_login;
    String Username, Password;
    User users;

    ProgressDialog progressDialog;
    private TextView lbl_main_title;
    //    private SpinAdapter usrListArrayAdapter;
    private static int title_click = 0;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login);


        edt_userid = (EditText) findViewById(R.id.edt_userid);
        edt_password = (EditText) findViewById(R.id.edt_password);
        btn_login = (Button) findViewById(R.id.btn_login);
        lbl_main_title = (TextView) findViewById(R.id.lbl_main_title);
//        list_item = new ArrayList<User>();

        // read settings from Internal storage
        Settings.init(Login_Activity.this);

        try{
            SQLiteDatabase db = DBHelper.getDB();
            db.isOpen();
        }
        catch (Exception e)
        {

            try {


                File fileread = new File(this.getFilesDir()
                        , "HT_ALT");
                FileWriter writer = new FileWriter(fileread, false); //True = Append to file, false = Overwrite
                writer.close();
                SQLiteDatabase db = DBHelper.getDB();
                db.isOpen();


                String[] strcmd = CreateDB.createdb().split("\\);");
                for (String str : strcmd)
                {
                    if(!str.equals(""))
                    {


                        db.execSQL(str+");");



                    }



                }
                db.close();



            } catch (Exception err) {
                err.printStackTrace();
            }

            Handler handle = new Handler() {
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    progressDialog.incrementProgressBy(1); // Incremented By Value 2
                }
            };
            progressDialog = new ProgressDialog(Login_Activity.this);
            progressDialog.setMax(100); // Progress Dialog Max Value
            progressDialog.setMessage("Please wait..."); // Setting Message
            progressDialog.setTitle("Create database"); // Setting Title
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL); // Progress Dialog Style Horizontal
            progressDialog.show(); // Display Progress Dialog
            progressDialog.setCancelable(false);
            new Thread(new Runnable() {
                @Override
                public void run() {
                    try {


                        while (progressDialog.getProgress() <= progressDialog.getMax()) {
                            Thread.sleep(100);
                            handle.sendMessage(handle.obtainMessage());
                            if (progressDialog.getProgress() == progressDialog.getMax()) {
                                progressDialog.dismiss();



                                break;
                            }
                        }

                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();


        }


    }


    @Override
    public void processData(String data, DecodeResult.Result result, String codeType) {
        try {

            Log.d(getString(R.string.tag), "data read:" + data);

            edt_userid.setText(data.trim());


//             always hide keyboard after scan
            Utils.hideKeyboardFrom(getApplicationContext(), default_view);

        } catch (Exception e) {
            Log.e(getString(R.string.tag), "ERROR: " + e.getMessage());
        }
    }

    @SuppressLint("Range")
    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.btn_login:
                btn_login.setEnabled(false);
                btn_login.setEnabled(false);

                Username = edt_userid.getText().toString().trim();
                Password = edt_password.getText().toString().trim();

                String uid="";
                String upass="";
                String firstname="";
                String lastname="";
                String position="";

                try {

                    SQLiteDatabase db = DBHelper.getDB();
                    db.isOpen();
                    Cursor resx = db.rawQuery("select username,password,firstname,lastname,position from mst_users where username='"+Username+"' and password='"+Password+"' ", null);
                    resx.moveToFirst();
                    while (resx.isAfterLast() == false) {

                        try {

                            uid = resx.getString(resx.getColumnIndex("username"));
                            upass = resx.getString(resx.getColumnIndex("password"));
                            firstname = resx.getString(resx.getColumnIndex("firstname"));
                            lastname = resx.getString(resx.getColumnIndex("lastname"));
                            position = resx.getString(resx.getColumnIndex("position"));

                            SettingsHelper.username = firstname+"  "+lastname;
                            SettingsHelper.position = position;
                            SettingsHelper.userid = uid;

                            resx.moveToNext();
                        } catch (Exception e) {

                            e.printStackTrace();

                        }
                    }
                    db.close();




                } catch (Exception e) {
                    e.printStackTrace();
                    new SweetAlertDialog(Login_Activity.this, SweetAlertDialog.WARNING_TYPE)
                            .setTitleText("WARNING")
                            .setContentText(e.getMessage())
                            .show();
                }
                btn_login.setBackgroundResource(R.drawable.button_background_gray);


                if (Username.trim().equals("")||Password.trim().equals("")){
                    btn_login.setEnabled(true);
                    btn_login.setBackgroundResource(R.drawable.button_background_blue);
                    new SweetAlertDialog(Login_Activity.this, SweetAlertDialog.WARNING_TYPE)
                            .setTitleText("WARNING")
                            .setContentText("Please complete the information")
                            .show();
                }
                else
                {
                    if(!uid.equals("") && ! upass.equals(""))
                    {

                        Intent intent =new Intent(Login_Activity.this, MainMenu_Activity.class);
                        startActivity(intent);

                    }
                    else
                    {
                        btn_login.setEnabled(true);
                        btn_login.setBackgroundResource(R.drawable.button_background_blue);
                        new SweetAlertDialog(Login_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText("Your password is incorrect.")
                                .show();
                    }
                }
                break;


            case R.id.lbl_main_title:
                if (++title_click == 7) {
                    title_click = 0;
                    Toast.makeText(getApplicationContext(), "Settings mode!", Toast.LENGTH_LONG).show();

                    // call Settings activity
                    Log.d(getString(R.string.tag), "start settings activity");
                    Intent intent =new Intent(Login_Activity.this, Setting_Activity.class);
                    startActivity(intent);

                }
        }

    }



    @Override
    public void onBackPressed() {
        finishAffinity();
        System.exit(0);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }
}