package com.tomas.ht_mast;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.format.Formatter;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import com.tomas.ht_mast.lib.AlertProgress;
import com.tomas.ht_mast.lib.Helpper;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.SettingsHelper;
import com.tomas.ht_mast.lib.db.DBHelper;

import java.io.BufferedReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class Import_user_Activity extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device,txt_port,txt_ipaddress,txt_pcport,txt_pcipaddress;

    DatagramSocket clientsocket;

    DecimalFormat decimalFormat;
    AlertProgress alert;

    Integer icount=0,total_import_part=0,total_import_user=0;

    String recivedata;

    ArrayList<String> arrdata_import = new ArrayList<String>();
    ArrayList<String> arrdata_import_user = new ArrayList<String>();

    ProgressDialog progressDialog;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activeity_import_user);


        if (ContextCompat.checkSelfPermission(this, android.Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {

            ActivityCompat.requestPermissions(this, new String[]{android.Manifest.permission.CAMERA, android.Manifest.permission.WRITE_EXTERNAL_STORAGE}, 0);


        }


        int permission = ActivityCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE);


        decimalFormat = new DecimalFormat("##0.00");

        alert = new AlertProgress(Import_user_Activity.this);


        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : " + SettingsHelper.username);

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Position : " + SettingsHelper.position);


        txt_port = (TextView) findViewById(R.id.txt_port);
        txt_port.setText("8080");


        txt_pcipaddress = (TextView) findViewById(R.id.txt_pcipaddress);
        txt_pcport = (TextView) findViewById(R.id.txt_pcport);


        try
        {
            WifiManager wm = (WifiManager) this.getSystemService(Context.WIFI_SERVICE);
            String ippc = null;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.CUPCAKE) {
                ippc = Formatter.formatIpAddress(wm.getConnectionInfo().getIpAddress());
            }

            txt_ipaddress = (TextView) findViewById(R.id.txt_ipaddress);
            txt_ipaddress.setText(ippc);
        }catch (Exception err) {

            new SweetAlertDialog(Import_user_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(err.getMessage())
                    .show();
        }



        Import_Data(Integer.valueOf(txt_port.getText().toString().trim()));







        Button btn_menu = (Button) findViewById(R.id.btn_mainmenu);
        btn_menu.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clientsocket.close();
                Intent intent = new Intent(Import_user_Activity.this, SubMenu_Activity.class);
                startActivity(intent);
            }
        });


        Button btn_importuser = (Button) findViewById(R.id.btn_importuser);
        btn_importuser.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                Handler handle = new Handler() {
                    public void handleMessage(Message msg) {
                        super.handleMessage(msg);
                        progressDialog.incrementProgressBy(1); // Incremented By Value 2
                    }
                };


                if(txt_pcipaddress.getText().toString().trim().equals(""))
                {
                    new SweetAlertDialog(Import_user_Activity.this, SweetAlertDialog.ERROR_TYPE)
                            .setTitleText("ERROR")
                            .setContentText("Device is not connect to PC.")
                            .show();

                }
                else if (arrdata_import_user.size()==0) {

                    new SweetAlertDialog(Import_user_Activity.this, SweetAlertDialog.ERROR_TYPE)
                            .setTitleText("ERROR")
                            .setContentText("Data not found from PC.")
                            .show();
                }
                else
                {

                    if(arrdata_import_user.size()>0)
                    {

                        icount = arrdata_import_user.size() * 60;

                    }

                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {

                                if(arrdata_import_user.size()>0) {

                                    insertdata_master_user();

                                }



                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();

                    progressDialog = new ProgressDialog(Import_user_Activity.this);
                    progressDialog.setMax(100); // Progress Dialog Max Value
                    progressDialog.setMessage("Import..."); // Setting Message
                    progressDialog.setTitle("Import CSV File"); // Setting Title
                    progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL); // Progress Dialog Style Horizontal
                    progressDialog.show(); // Display Progress Dialog
                    progressDialog.setCancelable(false);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {


                                while (progressDialog.getProgress() <= progressDialog.getMax()) {
                                    Thread.sleep(icount);
                                    handle.sendMessage(handle.obtainMessage());
                                    if (progressDialog.getProgress() == progressDialog.getMax()) {
                                        progressDialog.dismiss();
                                        if(arrdata_import_user.size()>0) {

                                            SendData(1,"user|"+ total_import_user.toString(),Integer.valueOf(txt_port.getText().toString().trim()),txt_pcipaddress.getText().toString().trim());
                                            arrdata_import_user.clear();
                                            total_import_user=0;


                                        }

                                        break;
                                    }
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            }
        });


    }


    @SuppressLint("Range")
    private  void insertdata_master_user()
    {

        total_import_user=0;
        if(arrdata_import_user.size()>0)
        {

            try {
                for(String list_row : arrdata_import_user) {
                    String[] arr_item = list_row.split("#");

                    for (String list_item : arr_item) {
                        if (list_item.contains("|")) {
                            String[] arr = list_item.split("\\|");

                            String username = arr[1];
                            String password = arr[2];
                            String firstname = arr[3];
                            String lastname = arr[4];
                            String position = arr[5];

                            String xCode = arr[6];
                            String chksumcode = list_item.replace("|" + xCode, "").replace("|*user","");
                            byte[] bytes = chksumcode.getBytes(StandardCharsets.US_ASCII);
                            String codex = crc16Ccitt(bytes).toUpperCase();

                            if (codex.length() < 4) {
                                codex = "0" + codex;


                            }

                            if (codex.equals(xCode)) {
                                String id = "";

                                try {
                                    SQLiteDatabase db = DBHelper.getDB();
                                    db.isOpen();
                                    String str_del = "Delete from mst_users where username='"+username+"'";
                                    db.execSQL(str_del);

                                    Cursor resx = db.rawQuery("select userid as id from mst_users order by userid desc", null);
                                    resx.moveToFirst();
                                    while (resx.isAfterLast() == false) {

                                        try {

                                            id = resx.getString(resx.getColumnIndex("id"));
                                            resx.moveToNext();
                                            break;
                                        } catch (Exception e) {

                                            e.printStackTrace();

                                        }
                                    }

                                    db.close();
                                } catch (Exception e) {

                                    e.printStackTrace();

                                }


                                if (id.equals("")) {
                                    id = "1";

                                } else {
                                    id = String.valueOf(Integer.valueOf(id) + 1);

                                }

                                SQLiteDatabase db_inst = DBHelper.getDB();
                                db_inst.isOpen();



                                String str_inst = "INSERT INTO mst_users (" +
                                        "userid," +
                                        "username," +
                                        "password," +
                                        "firstname," +
                                        "lastname," +
                                        "position" +
                                        ")" +
                                        "VALUES (" +
                                        "'" + id + "'," +
                                        "'" + username + "'," +
                                        "'" + password + "'," +
                                        "'" + firstname + "'," +
                                        "'" + lastname + "'," +
                                        "'" + position + "');";
                                db_inst.execSQL(str_inst);
                                db_inst.close();
                                total_import_user++;
                            }

                        } else {
                            break;

                        }
                    }



                }

            } catch (Exception e) {
                new SweetAlertDialog(Import_user_Activity.this, SweetAlertDialog.WARNING_TYPE)
                        .setTitleText("WARNING")
                        .setContentText(e.getMessage())
                        .show();
            }


        }


    }
    private  void Import_Data(Integer portNum)
    {


        new Thread(() -> {
            try {

                clientsocket = new DatagramSocket(portNum);
                byte[] receivedata = new byte[1024*1024];
                while (true) {
                    DatagramPacket recv_packet = new DatagramPacket(receivedata, receivedata.length);
                    clientsocket.receive(recv_packet);
                    String rec_str = new String(recv_packet.getData());
                    InetAddress ipaddress = recv_packet.getAddress();
                    int port = recv_packet.getPort();
                    if(rec_str.length()>0) {

                        if(rec_str.contains("connect"))
                        {
                            Helpper.getInstance().setIPHost(ipaddress.toString().replace("/",""));
                            Helpper.getInstance().setIPClient(String.valueOf(port));
                            txt_pcipaddress.setText(ipaddress.toString().replace("/",""));
                            txt_pcport.setText(String.valueOf(port));

                        }
                        else if(rec_str.contains("|*part"))
                        {

                            arrdata_import.add(rec_str);
                            arrdata_import_user.clear();

                        }
                        else if(rec_str.contains("|*user"))
                        {

                            arrdata_import_user.add(rec_str);
                            arrdata_import.clear();

                        }


                        //byte[] decodeValue = Base64.decode(rec_str, Base64.DEFAULT);
                        //String filename = "master_file.txt";
                        //File file = new File(getFilesDir(), filename);
                        //FileWriter writer = new FileWriter(file, true); //True = Append to file, false = Overwrite
                        //writer.write(arr[0]);
                        //writer.close();


                    }







                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }).start();


    }

    public static String crc16Ccitt(byte[] bytes) {


        int crc = 0xFFFF;
        int polynomial = 0x1021;
        for (byte b : bytes) {
            for (int i = 0; i < 8; i++) {
                boolean bit = ((b >> (7-i) & 1) == 1);
                boolean c15 = ((crc >> 15 & 1) == 1);
                crc <<= 1;
                if (c15 ^ bit) crc ^= polynomial;
            }
        }
        crc &= 0xffff;



        return Integer.toHexString(crc);
    }
    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.imb_back:
                clientsocket.close();
                intent = new Intent(this, SubMenu_Activity.class);
                startActivity(intent);
                break;


        }
    }

    @Override
    protected void onStart() {
        super.onStart();

    }



    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    clientsocket.close();
                    Intent intent = new Intent(this, SubMenu_Activity.class);
                    startActivity(intent);
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void onBackPressed() {
        finishAffinity();
        System.exit(0);
    }



    private DatagramSocket UDPSocket;
    private InetAddress address;
    private int port;

    /// Initialise une socket avec les parametres recupere dans l'interface graphique pour l'envoi des données
    public void Initreseau(InetAddress address) {
        try {
            this.UDPSocket = new DatagramSocket();
            this.address = address;
        } catch (SocketException e) {
            e.printStackTrace();
        }
    }

    /// Envoi les données dans la socket defini par la methode InitReseau
    public void SendInstruction(final byte[] data, final int port) {
        new Thread() {
            @Override
            public void run() {
                try {

                    DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
                    UDPSocket.send(packet);

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }.start();
    }
    private Socket socket;
    private BufferedReader input;
    /// Envoi X fois la data
    public void SendData(final int nbRepet, final String Sdata , final int port, final String address) {
        new Thread() {
            @Override
            public void run() {
                try {
                    try {
                        Initreseau(InetAddress.getByName(address));
                        for (int i = 0; i < nbRepet; i++) {
                            byte[] data = Sdata.getBytes();
                            SendInstruction(data,port);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } catch (Exception e) {
                    //e.printStackTrace();
                }
            }
        }.start();

    }




}
