package com.tomas.ht_mast;

import static android.app.PendingIntent.getActivity;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.format.Formatter;
import android.util.Base64;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_mast.Adapter.Workhistory_Adapter;
import com.tomas.ht_mast.ListData.Workhistory_Item;
import com.tomas.ht_mast.lib.AlertProgress;
import com.tomas.ht_mast.lib.Helpper;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.SettingsHelper;
import com.tomas.ht_mast.lib.db.DBHelper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class Import_Activity extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device,txt_port,txt_ipaddress,txt_pcport,txt_pcipaddress;

    DatagramSocket clientsocket;

    DecimalFormat decimalFormat;
    AlertProgress alert;

    Integer icount=0,total_import_part=0,total_import_user=0;

    String recivedata;

    ArrayList<String> arrdata_import = new ArrayList<String>();
    ArrayList<String> arrdata_import_user = new ArrayList<String>();

    ProgressDialog progressDialog;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activeity_import);


        if (ContextCompat.checkSelfPermission(this, android.Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {

            ActivityCompat.requestPermissions(this, new String[]{android.Manifest.permission.CAMERA, android.Manifest.permission.WRITE_EXTERNAL_STORAGE}, 0);


        }


        int permission = ActivityCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE);


        decimalFormat = new DecimalFormat("##0.00");

        alert = new AlertProgress(Import_Activity.this);


        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : " + SettingsHelper.username);

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Position : " + SettingsHelper.position);


        txt_port = (TextView) findViewById(R.id.txt_port);
        txt_port.setText("8080");


        txt_pcipaddress = (TextView) findViewById(R.id.txt_pcipaddress);
        txt_pcport = (TextView) findViewById(R.id.txt_pcport);


        try
        {
        WifiManager wm = (WifiManager) this.getSystemService(Context.WIFI_SERVICE);
        String ippc = null;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.CUPCAKE) {
            ippc = Formatter.formatIpAddress(wm.getConnectionInfo().getIpAddress());
        }

        txt_ipaddress = (TextView) findViewById(R.id.txt_ipaddress);
        txt_ipaddress.setText(ippc);
        }catch (Exception err) {

            new SweetAlertDialog(Import_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(err.getMessage())
                    .show();
        }



        Import_Data(Integer.valueOf(txt_port.getText().toString().trim()));







        Button btn_menu = (Button) findViewById(R.id.btn_mainmenu);
        btn_menu.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
         clientsocket.close();
         Intent intent = new Intent(Import_Activity.this, SubMenu_Activity.class);
         startActivity(intent);
         }
        });




        Button btn_export = (Button) findViewById(R.id.btn_importitem);
        btn_export.setOnClickListener(new View.OnClickListener() {

            Handler handle = new Handler() {
                public void handleMessage(Message msg) {
                    super.handleMessage(msg);
                    progressDialog.incrementProgressBy(1); // Incremented By Value 2
                }
            };

            @Override
            public void onClick(View v) {




                if(txt_pcipaddress.getText().toString().trim().equals(""))
                {
                    new SweetAlertDialog(Import_Activity.this, SweetAlertDialog.ERROR_TYPE)
                            .setTitleText("ERROR")
                            .setContentText("Device is not connect to PC.")
                            .show();

                }
                else if (arrdata_import.size()==0) {

                    new SweetAlertDialog(Import_Activity.this, SweetAlertDialog.ERROR_TYPE)
                            .setTitleText("ERROR")
                            .setContentText("Data not found from PC.")
                            .show();
                }
                else
                {

                    if(arrdata_import.size()>0) {
                        icount = arrdata_import.size() * 60;
                    }

                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {

                                if(arrdata_import.size()>0) {
                                    insertdata_master();
                                }




                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();

                    progressDialog = new ProgressDialog(Import_Activity.this);
                    progressDialog.setMax(100); // Progress Dialog Max Value
                    progressDialog.setMessage("Import..."); // Setting Message
                    progressDialog.setTitle("Import CSV File"); // Setting Title
                    progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL); // Progress Dialog Style Horizontal
                    progressDialog.show(); // Display Progress Dialog
                    progressDialog.setCancelable(false);
                    new Thread(new Runnable() {
                        @Override
                        public void run() {
                            try {


                                while (progressDialog.getProgress() <= progressDialog.getMax()) {
                                    Thread.sleep(icount);
                                    handle.sendMessage(handle.obtainMessage());
                                    if (progressDialog.getProgress() == progressDialog.getMax()) {
                                        progressDialog.dismiss();
                                        if(arrdata_import.size()>0) {
                                            SendData(1,"part|"+ total_import_part.toString(),Integer.valueOf(txt_port.getText().toString().trim()),txt_pcipaddress.getText().toString().trim());
                                            arrdata_import.clear();
                                            total_import_part=0;

                                        }


                                        break;
                                    }
                                }

                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }).start();
                }
            }
        });


    }

    @SuppressLint("Range")
    private  void insertdata_master()
    {

        total_import_part=0;
        if(arrdata_import.size()>0)
        {

            try {
                for(String list_row : arrdata_import) {
                    String[] arr_item = list_row.split("#");

                    for (String list_item : arr_item) {
                        if (list_item.contains("|")) {
                            String[] arr = list_item.split("\\|");

                            String point = arr[1];
                            String partno1 = arr[2];
                            String type1 = arr[3];
                            String dgt_from1 = arr[4];
                            String dgt_to1 = arr[5];
                            String partno2 = arr[6];
                            String type2 = arr[7];
                            String dgt_from2 = arr[8];
                            String dgt_to2 = arr[9];
                            String partno3 = arr[10];
                            String type3 = arr[11];
                            String dgt_from3 = arr[12];
                            String dgt_to3 = arr[13];
                            String xCode = arr[14];
                            String chksumcode = list_item.replace("|" + xCode, "").replace("|*part","");
                            byte[] bytes = chksumcode.getBytes(StandardCharsets.US_ASCII);
                            String codex = crc16Ccitt(bytes).toUpperCase();

                            if (codex.length() < 4) {
                                codex = "0" + codex;


                            }
                            if (codex.equals(xCode)) {

                                if (type1.equals("")) {
                                    type1 = "NULL";
                                }
                                if (dgt_from1.equals("")) {
                                    dgt_from1 = "NULL";
                                }
                                if (dgt_to1.equals("")) {
                                    dgt_to1 = "NULL";
                                }

                                if (type2.equals("")) {
                                    type2 = "NULL";
                                }
                                if (dgt_from2.equals("")) {
                                    dgt_from2 = "NULL";
                                }
                                if (dgt_to2.equals("")) {
                                    dgt_to2 = "NULL";
                                }


                                if (type3.equals("")) {
                                    type3 = "NULL";
                                }
                                if (dgt_from3.equals("")) {
                                    dgt_from3 = "NULL";
                                }
                                if (dgt_to3.equals("")) {
                                    dgt_to3 = "NULL";
                                }


                                String id = "";

                                try {
                                    SQLiteDatabase db = DBHelper.getDB();
                                    db.isOpen();

                                    String str_del = "Delete from mst_part where scan_code1='"+partno1+"' and scan_code2='"+partno2+"' and scan_code3='"+partno3+"' and scan_type1="+type1+" and scan_type2="+type2+" and scan_type3="+type3;
                                    db.execSQL(str_del);

                                    Cursor resx = db.rawQuery("select id from mst_part order by id desc", null);
                                    resx.moveToFirst();
                                    while (resx.isAfterLast() == false) {

                                        try {

                                            id = resx.getString(resx.getColumnIndex("id"));
                                            resx.moveToNext();
                                            break;
                                        } catch (Exception e) {

                                            e.printStackTrace();

                                        }
                                    }

                                    db.close();
                                } catch (Exception e) {

                                    e.printStackTrace();

                                }


                                if (id.equals("")) {
                                    id = "1";

                                } else {
                                    id = String.valueOf(Integer.valueOf(id) + 1);

                                }

                                SQLiteDatabase db_inst = DBHelper.getDB();
                                db_inst.isOpen();


                                String str_inst = "INSERT INTO mst_part (" +
                                        "id," +
                                        "type," +
                                        "scan_code1," +
                                        "scan_type1," +
                                        "digit_from1," +
                                        "digit_to1," +
                                        "scan_code2," +
                                        "scan_type2," +
                                        "digit_from2," +
                                        "digit_to2," +
                                        "scan_code3," +
                                        "scan_type3," +
                                        "digit_from3," +
                                        "digit_to3" +
                                        ")" +
                                        "VALUES (" +
                                        "'" + id + "'," +
                                        "" + point + "," +
                                        "'" + partno1 + "'," +
                                        "" + type1 + "," +
                                        "" + dgt_from1 + "," +
                                        "" + dgt_to1 + "," +
                                        "'" + partno2 + "'," +
                                        "" + type2 + "," +
                                        "" + dgt_from2 + "," +
                                        "" + dgt_to2 + "," +
                                        "'" + partno3 + "'," +
                                        "" + type3 + "," +
                                        "" + dgt_from3 + "," +
                                        "" + dgt_to3 + ");";
                                db_inst.execSQL(str_inst);
                                db_inst.close();
                                total_import_part++;

                            }

                        } else {
                            break;


                        }

                    }



                }

            } catch (Exception e) {
                new SweetAlertDialog(Import_Activity.this, SweetAlertDialog.WARNING_TYPE)
                        .setTitleText("WARNING")
                        .setContentText(e.getMessage())
                        .show();
            }


        }


    }


    private  void Import_Data(Integer portNum)
    {


        new Thread(() -> {
            try {

                clientsocket = new DatagramSocket(portNum);
                byte[] receivedata = new byte[1024*1024];
                while (true) {
                    DatagramPacket recv_packet = new DatagramPacket(receivedata, receivedata.length);
                    clientsocket.receive(recv_packet);
                    String rec_str = new String(recv_packet.getData());
                    InetAddress ipaddress = recv_packet.getAddress();
                    int port = recv_packet.getPort();
                    if(rec_str.length()>0) {

                        if(rec_str.contains("connect"))
                        {
                            Helpper.getInstance().setIPHost(ipaddress.toString().replace("/",""));
                            Helpper.getInstance().setIPClient(String.valueOf(port));
                            txt_pcipaddress.setText(ipaddress.toString().replace("/",""));
                            txt_pcport.setText(String.valueOf(port));

                        }
                        else if(rec_str.contains("|*part"))
                        {

                            arrdata_import.add(rec_str);
                            arrdata_import_user.clear();

                        }
                        else if(rec_str.contains("|*user"))
                        {

                            arrdata_import_user.add(rec_str);
                            arrdata_import.clear();

                        }


                        //byte[] decodeValue = Base64.decode(rec_str, Base64.DEFAULT);
                        //String filename = "master_file.txt";
                        //File file = new File(getFilesDir(), filename);
                        //FileWriter writer = new FileWriter(file, true); //True = Append to file, false = Overwrite
                        //writer.write(arr[0]);
                        //writer.close();


                    }







                }
            } catch (Exception e) {
               e.printStackTrace();
            }
        }).start();


    }

    public static String crc16Ccitt(byte[] bytes) {


        int crc = 0xFFFF;
        int polynomial = 0x1021;
        for (byte b : bytes) {
            for (int i = 0; i < 8; i++) {
                boolean bit = ((b >> (7-i) & 1) == 1);
                boolean c15 = ((crc >> 15 & 1) == 1);
                crc <<= 1;
                if (c15 ^ bit) crc ^= polynomial;
            }
        }
        crc &= 0xffff;



        return Integer.toHexString(crc);
    }
    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.imb_back:
                clientsocket.close();
                intent = new Intent(this, SubMenu_Activity.class);
                startActivity(intent);
                break;


        }
    }

    @Override
    protected void onStart() {
        super.onStart();

    }



    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    clientsocket.close();
                    Intent intent = new Intent(this, SubMenu_Activity.class);
                    startActivity(intent);
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void onBackPressed() {
        finishAffinity();
        System.exit(0);
    }



    private DatagramSocket UDPSocket;
    private InetAddress address;
    private int port;

    /// Initialise une socket avec les parametres recupere dans l'interface graphique pour l'envoi des données
    public void Initreseau(InetAddress address) {
        try {
            this.UDPSocket = new DatagramSocket();
            this.address = address;
        } catch (SocketException e) {
            e.printStackTrace();
        }
    }

    /// Envoi les données dans la socket defini par la methode InitReseau
    public void SendInstruction(final byte[] data, final int port) {
        new Thread() {
            @Override
            public void run() {
                try {

                    DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
                    UDPSocket.send(packet);

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }.start();
    }
    private Socket socket;
    private BufferedReader input;
    /// Envoi X fois la data
    public void SendData(final int nbRepet, final String Sdata , final int port, final String address) {
        new Thread() {
            @Override
            public void run() {
                try {
                    try {
                        Initreseau(InetAddress.getByName(address));
                        for (int i = 0; i < nbRepet; i++) {
                            byte[] data = Sdata.getBytes();
                            SendInstruction(data,port);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } catch (Exception e) {
                    //e.printStackTrace();
                }
            }
        }.start();

    }




}