package com.tomas.ht_mast;

import static java.util.Collections.list;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Color;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.InputType;
import android.text.format.Formatter;
import android.util.Base64;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.Switch;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.tomas.ht_mast.ListData.Workhistory_Item;
import com.tomas.ht_mast.lib.AlertProgress;
import com.tomas.ht_mast.lib.Helpper;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.SettingsHelper;
import com.tomas.ht_mast.lib.db.DBHelper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class Export_Activity extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device,txt_date,txt_dateto,txt_pcip,txt_pcport,txt_port,txt_ipaddress;

    DecimalFormat decimalFormat;
    AlertProgress alert;

    ArrayList<String> list = new ArrayList<String>();

    Integer icount=0,tmt_count_row=0,checkdata=0;

    ProgressDialog progressDialog;

    String str_date_from,str_date_to,datefilter="";


    CheckBox chk_all,chk_continue;
    DatagramSocket clientsocket;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activeity_export);


        if (ContextCompat.checkSelfPermission(this, android.Manifest.permission.WRITE_EXTERNAL_STORAGE) != PackageManager.PERMISSION_GRANTED) {

            ActivityCompat.requestPermissions(this, new String[]{android.Manifest.permission.CAMERA, android.Manifest.permission.WRITE_EXTERNAL_STORAGE}, 0);


        }


        int permission = ActivityCompat.checkSelfPermission(this, Manifest.permission.WRITE_EXTERNAL_STORAGE);


        decimalFormat = new DecimalFormat("##0.00");

        alert = new AlertProgress(Export_Activity.this);


        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : " + SettingsHelper.username);

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Position : " + SettingsHelper.position);


        txt_pcip = (TextView) findViewById(R.id.txt_pcipaddress);
        txt_pcport = (TextView) findViewById(R.id.txt_pcport);


        txt_port = (TextView) findViewById(R.id.txt_port);
        txt_port.setText("8080");

        try
        {
            WifiManager wm = (WifiManager) this.getSystemService(Context.WIFI_SERVICE);
            String ippc = null;
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.CUPCAKE) {
                ippc = Formatter.formatIpAddress(wm.getConnectionInfo().getIpAddress());
            }

            txt_ipaddress = (TextView) findViewById(R.id.txt_ipaddress);
            txt_ipaddress.setText(ippc);
        }catch (Exception err) {

            new SweetAlertDialog(Export_Activity.this, SweetAlertDialog.ERROR_TYPE)
                    .setTitleText("ERROR")
                    .setContentText(err.getMessage())
                    .show();
        }


        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String date = df.format(calendar.getTime());

        txt_date = (TextView) findViewById(R.id.txt_date);
        txt_date.setInputType(InputType.TYPE_NULL); // disable soft input
        txt_date.setText(date);
        txt_date.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                final Calendar currentDate = Calendar.getInstance();
                new DatePickerDialog(Export_Activity.this, new DatePickerDialog.OnDateSetListener() {
                    @Override
                    public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                        str_date_from = (year + "-" +
                                (String.format("%2s", monthOfYear + 1).replace(' ', '0')) + "-" +
                                (String.format("%2s", dayOfMonth).replace(' ', '0')));
                        txt_date.setText(str_date_from);
                        datefilter = " and scan_date between '" + str_date_from + " 00:00:00' and '" + str_date_from + " 23:59:59'";


                    }
                }, currentDate.get(Calendar.YEAR), currentDate.get(Calendar.MONTH), currentDate.get(Calendar.DATE)).show();
            }
        });


        txt_dateto = (TextView) findViewById(R.id.txt_todate);
        txt_dateto.setInputType(InputType.TYPE_NULL); // disable soft input
        txt_dateto.setText(date);
        txt_dateto.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                final Calendar currentDate = Calendar.getInstance();
                new DatePickerDialog(Export_Activity.this, new DatePickerDialog.OnDateSetListener() {
                    @Override
                    public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                        str_date_to = (year + "-" +
                                (String.format("%2s", monthOfYear + 1).replace(' ', '0')) + "-" +
                                (String.format("%2s", dayOfMonth).replace(' ', '0')));
                        txt_dateto.setText(str_date_to);
                        datefilter = " and scan_date between '" + str_date_from + " 00:00:00' and '" + str_date_to + " 23:59:59'";


                    }
                }, currentDate.get(Calendar.YEAR), currentDate.get(Calendar.MONTH), currentDate.get(Calendar.DATE)).show();
            }
        });


        chk_all = (CheckBox) findViewById(R.id.chk_all);
        chk_continue = (CheckBox) findViewById(R.id.chk_continue);


        Recive_Data(8080);


        Button btn_menu = (Button) findViewById(R.id.btn_mainmenu);
        btn_menu.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clientsocket.close();
                Intent intent = new Intent(Export_Activity.this, SubMenu_Activity.class);
                startActivity(intent);
            }
        });

        Button btn_export = (Button) findViewById(R.id.btn_export);
        btn_export.setOnClickListener(new View.OnClickListener() {


                Handler handle = new Handler() {
                    public void handleMessage(Message msg) {
                        super.handleMessage(msg);
                        progressDialog.incrementProgressBy(1); // Incremented By Value 2
                    }
                };

                @Override
                public void onClick (View v){


                    Check_Data();
                    Export_Data();;
                    if(txt_pcip.getText().toString().trim().equals(""))
                    {

                        new SweetAlertDialog(Export_Activity.this, SweetAlertDialog.ERROR_TYPE)
                                .setTitleText("ERROR")
                                .setContentText("Device is not connect to PC.")
                                .show();

                    }
                    else if (checkdata.equals(0))
                    {

                        new SweetAlertDialog(Export_Activity.this, SweetAlertDialog.WARNING_TYPE)
                                .setTitleText("WARNING")
                                .setContentText("Data not found.")
                                .show();

                    }
                    else {

                        progressDialog = new ProgressDialog(Export_Activity.this);
                        progressDialog.setMax(100); // Progress Dialog Max Value
                        progressDialog.setMessage("Export to IP "+txt_pcip.getText().toString().trim()+"..."); // Setting Message
                        progressDialog.setTitle("Export CSV File"); // Setting Title
                        progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL); // Progress Dialog Style Horizontal
                        progressDialog.show(); // Display Progress Dialog
                        progressDialog.setCancelable(false);
                        new Thread(new Runnable() {
                            @Override
                            public void run() {
                                try {


                                    //Export_Data();
                                    while (progressDialog.getProgress() <= progressDialog.getMax()) {
                                        Thread.sleep(icount);
                                        handle.sendMessage(handle.obtainMessage());
                                        if (progressDialog.getProgress() == progressDialog.getMax()) {
                                            progressDialog.dismiss();


                                            break;
                                        }
                                    }

                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }).start();
                    }

            }

        });


    }
    private  void Recive_Data(Integer portNum)
    {


        new Thread(() -> {
            try {

                clientsocket = new DatagramSocket(portNum);
                byte[] receivedata = new byte[1024*1024];
                while (true) {
                    DatagramPacket recv_packet = new DatagramPacket(receivedata, receivedata.length);
                    clientsocket.receive(recv_packet);
                    String rec_str = new String(recv_packet.getData());
                    InetAddress ipaddress = recv_packet.getAddress();
                    int port = recv_packet.getPort();
                    if(rec_str.length()>0) {

                        if(rec_str.contains("connect"))
                        {
                            Helpper.getInstance().setIPHost(ipaddress.toString().replace("/",""));
                            Helpper.getInstance().setIPClient(String.valueOf(port));
                            txt_pcip.setText(ipaddress.toString().replace("/",""));
                            txt_pcport.setText(String.valueOf(port));

                        }

                    }

                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }).start();


    }
    private  void Export_Data() {
        Integer icountround=0;
        Integer irow=0;
        String data_send="";

        String filter="";

        if(datefilter.equals(""))
        {
            datefilter = " and scan_date between '" + txt_date.getText().toString().trim() + " 00:00:00' and '" + txt_dateto.getText().toString().trim() + " 23:59:59'";


        }

        filter = datefilter;
        try {
            if(chk_continue.isChecked() && !chk_all.isChecked())
            {
                filter = " and export_status!='Y' ";

            }
            else if(chk_all.isChecked() && !chk_continue.isChecked()) {

                filter = "";

            }
        }catch(Exception e) {
            e.printStackTrace();
        }







        String str_work_history = "select tranid,scan_date,scan_time,scan_code1,scan_code2,scan_code3,userid,scan_status,type,scan_type_code1,scan_type_code2,scan_type_code3 from log_transaction Where 1=1 "+filter+"  order by CAST(tranid as real) ";
        //list.clear();
        SQLiteDatabase db = DBHelper.getDB();
        db.isOpen();
        Cursor resx = db.rawQuery(str_work_history, null);
        resx.moveToFirst();
        tmt_count_row = resx.getCount();
        if(tmt_count_row>0) {

            while (resx.isAfterLast() == false) {

                try {

                    @SuppressLint("Range")
                    String strtran_date = resx.getString(resx.getColumnIndex("scan_date"));
                    SimpleDateFormat format_input = new SimpleDateFormat("yyyy-MM-dd");
                    SimpleDateFormat format_output = new SimpleDateFormat("dd-MMM-yyyy");
                    try {
                        String[] arr = strtran_date.split(" ");
                        Date ddate = format_input.parse(arr[0].trim());
                        strtran_date = format_output.format(ddate);


                    } catch (Exception e) {
                        new SweetAlertDialog(Export_Activity.this, SweetAlertDialog.WARNING_TYPE)
                                .setTitleText("WARNING")
                                .setContentText(e.getMessage())
                                .show();
                    }

                    @SuppressLint("Range") String tranid = resx.getString(resx.getColumnIndex("tranid"));
                    String trandate = strtran_date;
                    @SuppressLint("Range") String scan_time = resx.getString(resx.getColumnIndex("scan_time"));
                    @SuppressLint("Range") String scancode1 = resx.getString(resx.getColumnIndex("scan_code1"));
                    @SuppressLint("Range") String scancode2 = resx.getString(resx.getColumnIndex("scan_code2"));
                    @SuppressLint("Range") String scancode3 = resx.getString(resx.getColumnIndex("scan_code3"));
                    @SuppressLint("Range") String userid = resx.getString(resx.getColumnIndex("userid"));
                    @SuppressLint("Range") String type = resx.getString(resx.getColumnIndex("type"));
                    @SuppressLint("Range") String scanstatus = resx.getString(resx.getColumnIndex("scan_status"));
                    @SuppressLint("Range") String scantypecode1 = resx.getString(resx.getColumnIndex("scan_type_code1"));
                    @SuppressLint("Range") String scantypecode2 = resx.getString(resx.getColumnIndex("scan_type_code2"));
                    @SuppressLint("Range") String scantypecode3 = resx.getString(resx.getColumnIndex("scan_type_code3"));


                    data_send = data_send + tranid + "|" + trandate + "|" + scan_time + "|" + scancode1 + "|" + scancode2 + "|" + scancode3 + "|" + userid + "|" + type + "|" + scanstatus + "|" + scantypecode1 + "|" + scantypecode2 + "|" + scantypecode3 + "|" + String.valueOf(tmt_count_row) + "#";

                    String str_up_status = "update log_transaction set export_status='Y' Where tranid='"+tranid+"'";
                    db.execSQL(str_up_status);


                    icountround++;
                    irow++;


                    if (icountround == 100) {
                        icount++;
                        byte[] bytes = data_send.getBytes(StandardCharsets.US_ASCII);
                        String codex = crc16Ccitt(bytes).toUpperCase();

                        if (codex.length() < 4) {
                            codex = "0" + codex;


                        }
                        //list.add(data_send + "" + codex);
                        String data_export = data_send + "" + codex;
                        byte[] b_data;
                        try {
                            b_data = data_export.getBytes("UTF-8");
                        } catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                        String base64export = Base64.encodeToString(b_data, Base64.DEFAULT);
                        SendData(1, base64export, 8080, txt_pcip.getText().toString().trim());
                        icountround = 0;
                        data_send="";

                    }
                    else if (irow > tmt_count_row - 1) {

                        byte[] bytes = data_send.getBytes(StandardCharsets.US_ASCII);
                        String codex = crc16Ccitt(bytes).toUpperCase();

                        if (codex.length() < 4) {
                            codex = "0" + codex;


                        }
                        //list.add(data_send + "" + codex);
                        String data_export = data_send + "" + codex;
                        byte[] b_data;
                        try {
                            b_data = data_export.getBytes("UTF-8");
                        } catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                        String base64export = Base64.encodeToString(b_data, Base64.DEFAULT);
                        SendData(1, base64export, 8080, txt_pcip.getText().toString().trim());
                        icountround = 0;
                        data_send="";
                        break;


                    }


                    resx.moveToNext();
                } catch (Exception e) {

                    e.printStackTrace();


                }
            }
            db.close();


        }

        if(tmt_count_row.equals(0))
        {

            new SweetAlertDialog(Export_Activity.this, SweetAlertDialog.WARNING_TYPE)
                    .setTitleText("WARNING")
                    .setContentText("Empty data.")
                    .show();

        }

    }

    @SuppressLint("Range")
    private  void Check_Data() {


        String filter="";
        if(datefilter.equals(""))
        {
            datefilter = " and scan_date between '" + txt_date.getText().toString().trim() + " 00:00:00' and '" + txt_dateto.getText().toString().trim() + " 23:59:59'";


        }

        filter = datefilter;
        try {
            if(chk_continue.isChecked() && !chk_all.isChecked())
            {
                filter = " and export_status!='Y' ";

            }
            else if(chk_all.isChecked() && !chk_continue.isChecked()) {

                filter = "";

            }
        }catch(Exception e) {
            e.printStackTrace();

        }




        try {

            String str_work_history = "select tranid from log_transaction Where 1=1 " + filter + "  order by CAST(tranid as real)";
            SQLiteDatabase db = DBHelper.getDB();
            db.isOpen();
            Cursor resx = db.rawQuery(str_work_history, null);
            resx.moveToFirst();
            while (resx.isAfterLast() == false) {

                try {

                    checkdata++;
                    resx.moveToNext();
                    break;
                } catch (Exception e) {

                    e.printStackTrace();

                }
            }
            db.close();
        }catch(Exception e) {

            new SweetAlertDialog(Export_Activity.this, SweetAlertDialog.WARNING_TYPE)
                    .setTitleText("WARNING")
                    .setContentText(e.getMessage())
                    .show();


        }

    }

    public static String crc16Ccitt(byte[] bytes) {


        int crc = 0xFFFF;
        int polynomial = 0x1021;
        for (byte b : bytes) {
            for (int i = 0; i < 8; i++) {
                boolean bit = ((b >> (7-i) & 1) == 1);
                boolean c15 = ((crc >> 15 & 1) == 1);
                crc <<= 1;
                if (c15 ^ bit) crc ^= polynomial;
            }
        }
        crc &= 0xffff;



        return Integer.toHexString(crc);
    }
    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.imb_back:
                clientsocket.close();
                intent = new Intent(this, SubMenu_Activity.class);
                startActivity(intent);
                break;


        }
    }

    @Override
    protected void onStart() {
        super.onStart();

    }



    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    clientsocket.close();
                    Intent intent = new Intent(this, SubMenu_Activity.class);
                    startActivity(intent);
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }

    @Override
    public void onBackPressed() {
        finishAffinity();
        System.exit(0);
    }



    private DatagramSocket UDPSocket;
    private InetAddress address;
    private int port;

    /// Initialise une socket avec les parametres recupere dans l'interface graphique pour l'envoi des données
    public void Initreseau(InetAddress address) {
        try {
            this.UDPSocket = new DatagramSocket();
            this.address = address;
        } catch (SocketException e) {
            e.printStackTrace();
        }
    }

    /// Envoi les données dans la socket defini par la methode InitReseau
    public void SendInstruction(final byte[] data, final int port) {
        new Thread() {
            @Override
            public void run() {
                try {

                    DatagramPacket packet = new DatagramPacket(data, data.length, address, port);
                    UDPSocket.send(packet);

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }.start();
    }
    private Socket socket;
    private BufferedReader input;
    /// Envoi X fois la data
    public void SendData(final int nbRepet, final String Sdata , final int port, final String address) {
        new Thread() {
            @Override
            public void run() {
                try {
                    try {
                        Initreseau(InetAddress.getByName(address));
                        for (int i = 0; i < nbRepet; i++) {
                            byte[] data = Sdata.getBytes();
                            SendInstruction(data,port);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                } catch (Exception e) {
                    //e.printStackTrace();
                }
            }
        }.start();

    }




}