package com.tomas.ht_mast.Adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_mast.Workhistory_Activity;
import com.tomas.ht_mast.ListData.Workhistory_Item;
import com.tomas.ht_mast.R;

import java.text.DecimalFormat;
import java.util.List;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class Workhistory_Adapter extends RecyclerView.Adapter<Workhistory_Adapter.ViewHolder> {
    private List<Workhistory_Item> data;
    Context context;
    DecimalFormat decimalFormat;

    public Workhistory_Adapter(List<Workhistory_Item> dataset, Context context) {
        data = dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{

        ConstraintLayout layout;
        TextView txtdate,txtpartno1,txtpartno2,txtpartno3,txtuserid,txtleader;
        public ViewHolder(View itemview){
            super(itemview);
            layout = (ConstraintLayout) itemview.findViewById(R.id.item_row);
            txtdate = (TextView)itemView.findViewById(R.id.txt_date);
            txtpartno1 = (TextView)itemView.findViewById(R.id.txt_partno1);
            txtpartno2 = (TextView)itemView.findViewById(R.id.txt_partno2);
            txtpartno3 = (TextView)itemView.findViewById(R.id.txt_partno3);
            txtuserid = (TextView)itemView.findViewById(R.id.txt_userid);
            txtleader = (TextView)itemView.findViewById(R.id.txt_leader);


        }
    }


    @NonNull
    @Override
    public Workhistory_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_partno_scan,parent,false);
        context = parent.getContext();
        return new Workhistory_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull Workhistory_Adapter.ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,#00.00");
        final Workhistory_Item item = data.get(position);
        holder.txtdate.setText(item.getTranDate());
        holder.txtpartno1.setText(item.getPartNo1());
        holder.txtpartno2.setText(item.getPartNo2());
        holder.txtpartno3.setText(item.getPartNo3());
        holder.txtuserid.setText(item.getUserID());
        holder.txtleader.setText(item.getLeader());


        String status = item.getPart_status();
        if (status.toString().trim().equals("OK")){
            holder.layout.setBackgroundResource(R.color.status_working);
        }else if (status.toString().trim().equals("NG")){
            holder.layout.setBackgroundResource(R.color.red);
        }else{//IMPORTED
            holder.layout.setBackgroundResource(R.color.status_imported);
        }

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                    Intent i = new Intent(context.getApplicationContext(), Workhistory_Activity.class);
                    i.putExtra("scan", false);
                    i.putExtra("trandate", item.getTranDate());
                    i.putExtra("partno1", item.getPartNo1());
                    i.putExtra("partno2", item.getPartNo2());
                    i.putExtra("partno3", item.getPartNo3());
                    i.putExtra("userid", item.getUserID());
                    i.putExtra("leader", item.getLeader());

                    context.startActivity(i);


            }
        });
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}

