package com.tomas.ht_mast.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_mast.ListData.ItemFifo_list;
import com.tomas.ht_mast.R;

import java.util.List;

public class ItemLabel_out_sc_Adapter extends RecyclerView.Adapter<ItemLabel_out_sc_Adapter.ViewHolder> {
        private List<ItemFifo_list> data;
        Context context;


        public ItemLabel_out_sc_Adapter(List<ItemFifo_list> dataset, Context context ) {
                data = dataset;
                this.context = context;

        }

        public class ViewHolder extends RecyclerView.ViewHolder{
                LinearLayout layout;
                TextView txt_no, txt_lot_no, txt_location, txt_qty, txt_status;
                public ViewHolder(View itemview){
                        super(itemview);
                        layout = (LinearLayout) itemview.findViewById(R.id.item_row);
//                        txt_no = (TextView)itemView.findViewById(R.id.txt_no);
                        txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
                        txt_location = (TextView)itemView.findViewById(R.id.txt_location);
                        txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
                        txt_status = (TextView)itemView.findViewById(R.id.txt_status);
                }
        }


        @NonNull
        @Override
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
                View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_sh_out_label,parent,false);
                context = parent.getContext();
                return new ViewHolder(content_view);
        }

        @Override
        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
                final ItemFifo_list item = data.get(position);
//                holder.txt_no.setText(item.getId());
                holder.txt_lot_no.setText(item.getLot_no());
                holder.txt_location.setText(item.getLocation());
                holder.txt_qty.setText( item.getQty()+"/"+item.getPlan_qty());


                Double ng =  Double.parseDouble(item.getQty());
                Double pl =  Double.parseDouble(item.getPlan_qty());
                if ( ng == 0 ){
                        holder.layout.setBackgroundResource(R.color.color_button);
                        holder.txt_status.setText("");
                }else if( ng > 0 && ng < pl){
                        holder.layout.setBackgroundResource(R.color.color_yel);
                        holder.txt_status.setText("WORKING");
                }else{
                        holder.layout.setBackgroundResource(R.color.green);
                        holder.txt_status.setText("OK");
                }
                holder.layout.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
////                                Intent i = new Intent(context.getApplicationContext(), QCCheck_Activity.class);
////                                i.putExtra("schedule_id", item.getSchedule_id());
////                                i.putExtra("order_no", item.getOrder_no());
////                                i.putExtra("part_no", item.getPart_no());
////                                i.putExtra("part_name", item.getPart_name());
////                                i.putExtra("rank", item.getRank());
////                                i.putExtra("location", item.getLocation());
////                                i.putExtra("plan_qty", item.getPlan_qty());
////                                i.putExtra("act_qty", item.getAct_qty());
////                                i.putExtra("unit", item.getUnit());
////                                i.putExtra("inspection_flg", item.getInspection_flg());
////                                context.startActivity(i);
//
//

//                                click_row_item.onClickRow(item.getLabel_id(), item.getLabel_qty(),
//                                        item.getBox_no(),item.getNg_qty(), item.getIssue_qty());
//                                click_row_item.onClickRow("1", "100", "3");
                        }


                });
        }

        @Override
        public int getItemCount() {
                return data.size();
        }
}
