package com.tomas.ht_mast;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.tomas.ht_mast.lib.ActionType;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.Settings;

public class QCMenu_Activity extends AppCompatActivity implements View.OnClickListener {

    TextView txt_user, txt_device;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_qcmenu);

        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ Settings.getLoginUser().getName());

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Device : "+Settings.getDeviceNo());
    }

    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.imb_back:
                finish();
                break;
            case R.id.btn_qc_schedule:
                Settings.setActionType(String.valueOf(ActionType.Type.QC_SCHEDULE));
                intent = new Intent(QCMenu_Activity.this, QCSchedule_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_qc_check_manual:
                Settings.setActionType(String.valueOf(ActionType.Type.QC_MANUAL));
                intent = new Intent(QCMenu_Activity.this, QCCheck_Activity.class);
                startActivity(intent);
                break;
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == KeyMapping.Down.getId() || keyCode == KeyMapping.P2.getId()
                || keyCode == KeyMapping.ENT.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case Down:
                    finish();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }
}