package com.tomas.ht_mast;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

import com.tomas.ht_mast.ListData.ItemMaster_list;
import com.tomas.ht_mast.ListData.Location_list;
import com.tomas.ht_mast.ListData.PackingStandard_list;
import com.tomas.ht_mast.ListData.Supplier_list;
import com.tomas.ht_mast.lib.ActionType;
import com.tomas.ht_mast.lib.KeyMapping;
import com.tomas.ht_mast.lib.Settings;
import com.tomas.ht_mast.lib.common.AsyncHttpClient;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class InboundMenu_Activity extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_inbound_menu);

        txt_user = (TextView) findViewById(R.id.txt_user);
        txt_user.setText("User : "+ Settings.getLoginUser().getName());

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Device : "+Settings.getDeviceNo());


    }

    @Override
    public void onClick(View view) {
        Intent intent;
        switch (view.getId()) {
            case R.id.imb_back:
                finish();
                break;
            case R.id.btn_sch_label:
                Settings.setActionType(String.valueOf(ActionType.Type.LABEL_SCHEDULE));
                intent = new Intent(InboundMenu_Activity.this, LabelSchedule_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_label_manual:
                intent = new Intent(InboundMenu_Activity.this, LabelManualMenu_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_inbound_sch:
                Settings.setActionType(String.valueOf(ActionType.Type.INBOUND_SCHEDULE));
                intent = new Intent(InboundMenu_Activity.this, InboundSchedule_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_inbound_manual:
                Settings.setActionType(String.valueOf(ActionType.Type.INBOUND_MANUAL));
                intent = new Intent(InboundMenu_Activity.this, InboundDetail_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_qc_check:
                intent = new Intent(InboundMenu_Activity.this, QCMenu_Activity.class);
                startActivity(intent);
                break;

            case R.id.btn_photo:
                intent = new Intent(InboundMenu_Activity.this, Photomatching.class);
                startActivity(intent);
                break;
        }
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == KeyMapping.Down.getId() || keyCode == KeyMapping.P2.getId()
                || keyCode == KeyMapping.ENT.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case Down:
                    finish();
                    break;
            }
        }

        return super.onKeyUp(keyCode, event);
    }
}