package com.tomas.ht_mast.Adapter;

import static android.content.ContentValues.TAG;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_mast.ListData.ScheduleQc_Item;
import com.tomas.ht_mast.OutboundSchedule_Activity;
import com.tomas.ht_mast.QCCheck_Activity;
import com.tomas.ht_mast.R;

import java.text.DecimalFormat;
import java.util.List;

import cn.pedant.SweetAlert.SweetAlertDialog;

public class ScheduleQc_Adapter extends RecyclerView.Adapter<ScheduleQc_Adapter.ViewHolder> {
    private List<ScheduleQc_Item> data;
    Context context;
    DecimalFormat decimalFormat;

    public ScheduleQc_Adapter(List<ScheduleQc_Item> dataset, Context context) {
        data = dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        ConstraintLayout layout;
        TextView txt_order_no, txt_supplier, txt_part_no, txt_part_name, txt_rank, txt_location, txt_qty;
        public ViewHolder(View itemview){
            super(itemview);
            layout = (ConstraintLayout) itemview.findViewById(R.id.item_row);
            txt_order_no = (TextView)itemView.findViewById(R.id.txt_order_no);
            txt_supplier = (TextView)itemView.findViewById(R.id.txt_supplier);
            txt_part_no = (TextView)itemView.findViewById(R.id.txt_part_no);
            txt_part_name = (TextView)itemView.findViewById(R.id.txt_part_name);
            txt_rank = (TextView)itemView.findViewById(R.id.txt_rank);
            txt_location = (TextView)itemView.findViewById(R.id.txt_location);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);

        }
    }


    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_qc_schedule,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,#00.00");
        final ScheduleQc_Item item = data.get(position);
        holder.txt_order_no.setText(item.getOrder_no());
        holder.txt_supplier.setText(item.getSupplier_name());
        holder.txt_part_no.setText(item.getPart_no());
        holder.txt_part_name.setText(item.getPart_name());
        holder.txt_rank.setText(item.getRank());
        holder.txt_location.setText("Location : "+item.getLocation());
        holder.txt_qty.setText(decimalFormat.format(Double.parseDouble(item.getAct_qty())) +"/"+decimalFormat.format(Double.parseDouble(item.getPlan_qty()))+" "+item.getUnit());

        String status = item.getStatus();
        if (status.toString().trim().equals("COMPLETED")){
            holder.layout.setBackgroundResource(R.color.status_completed);
        }else if (status.toString().trim().equals("WORKING")){
            holder.layout.setBackgroundResource(R.color.status_working);
        }else{//IMPORTED
            holder.layout.setBackgroundResource(R.color.status_imported);
        }

        holder.layout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (!status.trim().equals("COMPLETED")) {
                    Log.d(TAG, "onBindViewHolder: status" + status);


                    Intent i = new Intent(context.getApplicationContext(), QCCheck_Activity.class);
                    i.putExtra("schedule_id", item.getSchedule_id());
                    i.putExtra("order_no", item.getOrder_no());
                    i.putExtra("part_no", item.getPart_no());
                    i.putExtra("part_name", item.getPart_name());
                    i.putExtra("rank", item.getRank());
                    i.putExtra("location", item.getLocation());
                    i.putExtra("plan_qty", item.getPlan_qty());
                    i.putExtra("act_qty", item.getAct_qty());
                    i.putExtra("unit", item.getUnit());
                    i.putExtra("inspection_flg", item.getInspection_flg());
                    i.putExtra("ref_id", item.getRef_id());
                    i.putExtra("warehouse", item.getWarehouse());
                    context.startActivity(i);
                }
                else{
                    new SweetAlertDialog(context, SweetAlertDialog.WARNING_TYPE)

                            .setTitleText("ERROR")
                            .setContentText("This order is completed")
                            .show();
                }
            }
        });
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
